#version 330

in vec3 position;
in vec2 texture;
in vec3 normal;

uniform mat4 projectionMatrix;
uniform mat4 worldMatrix;
uniform mat4 modelMatrix;

out VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
} vs_out;



void main() {
    gl_Position = projectionMatrix * worldMatrix * modelMatrix * vec4(position, 1.0);
    vs_out.FragPos = (modelMatrix * vec4(position, 1.0)).xyz;
    // vs_out.Normal = (modelMatrix * vec4(normal, 0.0)).xyz;
    vs_out.Normal = mat3(transpose(inverse(modelMatrix))) * normal;
    vs_out.TexCoords = texture;

}
