#version 330

in VS_OUT {
    vec3 FragPos;
    vec3 Normal;
    vec2 TexCoords;
    float TextureID;
} fs_in;
out vec4 FragColor;

uniform vec3 viewPos;
uniform vec4 externalColor;

uniform sampler2D texture0;
uniform sampler2D texture1;

struct PointLight {
    vec3 position;

    float constant;
    float linear;
    float quadratic;

    vec3 ambient;
    vec3 diffuse;
    vec3 specular;
};

const int NUM_LIGHTS = 3;

uniform PointLight pointLights[NUM_LIGHTS];
// calculates the color when using a point light.

vec3 CalcPointLight(PointLight light, vec3 normal, vec3 fragPos, vec3 viewDir, vec3 tex)
{
    vec3 lightDir = normalize(light.position - fragPos);
    // diffuse shading
    float diff = max(dot(normal, lightDir), 0.0);
    // specular shading
    vec3 reflectDir = reflect(-lightDir, normal);
    // float shininess = 128.0;
    float shininess = 256.0;
    float spec = pow(max(dot(viewDir, reflectDir), 0.0), shininess);
    // attenuation
    float distance = length(light.position - fragPos);
    float attenuation = 1.0 / (light.constant + light.linear * distance + light.quadratic * (distance * distance));
    // combine results
    vec3 ambient = light.ambient * tex;
    vec3 diffuse = light.diffuse * diff * tex;
    vec3 specular = light.specular * spec * tex;
    ambient *= attenuation;
    diffuse *= attenuation;
    specular *= attenuation;
    return (ambient + diffuse + specular);
}


out vec4 color;

void main() {
        vec3 ecolor = externalColor.xyz;
        vec3 texsampled = vec3(0.0, 0.0, 0.0);
        int id = int(fs_in.TextureID);
        if (fs_in.TextureID > 0)
            texsampled = texture(texture1, fs_in.TexCoords).rgb;
        else
            texsampled = texture(texture0, fs_in.TexCoords).rgb;

        vec3 norm = normalize(fs_in.Normal);
        vec3 viewDir = normalize(viewPos - fs_in.FragPos);

        vec3 result = vec3(0.0, 0.0, 0.0);
        for(int i = 0; i < NUM_LIGHTS; i++)
            result += CalcPointLight(pointLights[i], fs_in.Normal, fs_in.FragPos, viewDir, texsampled);

        FragColor = vec4(result, 1.0);
}

