#version 330
layout (location=0) in vec3 position; // position of the vertex in 3D space
layout (location=1) in vec2 texture;  // texture coordinate
layout (location=2) in vec3 normal;   // normal vector

out vec2 vTexture;

uniform mat4 projectionMatrix;
uniform mat4 worldMatrix;
uniform mat4 modelMatrix;

void main()
{
    gl_Position = projectionMatrix * worldMatrix * modelMatrix * vec4(position, 1.0);
    vTexture = texture;
}