//----------------------------------------------------------------------------------
// File:        gl4-kepler\WeightedBlendedOIT\assets\shaders/weighted_blend_fragment.glsl
// SDK Version: v3.00 
// Email:       gameworks@nvidia.com
// Site:        http://developer.nvidia.com/
//
// Copyright (c) 2014-2015, NVIDIA CORPORATION. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//  * Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
//  * Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//  * Neither the name of NVIDIA CORPORATION nor the names of its
//    contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//----------------------------------------------------------------------------------
#version 410


layout(location=0) in vec3 vTexCoord;
layout(location=1) in vec2 vModelTex;

uniform sampler2D modelTexture;
uniform float uDepthScale;
uniform float uAlpha;
vec4 ShadeFragment()
{
    vec4 color;

    float xWorldPos = vTexCoord.x;
    float yWorldPos = vTexCoord.y;
    float diffuse = vTexCoord.z;

    float Freq = 4.0;
    float i = floor(xWorldPos * Freq);
    float j = floor(yWorldPos * Freq);
    color.rgb = (mod(i, 2.0) == 0) ? vec3(.4,.85,.0) : vec3(1.0);

    color.rgb *= diffuse;
    color.a = uAlpha;
    return color;
}

layout(location=0) out vec4 oSumColor;
layout(location=1) out vec4 oSumWeight;

void main(void)
{
    // vec4 color = ShadeFragment();
    vec4 color = texture(modelTexture, vModelTex);
    color.a = uAlpha;
    // vec4 color = vec4(0.0, 0.0, 1.0, 1.0);

    // Assuming that the projection matrix is a perspective projection
    // gl_FragCoord.w returns the inverse of the oPos.w register from the vertex shader
    float viewDepth = abs(1.0 / gl_FragCoord.w);

    // Tuned to work well with FP16 accumulation buffers and 0.001 < linearDepth < 2.5
    // See Equation (9) from http://jcgt.org/published/0002/02/09/
    float linearDepth = viewDepth * uDepthScale;
    float weight = clamp(0.03 / (1e-5 + pow(linearDepth, 4.0)), 1e-2, 3e3);
    // oSumColor = vec4(color.rgb * color.a, color.a) * weight;
    oSumWeight = vec4(color.a);



    oSumColor = vec4(color.rgb * color.a, color.a) * weight;
    // oSumWeight = vec4(color.a);
    // oSumColor = vec4(1.0, 1.0, 1.0, 1.0);
    // oSumWeight = vec4(1.0, 1.0, 1.0, 1.0);
}
