function do_all() {

var PI = 3.145826

var mat4 = {
	rotZ: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			c, s, 0, 0,
			-s, c, 0, 0,
			0, 0, 1, 0,
			0, 0, 0, 1,
		];
	},
	rotX: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			1, 0, 0, 0,
			0, c, -s, 0,
			0, s, c, 0,
			0, 0, 0, 1,
		];
	},
	rotY: function(rad){
		var c = Math.cos(rad);
		var s = Math.sin(rad);
		return [
			c, 0, s, 0,
			0, 1, 0, 0,
			-s, 0, c, 0,
			0, 0, 0, 1,
		];
	},
	trans: function(tx, ty, tz){
		return [
			1, 0, 0, 0,
			0, 1, 0, 0,
			0, 0, 1, 0,
			tx, ty, tz, 1,
		];
	},
    persproj: function(fov, aspect, far=10, near=0.2) {
        var S = 1/Math.tan(fov/2*PI/180);
        return [
            S, 0, 0, 0,
            0, S*aspect, 0, 0,
            0, 0, -far/(far-near), -1,
            0, 0, -(far*near)/(far-near), 0,
        ];
    },
    multiply: function (m1, m2) {
        var matrix = [];

        for (i=0; i<4; i++){
            for (j=0; j<4; j++){
                ii = 4*i;
                matrix.push(
                    m1[j]*m2[ii]+m1[j+4]*m2[ii+1]+m1[j+8]*m2[ii+2]+m1[j+12]*m2[ii+3]
                );
            }
        }
        return matrix;
    },
    multiplyVec: function matVec4Multiply(m, vec) {
        // 4x4 matrix and 4x1 vector multiply
        var resvec = [];

        for (i=0; i<4; i++){
            resvec.push(
                (m[i+0]*vec[0]+m[i+4]*vec[1]+m[i+8]*vec[2]+m[i+12]*vec[3])
            );
        }
        return resvec;
    },
};

var RES = [1920, 1080]
var PROJ = mat4.persproj(90, 16/9, 100000);
var FLOOR_TRANS = mat4.multiply(mat4.trans(0,0.4,0),mat4.rotX(1.3));

var point = (x,y) => {return [x, y, 1., 1.]};
var point3 = (x,y,z) => {return [x, y, z, 1.]};

function rand(seed) {
    let a = Math.sin(seed*100000);
    return Math.abs(a-Math.floor(a));
}

function init_canvas() {
    var canvas = document.createElement('canvas');
    canvas.width = RES[0];
    canvas.height = RES[1];
    canvas.style.position = 'absolute';
    canvas.style.width = '100%';
    canvas.style.height = '100%';
    canvas.style.top = 0; canvas.style.left = 0;
    canvas.style.zindex = -1;
    document.body.appendChild(canvas);
    return canvas;
}

function drawcoord(vec4) {
    if (vec4[3] <= 0)
        return [(vec4[0]/-vec4[2]*.5+.5)*RES[0], (vec4[1]/-vec4[2]*.5+.5)*RES[1]];
    else
        return [];
}

function draw_poly(ctx, pts, stroke='', fill='', width=1) {

    ctx.beginPath();
    let b = drawcoord(pts.shift())
    if (b)
        ctx.moveTo(b[0],b[1]);
    pts.forEach(p => {let a = drawcoord(p); if (a) ctx.lineTo(a[0],a[1]);});
    ctx.closePath();
    if (stroke) {
        ctx.strokeStyle=stroke;
        ctx.lineWidth = width;
        ctx.stroke();
    }
    if (fill) {
        ctx.fillStyle = fill;
        ctx.fill();
    }
}

function rect(x=1,y=1){
    return [[-x/2,-y/2,0,1], [x/2,-y/2,0,1], [x/2,y/2,0,1],[-x/2,y/2,0,1]];
}

function square(s=1) {
    return rect(x=s,y=s);
}

function cube(size=1) {
    return [
        [-size/2,-size/2,-size/2,1], [size/2,-size/2,-size/2,1], [size/2,size/2,-size/2,1],[-size/2,size/2,-size/2,1],
        [-size/2,-size/2,-size/2,1], [-size/2,-size/2,size/2,1], [size/2,-size/2,size/2,1], [size/2,-size/2,-size/2,1],
        [size/2,-size/2,size/2,1], [size/2,size/2,size/2,1], [size/2,size/2,-size/2,1],
        [size/2,size/2,size/2,1], [-size/2,size/2,size/2,1], [-size/2,-size/2,size/2,1],
        [-size/2,size/2,size/2,1], [-size/2,size/2,-size/2,1]
    ];
}

function vertexTransform(mat, poly) {
    return poly.map(p => mat4.multiplyVec(mat,p));
}

function draw_mountain(ctx, t, m=1) {
    let back = 50;
    let width = 10;
    let last_layer = [point3(-10*m,1,back), point3(-7*m,2,back), point3(-3*m,2,back),point3(-0*m,5,back)];
    let mat = mat4.multiply(PROJ,mat4.multiply(mat4.trans(-10*m,0,0),mat4.rotX(-0.27)));
    for (let i=back; i>=1; i-=1){

        let s = Math.sin(i*0.1+t*0.001);
        let layer = [
            point3(-10*m,0+rand(i*100)*2+s,i),
            point3(-7*m+rand(i*102)+s,2+rand(200*i)*2,i),
            point3(-3*m+rand(i*400)+s,1+rand(400*i)*4,i),
            point3(-0*m+rand(i*220)+s,5,i)];

        for (let j=0; j<layer.length; ++j){
            if (m<0)
                k = layer.length-j-1;
            else
                k = j;
            if (j<layer.length-1){
                draw_poly(ctx, vertexTransform(mat, [layer[k],last_layer[k],last_layer[k+m]]), '#000', '#618', 2)
                draw_poly(ctx, vertexTransform(mat, [layer[k],layer[k+m],last_layer[k+m]]), '#000', '#625', 2)
            }
        }
        last_layer = layer.slice();
    }
}


function draw_sky(ctx, t) {
    var sky_trans = mat4.trans(0,-3.8,10);
    let backdrop = rect(50,10);
    let m = mat4.multiply(PROJ, sky_trans);

    let grd = ctx.createLinearGradient(0, 0, 0, RES[1]/2);
    grd.addColorStop(0, '#302');
    grd.addColorStop(.3, '#503');
    grd.addColorStop(1, '#540');

    draw_poly(ctx, vertexTransform(m,backdrop), '#000',grd,1);
    // sun
    let sunGrad = ctx.createLinearGradient(0, 0, 0, RES[1]/3)
    sunGrad.addColorStop(0, '#ff0');
    sunGrad.addColorStop(1, '#820');
    ctx.beginPath(); ctx.arc(0.5*RES[0],0.2*RES[1],200,0,2*Math.PI);
    ctx.fillStyle = sunGrad; ctx.fill();

    for (let y=0.25; y < 0.5; y += 0.04){
        ctx.beginPath(); ctx.rect(0,y*RES[1],RES[0],y*100);
        ctx.fillStyle = grd; ctx.fill();
    }
}

function draw_floor(ctx, t) {

    var gap = .5;
    for (let i=0; i<10; i+=gap) {
        for (let j=0; j<12; j+=gap){
            let matrix = mat4.multiply(
                PROJ,
                mat4.multiply(
                    FLOOR_TRANS,
                    mat4.trans(-2.5+i*gap,-5.+j*gap+(0.001*t)%gap,0.),
                )
            );
            let s = vertexTransform(
                matrix,
                square(gap)
            );
            draw_poly(ctx, s, '#634', '#202', 10/(-s[0][2]));
        }
    }

}

function draw_tunnel(ctx, t) {

    let gap = .5;
    for (let i = -16.; i < 0.; i+=gap){
        let wall = square(2);
        let z = i+(0.001*t)%gap
        let loc = mat4.trans(0,0.2*Math.sin(0.001*t+0.8*z),-z);
        let world = mat4.multiply(
            mat4.multiply(PROJ,loc),
            mat4.rotZ(0.0001*t + 0.1*z)
        );
        draw_poly(ctx, vertexTransform(world,wall), '#000', '', 10/-i);
    }

}

function draw_cube(ctx, t) {

    let box = cube(.4)
    let boxLoc = mat4.trans(0.5*Math.sin(0.001*t),0.5*Math.cos(0.001*t),2.+.2*Math.sin(0.001*t));
    let rotSpeed = 0.001;
    let world = mat4.multiply(
        mat4.multiply(PROJ,boxLoc),
        mat4.multiply(mat4.rotY(rotSpeed*t),mat4.rotX(rotSpeed*t))
    );
    let transformed = vertexTransform(world,box);
    draw_poly(ctx, transformed, '#3af', '', 10);

}


function main() {
    let canvas = init_canvas();
    let ctx = canvas.getContext("2d");
    let audio = new AudioContext;

    function synth(t) {
        let osc = audio.createOscillator();
        let gain = audio.createGain();
        gain.connect(audio.destination);
        osc.type = 'square';
        osc.connect(gain);

        osc.frequency.setValueAtTime(350+rand(t)*100, t);
        gain.gain.setValueAtTime(.1, t);

        gain.gain.exponentialRampToValueAtTime(0.0001, t + 3);

        osc.start(t);

        osc.stop(t + 100);
    }

    function hitbass(t) {
        let osc = audio.createOscillator();
        let gain = audio.createGain();
        gain.connect(audio.destination);
        osc.type = 'sine';
        osc.connect(gain);

        osc.frequency.setValueAtTime(250, t);
        gain.gain.setValueAtTime(1, t);

        osc.frequency.exponentialRampToValueAtTime(0.01, t + 0.5);
        gain.gain.exponentialRampToValueAtTime(0.01, t + 0.5);

        osc.start(t);

        osc.stop(t + 0.5);
    }

    let time_to_phase = 1000;
    let phase = -1;

    let lastBass = 0;
    let notes = 0;
    function callBack(time){
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        
        if (time_to_phase - time < 0) {
            phase += 1;
            time_to_phase = time + 10000;
        }
    
        if (phase < 2) {
            draw_tunnel(ctx, time);
        }
        if (phase > 1) {
            draw_sky(ctx, time);
            draw_floor(ctx, time);
        }
        if (phase > 2) {
            draw_mountain(ctx, time);
            draw_mountain(ctx, time, -1);
            if (notes > 2) {
                notes = 0;
                synth(audio.currentTime);
            }
        }
        if (phase > 0) {
            if (time-lastBass > 500.){
                ++notes;
                hitbass(audio.currentTime);
                lastBass = time;
            }
            draw_cube(ctx, time);
        }
        if (phase > 4) {
            ctx.clearRect(0, 0, canvas.width, canvas.height);
            audio.close();
        }

        window.requestAnimationFrame(callBack);
    }

    callBack(0);
}

main();

}
do_all();
