// TEDhno 8 by Blueberry / Loonies
//
// An audiovisual glitch demo for the Commodore 16
// presented in the Lovebyte 2021 8-byte intro showcase
//
// Start with SYS 1322

* = $052a
Start:
    inc $ff10,x // Beat up some TED register
    lda $a5     // Read 60 Hz timer
    and #$07
    tax
    // Memory here (at $0532) contains the bytes
    // 10 F6
    // corresponding to
    // bpl Start
    // causing the code to loop.

// Depending on how you look at it, this can be regarded
// as either an 8-byte or a 10-byte intro:
//
// - Payload (Lovebyte compo rules definition):  8 bytes
// - Bytes in file (load address + payload):    10 bytes
// - Code executed (could be located anywhere): 10 bytes

// You can download a capture from:
// http://crinkler.net/TEDhno8_1min.avi
// http://crinkler.net/TEDhno8_5min.avi (if you can't get enough)
