import QtQuick 2.0
import QtGraphicalEffects 1.0
import "./_SharedQML"
import AdaptDemoSystem 1.0

Scene {
  id: debugInfo

  property string name: "DebugInfo"
  property string sceneName: ""
  property string sceneDir: "fx/"+sceneName+"/"
  property bool bSceneEnabled: true
  sceneEnabled: bSceneEnabled
  enabled: bSceneEnabled

  anchors.fill: parent

  Connections {
    target: root
    onDemoLoaded: {
      loaderImage.visible = false;
      bSceneEnabled = false;
    }
    onStartLoading: {
      loaderImage.visible = true;
      bSceneEnabled = true;
    }
  }

  onSetSceneName: {
    sceneName = sn;
    name = sn;
  }

  Item {
    id: debugTexts
    layer.enabled: true
    width: demo.windowWidth
    height: demo.windowHeight

    Item {
      opacity: 1.0
      id: texts
      anchors.fill: parent
      Item {
        id: loaderImage
        anchors.fill: parent
        Image {
          anchors.fill: parent
          source: root.loaderImageFile
        }
      }

    }

  }

  DrawRT {
    visible: bSceneEnabled
    enabled: bSceneEnabled
    textureItem: debugTexts
    flip: false
  }


}

