import QtQuick 2.4
import AdaptDemoSystem 1.0
import "./"
import "./_SharedQML"

GridView {
  property var listKeys
  property var presets

  property var filter: fxFilter
  property var sortMode: viewSortMode

  property int modelSet: 0


  anchors.left: parent.left
  anchors.leftMargin: 5

  width: parent.width
  height: contentHeight

  function applyFilter() {
    if (presets === undefined) {
      return;
    }
    var keys = Object.keys(presets);
    var keysFiltered = []
    var filtersLower = filter.split(",");
    for (var ii=0; ii<filtersLower.length; ii++) {
      filtersLower[ii] = filtersLower[ii].toLowerCase().trim();
    }

    for (var i=0; i<keys.length; i++) {
      if (filter === "") {
        keysFiltered.push(keys[i]);
      } else {
        for (ii=0; ii<filtersLower.length; ii++) {
          if (ii > 0 && filtersLower[ii]==="") {
            continue;
          }

          if (keys[i].toLowerCase().indexOf(filtersLower[ii]) !== -1) {
            keysFiltered.push(keys[i]);
            break;
          }
        }
      }
    }
    listKeys = keysFiltered;

    if (sortMode !== 0) {
      listKeys = listKeys.sort(function(ka, kb) {
        var kan = ka.substring(ka.length-4, ka.length);
        var kab = kb.substring(kb.length-4, kb.length);
        return kab-kan;
      });
    }

    clearPresetPreview();

    model = listKeys.length;
  }

  onPresetsChanged: {
    applyFilter();
  }

  onModelSetChanged: {
    applyFilter();
  }

  onFilterChanged: {
    applyFilter();
  }

  onSortModeChanged: {
    applyFilter();
  }




  property string title

  header: Text {
    id: headerText
    text: title
    color: "white"
  }

  cellWidth: 88
  cellHeight: 100

  // model: presetsCount
  interactive: false
  delegate: Item {
    id: presetItem
    width: 80
    height: 80+14

    Connections {
      target: presetsEditView
      onClearPreviews: {
        presetTargetInstance = "";
        previewActive = false;
      }
    }

    property string presetName: (presets && listKeys) ? presets[listKeys[index]].name : ""
    property string presetFxType: (presets && listKeys) ? presets[listKeys[index]].fxType : ""

    property string presetTargetInstance: ""

    property bool previewActive: false

    Rectangle {
      anchors.fill: parent
      color: "black"
      border.width: presetItem.previewActive ? 3 : 1
      border.color: "white"
    }

//    Rectangle {
//      anchors.fill: topText
//      color: "#444444"
//      border.width: 1
//      border.color: "white"
//    }
    Text {
      anchors.bottom: parent.bottom
      anchors.left: parent.left
      anchors.right: parent.right
      anchors.bottomMargin: 4
      height: 14
      horizontalAlignment: Text.AlignHCenter
      text: "<b>"+presetTargetInstance+"</b>"
      color: "white"
    }

    Text {
      id: nameText
      anchors.fill: parent
      anchors.margins: 4
      text: presetName
      verticalAlignment: Text.AlignVCenter
      horizontalAlignment: Text.AlignHCenter
      color: "white"
      wrapMode: Text.Wrap
    }

    Rectangle {
      anchors.fill: iconsImg
      color: "white"
    }

    Image {
      id: iconsImg
      anchors.top: parent.top
      anchors.left: parent.left
      anchors.margins: 2
      width: 24
      height: 24
      source: presetFxType !== "" ? "../icons/"+presetsEditView.icons[presetFxType] : ""
    }

    MouseArea {
      anchors.fill: parent
      onClicked: {
        if (!listKeys) {
          log("ERROR FX presets listKeys undefined")
          return;
        }

        var bPresetPreviewActive = (previewPresetActive && previewPresetActive[presetName] !== undefined && previewPresetActive[presetName]===true);

        if (bPresetPreviewActive) {
          removePresetPreview(presets[listKeys[index]]);
          presetItem.previewActive = false;
          presetItem.presetTargetInstance = "";
        } else {
          var presetIndex = addPresetPreview(presets[listKeys[index]], true);
          presetItem.previewActive = true;
          presetItem.presetTargetInstance = previewPresets[presetIndex].instance;
        }
        rocket.markUpdateFrequent();
      }
    }
  }
}
