import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    // generic mesh just named box :)
    id: box
    name: "breakin"
    effectName: "BreakIn"
    property string shader: "smBreakIn"

    property bool drawOnly: false

    property alias autoCenter: meshInst.autoCenter
    property alias autoScale: meshInst.autoScale

    property real uvScale: s("mat.texAll.uvScale")


    property bool setShader: true
    property var depthTestIn: undefined
    property bool depthTestActive: (depthTestIn !== undefined) ? depthTestIn : (s("depthEnabled", 1.0) > 0.5)

    property var depthWriteIn: undefined
//    property bool depthWriteActive: (depthWriteIn !== undefined) ? depthWriteIn : ((s("depthEnabled", 1.0)>0.5) && s("depthWrite", 1.0)>0.5)
    property bool depthWriteActive: (depthWriteIn !== undefined) ? depthWriteIn : s("depthWrite", 1.0)>0.5


    property var fixedTimeStepIn: undefined


    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }


    TextureSel { id: texBump; nameOverride: box.name+".mat.bump.texInd"; textureUnit: 1; }
    property int bumpTex: s("mat.bump.texInd")

    TextureSel { nameOverride: box.name+".mat.texLay1.texInd"; textureUnit: 0; }
    property int texLay1: s("mat.texLay1.texInd", 0.0)
    TextureSel { nameOverride: box.name+".mat.texLay2.texInd"; textureUnit: 6; }
    property int texLay2: s("mat.texLay2.texInd", 0.0)
    TextureSel { nameOverride: box.name+".mat.texLay3.texInd"; textureUnit: 7; }
    property int texLay3: s("mat.texLay3.texInd", 0.0)


    property string shaderVaryings: "vec3 posG;"

    property int instCount: s("num", 100)

    Shader {
      enabled: setShader
      file: shader
    }

    DrawMesh {
        id: meshInst
        property string name: box.name
        file: meshSel(box.name)
        depthTest: depthTestActive
        depthWrite: depthWriteActive
        blendMode: blendSel(box.name)
        autoCenter: false
        autoScale: false
        instanceVBO: drawOnly ? sceneName+"_breakInFixed"+box.name : sceneName+"_breakIn"+box.name
        instanceCount: instCount

        smoothNormals: true; normalSmoothAngle: 60;

        property real sca: s("inst.scale", 1.0)
        property real scaX: s("inst.scaleX", 1.0)
        property real scaY: s("inst.scaleY", 1.0)
        property real scaZ: s("inst.scaleZ", 1.0)

        Sca { s: meshInst.sca; x: meshInst.scaX; y: meshInst.scaY; z: meshInst.scaZ }

        property real posX: s("trans.posX", 0.0)
        property real posY: s("trans.posY", 0.0)
        property real posZ: s("trans.posZ", 0.0)
        ShaderParam { paramName: "g_globalRot"; paramValueVec4: s("trans.rotX", 0.0)+","+s("trans.rotY", 0.0)+","+s("trans.rotZ", 0.0) }
        ShaderParam { paramName: "g_globalScale"; paramValueVec4: s("trans.scale", 1.0)+",0.0,0.0,0.0" }


        ShaderParam { paramName: "g_animHeight"; paramValue: animHeight }

        ShaderParam { paramName: "g_uvRandom"; paramValueVec4: s("uvRandom", 0.0)+","+s("uvScaleMin", 0.0)+","+s("uvScaleMax", 100.0) }
        ShaderParam { paramName: "g_uvOfsRand"; paramValueVec4: s("uvOfsXRand", 0.0)+","+s("uvOfsYRand", 0.0)+",0.0" }

        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: s("prevBlur", 0.0) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: s("prevBlurType", 0.0) }

        ShaderParam { paramName: "g_alpha"; paramValue: s("mat.alpha", 1.0) }

        ShaderParam { paramName: "normalAlpha"; paramValue: s("mat.alphaNormal", 1.0) }

        // mat.texAll master settings
        ShaderParam { paramName: "g_texBrightness"; paramValue: s("mat.texAll.amp", 1.0) }
        ShaderParam { paramName: "g_genUV"; paramValue: s("mat.texAll.genUV", 1.0) }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*s("mat.texAll.uvAspect", 1.0))+","+(uvScale+","+uvScale)}
        ShaderParam { paramName: "g_uvOfsX"; paramValue: sf("mat.texAll.uvOfsX", 0.0) }
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sf("mat.texAll.uvOfsY", 0.0) }
        ShaderParam { paramName: "g_repPow"; paramValue: syncIn(box.name+".mat.texAll.pow", 1.0) }

        ShaderParam { paramName: "bumpTexInd"; paramValue: bumpTex }
        ShaderParam { paramName: "bumpStrength"; paramValue: s("mat.bump", 0.0) }


        ShaderParam { paramName: "g_mode"; syncName: ns("mode"); syncDefault: 0.0 }

        ShaderParam { paramName: "dispAmp"; syncFFTName: nse("pardex", "noise.amp") }
        ShaderParam { paramName: "dispExp"; syncName: nse("pardex", "noise.exp") }
        ShaderParam { paramName: "noiseOfsX"; syncName: nse("pardex", "noise.ofs.x") }
        ShaderParam { paramName: "noiseOfsY"; syncName: nse("pardex", "noise.ofs.y") }
        ShaderParam { paramName: "noisePos"; syncName: nse("pardex", "noise.pos") }
        ShaderParam { paramName: "noiseFreq"; syncName: nse("pardex", "noise.freq") }
        ShaderParam { paramName: "noiseOct"; syncName: nse("pardex", "noise.oct.num") }
        ShaderParam { paramName: "noiseOctMul"; syncName: nse("pardex", "noise.oct.mul") }
        ShaderParam { paramName: "noiseOctAmp"; syncName: nse("pardex", "noise.oct.amp") }

        // mat.texLay1 settings
        ShaderParam { paramName: "g_repTex1"; paramValue: texLay1 }
        ShaderParam { paramName: "g_repUVBase1"; paramValue: syncIn(box.name+".mat.texLay1.base", 1.0) }
        ShaderParam { paramName: "g_repUVOp1"; paramValue: syncIn(box.name+".mat.texLay1.op", 1.0) }
        ShaderParam { paramName: "g_repUVAmp1"; paramValue: syncIn(box.name+".mat.texLay1.amp", 1.0) }
        ShaderParam { paramName: "g_repUVSca1"; paramValue: syncIn(box.name+".mat.texLay1.sca", 1.0) }
        ShaderParam { paramName: "g_repUVOfsX1"; paramValue: syncIn(box.name+".mat.texLay1.ofsX", 0.0) }
        ShaderParam { paramName: "g_repUVOfsY1"; paramValue: syncIn(box.name+".mat.texLay1.ofsY", 0.0) }
        ShaderParam { paramName: "g_repUVRot1"; paramValue: syncIn(box.name+".mat.texLay1.rot", 0.0) }

        // mat.texLay2 settings
        ShaderParam { paramName: "g_repTex2"; paramValue: texLay2 }
        ShaderParam { paramName: "g_repUVBase2"; paramValue: syncIn(box.name+".mat.texLay2.base", 0.0) }
        ShaderParam { paramName: "g_repUVOp2"; paramValue: syncIn(box.name+".mat.texLay2.op", 0.0) }
        ShaderParam { paramName: "g_repUVAmp2"; paramValue: syncIn(box.name+".mat.texLay2.amp", 1.0) }
        ShaderParam { paramName: "g_repUVSca2"; paramValue: syncIn(box.name+".mat.texLay2.sca", 1.0) }
        ShaderParam { paramName: "g_repUVOfsX2"; paramValue: syncIn(box.name+".mat.texLay2.ofsX", 0.0) }
        ShaderParam { paramName: "g_repUVOfsY2"; paramValue: syncIn(box.name+".mat.texLay2.ofsY", 0.0) }
        ShaderParam { paramName: "g_repUVRot2"; paramValue: syncIn(box.name+".mat.texLay2.rot", 0.0) }

        // mat.texLay3 settings
        ShaderParam { paramName: "g_repTex3"; paramValue: texLay3 }
        ShaderParam { paramName: "g_repUVBase3"; paramValue: syncIn(box.name+".mat.texLay3.base", 0.0) }
        ShaderParam { paramName: "g_repUVOp3"; paramValue: syncIn(box.name+".mat.texLay3.op", 0.0) }
        ShaderParam { paramName: "g_repUVAmp3"; paramValue: syncIn(box.name+".mat.texLay3.amp", 1.0) }
        ShaderParam { paramName: "g_repUVSca3"; paramValue: syncIn(box.name+".mat.texLay3.sca", 1.0) }
        ShaderParam { paramName: "g_repUVOfsX3"; paramValue: syncIn(box.name+".mat.texLay3.ofsX", 0.0) }
        ShaderParam { paramName: "g_repUVOfsY3"; paramValue: syncIn(box.name+".mat.texLay3.ofsY", 0.0) }
        ShaderParam { paramName: "g_repUVRot3"; paramValue: syncIn(box.name+".mat.texLay3.rot", 0.0) }

        ShaderParam { paramName: "g_emitThr"; paramValue: s("palaEmit.thr", 0.5) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: s("palaEmit.amp", 1.0) }

        ShaderParam { paramName: "g_pos"; paramValueVec4: meshInst.posX+","+meshInst.posY+","+meshInst.posZ }
        ShaderParam { paramName: "g_cen"; paramValueVec4: s("inst.cenX", 0.0)+","+ s("inst.cenY", 0.0)+","+ s("inst.cenZ", 0.0) }
        ShaderParam { paramName: "g_rot"; paramValueVec4: s("inst.rotX", 0.0)+","+s("inst.rotY", 0.0)+","+s("inst.rotZ", 0.0) }
        ShaderParam { paramName: "g_rotDel"; paramValueVec4: s("inst.rotXDel", 0.0)+","+s("inst.rotYDel", 0.0)+","+s("inst.rotZDel", 0.0) }

        ShaderParam { paramName: "g_rotCenX"; paramValue: s("inst.rotCenX", 0.0) }
        ShaderParam { paramName: "g_rotCenY"; paramValue: s("inst.rotCenY", 0.0) }
        ShaderParam { paramName: "g_rotCenZ"; paramValue: s("inst.rotCenZ", 0.0) }

        ShaderParam { paramName: "g_rotSingle"; paramValueVec4: s("inst.rotSingleX", 0.0)+","+s("inst.rotSingleY", 0.0)+","+s("inst.rotSingleZ", 0.0) }
        ShaderParam { paramName: "g_centroAmpFreq"; paramValueVec4: s("inst.radAmp", 0.0)+","+s("inst.radAmpIn", 0.0)+","+s("inst.radFreq", 0.0)+","+s("inst.radFreqIn", 0.0) }

        ShaderParam { paramName: "g_centroOfs"; paramValue:  s("inst.radOfs", 0.0) }
        ShaderParam { paramName: "g_radRotDel"; paramValue: s("inst.radRotDel", 0.0) }
        ShaderParam { paramName: "g_radDel"; paramValue:  s("inst.radDel", 0.0) }

        ShaderParam { paramName: "g_delOfs"; paramValue:  s("inst.delOfs", 0.0) }

        ShaderParam { paramName: "g_circularCen"; paramValueVec4: s("inst.circCenX", 0.0)+","+s("inst.circCenY", 0.0)+","+s("inst.circCenZ", 0.0)+",0.0" }
        ShaderParam { paramName: "g_circularDist"; paramValueVec4: s("inst.circDistX", 0.0)+","+s("inst.circDistY", 0.0)+","+s("inst.circDistZ", 0.0)+",0.0" }
        ShaderParam { paramName: "g_circularRot"; paramValueVec4: s("inst.circRotX", 0.0)+","+s("inst.circRotY", 0.0)+","+s("inst.circRotZ", 0.0)+",0.0" }


        ShaderParam { paramName: "g_mirrorX"; paramValueVec4: s("mirrorX", 0.0)+","+s("mirrorXPos", 0.0)+","+s("mirrorXClip", 0.0)+",0.0" }
        ShaderParam { paramName: "g_mirrorY"; paramValueVec4: s("mirrorY", 0.0)+","+s("mirrorYPos", 0.0)+","+s("mirrorYClip", 0.0)+",0.0" }
        ShaderParam { paramName: "g_mirrorZ"; paramValueVec4: s("mirrorZ", 0.0)+","+s("mirrorZPos", 0.0)+","+s("mirrorZClip", 0.0)+",0.0" }


        ShaderParam { paramName: "emitAmount"; syncFFTName: ns("pardEmit.amount"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitAmountFromBright"; syncFFTName: ns("pardEmit.amount.fromBright"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitAge"; syncFFTName: ns("pardEmit.age"); syncDefault: 1.0 }
        ShaderParam { paramName: "emitAgeFromBright"; syncFFTName: ns("pardEmit.age.fromBright"); syncDefault: 0.0 }

        ShaderParam { paramName: "emitVelDirOrient"; syncFFTName: ns("pardEmit.velDir.orient"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirAmp"; syncFFTName: ns("pardEmit.velDir.amp"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirX"; syncName: ns("pardEmit.velDir.x"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirY"; syncName: ns("pardEmit.velDir.y"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitVelDirZ"; syncName: ns("pardEmit.velDir.z"); syncDefault: 0.0 }

        ShaderParam { paramName: "emitIntersect"; syncName: ns("pardEmit.intersect"); syncDefault: 0.0 }
        ShaderParam { paramName: "emitIntExp"; syncName: ns("pardEmit.intersect.exp"); syncDefault: 1.0 }

        ShaderParam { paramName: "g_timeStep"; paramValue: fixedTimeStepIn !== undefined ? fixedTimeStepIn : rocket.timeStep }
    }

}


