import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    // generic mesh just named box :)
    id: box
    name: "box"
    property string shader: "smBreakIn"
    enabled: syncRoot(box.name+".ON");
    Shader { file: shader }
    TextureSel { textureUnit: 0; name: parent.name }
    TextureSel { textureUnit: 1; name: parent.name }

    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }

    BreakinPresets { id: presets; effectName: box.name }

    property alias autoCenter: meshInst.autoCenter
    property alias autoScale: meshInst.autoScale

    property string shaderVaryings: "vec3 posG;"

    property int instCount: sync(box.name+".num", 100)

    DrawVB { // actually don't draw, just generate the vbo for instanced drawing below..
        enabled: true
        type: "pointGrid"
        vboId: sceneName+"_breakIn"
        tfVaryings: shaderVaryings
        gridWidth: 1000
        gridHeight: 500
        drawNumPoints: 0
    }

    DrawMesh {
        id: meshInst
        property string name: box.name
        file: meshSel(box.name)
        depthTest: sync(box.name+".depthEnabled", 1.0) > 0.5
        depthWrite: sync(box.name+".depthEnabled", 1.0) > 0.5
        blendMode: blendSel(box.name)
        autoCenter: false
        autoScale: false
        instanceVBO: sceneName+"_breakIn"
        instanceCount: instCount
        tfVaryings: shaderVaryings

        smoothNormals: true; normalSmoothAngle: 60;

        property real sca: sync(box.name+".scale", 1.0)
        property real scaZ: sync(box.name+".scaleZ", 1.0)

        Sca { s: meshInst.sca; x: 1.0; y: 1.0; z: meshInst.scaZ }

        property real posX: sync(box.name+".x")
        property real posY: sync(box.name+".y")
        property real posZ: sync(box.name+".z")

        ShaderParam { paramName: "g_texBrightness"; paramValue: presets.get("bright") }
        ShaderParam { paramName: "g_texAmbient"; paramValue: presets.get("ambient") }
        ShaderParam { paramName: "g_uvScale"; paramValue: presets.get("uvScale") }
        ShaderParam { paramName: "g_uvRandom"; paramValueVec4: syncFFT(box.name+".uvRandom")+","+sync(box.name+".uvScaleMin")+","+sync(box.name+".uvScaleMax", 10.0) }
        ShaderParam { paramName: "g_uvOfsRand"; paramValueVec4: syncFFT(box.name+".uvOfsXRand")+","+sync(box.name+".uvOfsYRand")+",0.0" }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(box.name+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(box.name+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(box.name+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha", 1.0) }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(box.name+".emitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(box.name+".emitAmp", 1.0) }

        ShaderParam { paramName: "g_pos"; paramValueVec4: meshInst.posX+","+meshInst.posY+","+meshInst.posZ }
        ShaderParam { paramName: "g_cen"; paramValueVec4: syncFFT(box.name+".cenX")+","+sync(box.name+".cenY")+","+sync(box.name+".cenZ") }
        ShaderParam { paramName: "g_rot"; paramValueVec4: sync(box.name+".rotX")+","+sync(box.name+".rotY")+","+sync(box.name+".rotZ") }
        ShaderParam { paramName: "g_rotDel"; paramValueVec4: syncFFT(box.name+".rotXDel", 33.0)+","+sync(box.name+".rotYDel", 22.0)+","+sync(box.name+".rotZDel") }

        ShaderParam { paramName: "g_rotSingle"; paramValueVec4: syncFFT(box.name+".rotSingleX")+","+sync(box.name+".rotSingleY")+","+sync(box.name+".rotSingleZ") }
        ShaderParam { paramName: "g_centroAmpFreq"; paramValueVec4: syncFFT(box.name+".radAmp")+","+sync(box.name+".radAmpIn")+","+sync(box.name+".radFreq")+","+sync(box.name+".radFreqIn") }

        ShaderParam { paramName: "g_centroOfs"; paramValue: syncFFT(box.name+".radOfs") }
        ShaderParam { paramName: "g_radRotDel"; paramValue: sync(box.name+".radRotDel", 1.0) }
        ShaderParam { paramName: "g_radDel"; paramValue: sync(box.name+".radDel") }

        ShaderParam { paramName: "g_delOfs"; paramValue: sync(box.name+".delOfs") }

        SavePoint {
            target: box.name+"_SP"
            x: meshInst.posX+sync(box.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(box.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(box.name+".spz");
        }

    }



}


