import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    // generic mesh just named box :)
    id: box
    name: "box"
    enabled: syncRoot(box.name+".ON"); Shader { file: sceneDir+"smVoro" }
    TextureSel { textureUnit: 0; name: parent.name }
    TextureSel { textureUnit: 1; name: parent.name }

    Repeater {
        id: repez
        model: sync(box.name+".num")
        delegate: DrawMesh {
            name: box.name

            file: meshSel(name)

            enabled: true; smoothNormals: true; normalSmoothAngle: 90;
            depthTest: true; depthWrite: true; // index===(repez.count-1);
            blendMode: blendSel(box.name)

            autoCenter: false
            autoScale: false

            Pos { x: sync(box.name+".x"); y: sync(box.name+".y"); z: sync(box.name+".z")}
            Pos { x: sync(box.name+".cenX"); y: sync(box.name+".cenY"); z: sync(box.name+".cenZ"); }
            Rot { d: sync(box.name+".rotX")+sync(box.name+".rotXDel")*index; ax: 1.0; ay: 0.0; az: 0.0 }
            Rot { d: sync(box.name+".rotY")+sync(box.name+".rotYDel")*index; ax: 0.0; ay: 1.0; az: 0.0 }
            Rot { d: sync(box.name+".rotZ")+sync(box.name+".rotZDel")*index; ax: 0.0; ay: 0.0; az: 1.0 }
            Pos { x: -sync(box.name+".cenX"); y: -sync(box.name+".cenY"); z: -sync(box.name+".cenZ"); }
            Sca { s: sync(box.name+".scale"); x: sync(box.name+".scaX"); y: sync(box.name+".scaY"); z: sync(box.name+".scaZ") }
            ShaderParam { paramName: "g_uvScale"; paramValue: 1.0}
            ShaderParam { paramName: "g_bump"; paramValue: 0.10}
            ShaderParam { paramName: "g_texBrightness"; paramValue: sync(box.name+".bright") }
            ShaderParam { paramName: "g_alpha"; paramValue: sync(box.name+".alpha")-sync(box.name+".alphaDel")*index }
            ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
            ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
            ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")*sync(box.name+".prevBlurAmount") }
            ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
            ShaderParam { paramName: "g_bright"; paramValue: 1.0}
            ShaderParam { paramName: "g_uvScaleVoro"; paramValue: sync(box.name+".voroUvScale")}
            ShaderParam { paramName: "g_uvScaleYVoro"; paramValue: sync(box.name+".voroUvScaleY")}
            ShaderParam { paramName: "g_voroUvOfsX"; paramValue: sync(box.name+".voroUvOfsX")}
            ShaderParam { paramName: "g_voroUvOfsY"; paramValue: sync(box.name+".voroUvOfsY")}
            ShaderParam { paramName: "g_voroLift"; paramValue: sync(box.name+".voroLift")}
            ShaderParam { paramName: "g_distToZW"; paramValue: sync(box.name+".voroDistToZW")}
            ShaderParam { paramName: "g_distToZPow"; paramValue: sync(box.name+".voroDistToZPow")}
            ShaderParam { paramName: "g_voroDispYM"; paramValue: sync(box.name+".voroDispYM")}
            ShaderParam { paramName: "g_voroDispYOfs"; paramValue: sync(box.name+".voroDispYOfs")}
            ShaderParam { paramName: "g_genUV"; paramValue: sync(box.name+".genUVs")}
            SavePoint {
                target: "centrumBox"
                x: 0.0; y: 0.0; z: 0.0;
            }
        }
    }
}
