import QtQuick 2.3
import AdaptDemoSystem 1.0
import QtGraphicalEffects 1.0
import "../"
import "../_SharedQML"

// Outputs signed distance distances per pixel to the
// given srcRT pixels where black is considered outside
// and white inside surface pixels
Effect {
    id: fx
    name: "distancer"
    effectName: "Distancer"

    enabled: syncRootOn(effect.name, effectName);

    // RT>0: render effect to rendertarget with name "fxRT"+RT & "fxRTP"+RT
    property int effectRT: s("RT", 0)
    property string effectRTName: "fxRT"+(effectRT.toString())
    property string effectRTPrevName: "fxRTP"+(effectRT.toString())

    property int srcRT: s("srcRT", 1)
    property string srcRTName: "fxRT"+(srcRT.toString())

    Blit {
        enabled: srcRT===0
        textureRT: srcRTName
    }

    Shader { file: "jumpFlood_seedCoords" }
    Texture { textureUnit: 0; textureRT: srcRTName }
    RenderTarget {
        RenderTargetLayer { // coordinates to the seed points
            textureRT: "distancerClosestSeedCoords"; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
        }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            drawBuffers: 1
        }
    }

    // for 2 buffers ping pong
    RenderTarget {
        RenderTargetLayer { // coordinates to the closest found seeds
            textureRT: "distancerClosestSeedCoords2"; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            Clear {
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }


    property int searchLoops: Math.floor(Math.log(demo.windowWidth)/Math.log(2))

    Shader { file: "jumpFlood_searchClosest" }
    Repeater {
        model: searchLoops
        delegate: RenderTarget {
            RenderTargetLayer { // coordinates to the closest found seeds
                textureRT: ((index&1)===0) ? "distancerClosestSeedCoords2" : "distancerClosestSeedCoords";
                format: "RGBA32F";
                width: demo.windowWidth; height: demo.windowHeight
            }
            Texture {
                textureRT: ((index&1)===0) ? "distancerClosestSeedCoords" : "distancerClosestSeedCoords2";
                textureUnit: 0;
            }
            DrawVB {
                type: "quad"
                depthTest: false; depthWrite: false
                blendMode: "off"
                drawBuffers: 1
                // searchDist is a serie of ..32, 16, 8, 4, 2, 1
                // (starting from closest from below power of two of resolution width)
                ShaderParam { paramName: "searchDist"; paramValue: Math.pow(2, searchLoops-index-1) }
            }
        }
    }




    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTPrevName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
        }
        DrawRT {
            textureRT: effectRTName
            drawBuffers: 1
        }
    }

    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            mode: 1 // mode 1 = start render to the effect RT
        }
    }


    Shader { file: "jumpFlood_distances" }
    Texture {
        textureUnit: 0;
        textureRT: ((searchLoops-1)&1===0) ? "distancerClosestSeedCoords" : "distancerClosestSeedCoords2";
    }
    Texture {
        textureUnit: 1;
        textureRT: srcRTName;
    }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        // ShaderParam { paramName: "vaporizeTime"; paramValue: s("vaporize.time", 1.0) }
    }

    RenderTarget {
        enabled: effectRT>0
        RenderTargetLayer {
            textureRT: effectRTName; format: "RGBA32F";
            width: demo.windowWidth; height: demo.windowHeight
            mode: 2 // mode 2 = end render to the effect RT
        }
    }


}
