import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: box
    name: "box"
    property string groupName: "box"
    property string shader: "smBreakIn"
    enabled: syncRoot(box.name+".ON");
    property string masterBox: "bgBreak"
    property string allName: groupName+"All"

    Shader { file: shader }
    TextureSel { textureUnit: 0; name: parent.name } // diffuse
    TextureSel { textureUnit: 1; name: parent.name } // bump

    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }

    property alias autoCenter: meshInst.autoCenter
    property alias autoScale: meshInst.autoScale

    property string shaderVaryings: "vec3 posG;"
//         vec3 normalG;
//         vec2 uvG;
//         vec3 tangentG;
//"

    property int instCount: 1 // sync(box.name+".num", 100)

    DrawVB { // actually don't draw, just generate the vbo for instanced drawing below..
        enabled: true
        type: "pointGrid"
        vboId: sceneName+"_meshOnBreak"
        tfVaryings: shaderVaryings
        gridWidth: 16
        gridHeight: 16
        drawNumPoints: 0
    }

    DrawMesh {
        id: meshInst
        property string name: box.name
        file: meshSel(box.name)
        depthTest: sync(masterBox+".depthEnabled", 1.0) > 0.5
        depthWrite: sync(masterBox+".depthEnabled", 1.0) > 0.5
        blendMode: blendSel(box.name)
        autoCenter: false
        autoScale: false
        instanceVBO: sceneName+"_meshOnBreak"
        instanceCount: instCount
        tfVaryings: shaderVaryings

        smoothNormals: true; normalSmoothAngle: 60;

        property real sca: sync(masterBox+".scale", 1.0)
        property real scaZ: sync(masterBox+".scaleZ", 1.0)

        Sca { s: meshInst.sca; x: 1.0; y: 1.0; z: meshInst.scaZ }

        property real posX: sync(masterBox+".x")
        property real posY: sync(masterBox+".y")
        property real posZ: sync(masterBox+".z")

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(meshInst.name+".bright", 1.0) }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(allName+".ambient", 0.1) }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(allName+".uvScale", 1.0) }
//        ShaderParam { paramName: "g_uvRandom"; paramValueVec4: syncFFT(masterBox+".uvRandom")+","+sync(masterBox+".uvScaleMin")+","+sync(masterBox+".uvScaleMax", 10.0) }
//        ShaderParam { paramName: "g_uvOfsRand"; paramValueVec4: syncFFT(masterBox+".uvOfsXRand")+","+sync(masterBox+".uvOfsYRand")+",0.0" }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(allName+".prevBlur", 0.5) }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: sync(allName+".prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(allName+".bump", 0.25) }
        ShaderParam { paramName: "g_genUV"; paramValue: sync(allName+".genUV", 1.0) }
        ShaderParam { paramName: "g_alpha"; paramValue: sync(allName+".alpha", 1.0) }

        ShaderParam { paramName: "g_emitThr"; paramValue: sync(allName.name+".emitThr", 0.0) }
        ShaderParam { paramName: "g_emitAmp"; paramValue: syncFFT(allName.name+".emitAmp", 1.0) }

        ShaderParam { paramName: "g_pos"; paramValueVec4: meshInst.posX+","+meshInst.posY+","+meshInst.posZ }
        ShaderParam { paramName: "g_cen"; paramValueVec4: syncFFT(masterBox+".cenX")+","+sync(masterBox+".cenY")+","+sync(masterBox+".cenZ") }
        ShaderParam { paramName: "g_rot"; paramValueVec4: sync(masterBox+".rotX")+","+sync(masterBox+".rotY")+","+sync(masterBox+".rotZ") }
        ShaderParam { paramName: "g_rotDel"; paramValueVec4: syncFFT(masterBox+".rotXDel", 33.0)+","+sync(masterBox+".rotYDel", 22.0)+","+sync(masterBox+".rotZDel") }
        ShaderParam { paramName: "g_rotSingle"; paramValueVec4: syncFFT(masterBox+".rotSingleX")+","+sync(masterBox+".rotSingleY")+","+sync(masterBox+".rotSingleZ") }
        ShaderParam { paramName: "g_centroAmpFreq"; paramValueVec4: syncFFT(masterBox+".radAmp")+","+sync(masterBox+".radAmpIn")+","+sync(masterBox+".radFreq")+","+sync(masterBox+".radFreqIn") }
        ShaderParam { paramName: "g_centroOfs"; paramValue: syncFFT(masterBox+".radOfs") }
        ShaderParam { paramName: "g_radRotDel"; paramValue: sync(masterBox+".radRotDel", 1.0) }
        ShaderParam { paramName: "g_radDel"; paramValue: sync(masterBox+".radDel") }

        ShaderParam { paramName: "g_delOfs"; paramValue: Math.round(sync(meshInst.name+".delOfs"))+sync(masterBox+".delOfs") }

//        SavePoint {
//            target: meshInst.name+"_SP"
//            x: meshInst.posX+sync(meshInst.name+".spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+sync(meshInst.name+".spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+sync(meshInst.name+".spz");
//        }

    }

}


