import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: effect
    name: "mesher"

    property real div: s("div")

    RenderTarget { RenderTargetLayer { textureRT: "mesherTriangles"; format: "RGBA32F"; width: 2048; height: 1024 } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherVertPos"; format: "RGBA32F"; width: 2048; height: 1024 } }
    RenderTarget { RenderTargetLayer { textureRT: "mesherVertNorm"; format: "RGBA32F"; width: 2048; height: 1024 } }

    // mesherVertTriCounts
    // per vertex info
    // .x = count of triangles attached
    RenderTarget {
        RenderTargetLayer {
            textureRT: "mesherVertTriCounts"; format: "R32F"; width: 2048; height: 1024;
            Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }
    // mesherVertTriOfs
    // per vertex info
    // .x = offset in the mesherVertTriMap
    RenderTarget {
        RenderTargetLayer {
            textureRT: "mesherVertTriOfs"; format: "R32F"; width: 2048; height: 1024;
            Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }
    // mesherVertTriMap
    // index map to triangle indexes using the mesherVertTriCounts & mesherVertTriOfs
    RenderTarget { RenderTargetLayer { textureRT: "mesherVertTriMap"; format: "R32F"; width: 2048; height: 2048 } }


    ShaderAtomicCounter { name: effect.name+".sacVertexCount"; clear: true; bind: 0 }

    // 1st generate mesh into mesherTriangles & mesherVertPos RT's
    // the mesh is generated so that
    // -mesherTriangles RGB will have integer indexes into the vertices - index 0 means no vertex
    // -vertices are stored in the mesherVertPos, with offset of 1
    RenderTarget {
        Shader { file: "mesherGen" }
        RenderTargetLayer {
            textureRT: "mesherTriangles"; format: "RGBA32F"; width: 2048; height: 1024
            Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles" } // write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos" } // write
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "mesherVertTriCounts" } // write to .x
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            ShaderParam { paramName: "div"; paramValue: div }

            ShaderParam { paramName: "noiseOfsX"; paramValue: s("noise.ofs.x") }
            ShaderParam { paramName: "noiseOfsY"; paramValue: s("noise.ofs.y") }
            ShaderParam { paramName: "noisePos"; paramValue: s("noise.pos") }
            ShaderParam { paramName: "noiseFreq"; paramValue: s("noise.freq") }
            ShaderParam { paramName: "noiseOct"; paramValue: s("noise.oct.num") }
            ShaderParam { paramName: "noiseOctMul"; paramValue: s("noise.oct.mul") }
            ShaderParam { paramName: "noiseOctAmp"; paramValue: s("noise.oct.amp") }

            ShaderParam { paramName: "dispAmp"; paramValue: s("disp.amp") }
            ShaderParam { paramName: "dispExp"; paramValue: s("disp.exp") }
            ShaderParam { paramName: "dispSub"; paramValue: s("disp.sub") }
            ShaderParam { paramName: "dispMinLim"; paramValue: s("disp.minLim") }
            ShaderParam { paramName: "dispMaxLim"; paramValue: s("disp.maxLim") }
            ShaderParam { paramName: "dispSmooth"; paramValue: s("disp.smooth") }

        }
    }


    // go through all vertices and per vertex mark the unique mesherVertTriOfs
    RenderTarget {
        Shader { file: "mesherCalcTriOfs" }
        RenderTargetLayer {
            textureRT: "mesherTriangles"; format: "RGBA32F"; width: 2048; height: 1024
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles" } // write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos" } // write
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "mesherVertTriCounts" } // read
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "mesherVertTriOfs" } // write
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            ShaderParam { paramName: "div"; paramValue: div }
        }
    }


    RenderTarget {
        RenderTargetLayer {
            textureRT: "mesherVertTriCounts"; format: "R32F"; width: 2048; height: 1024;
            Clear { enabled: true; cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }
    // go through all triangles and per vertex write the mesherVertTriMap
    RenderTarget {
        Shader { file: "mesherCalcTriMap" }
        RenderTargetLayer {
            textureRT: "mesherVertTriMap"; format: "R32F"; width: 2048; height: 2048
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles" } // write
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos" } // write
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "mesherVertTriCounts" } // write
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "mesherVertTriOfs" } // read
        Texture { textureUnit: 5; imageUnit: 5; textureRT: "mesherVertTriMap" } // write
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            ShaderParam { paramName: "div"; paramValue: div }
        }
    }


    RenderTarget {
        Shader { file: "mesherCalcNorm" }
        RenderTargetLayer {
            textureRT: "mesherTempos"; format: "RGBA32F"; width: 2048; height: 1024
        }
        Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles" } // read
        Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos" } // read
        Texture { textureUnit: 2; imageUnit: 2; textureRT: "mesherVertNorm" } // write
        Texture { textureUnit: 3; imageUnit: 3; textureRT: "mesherVertTriCounts" } // read
        Texture { textureUnit: 4; imageUnit: 4; textureRT: "mesherVertTriOfs" } // read
        Texture { textureUnit: 5; imageUnit: 5; textureRT: "mesherVertTriMap" } // read
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            ShaderParam { paramName: "div"; paramValue: div }
        }
    }

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "mesherTriangles" } // read
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "mesherVertPos" } // read
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "mesherVertNorm" } // read

    Shader { file: "mesherDraw" }
    TextureSel { id: tex; nameOverride: effect.name+".mat.diff.texInd"; textureUnit: 0; }
    TextureSel { id: texBump; nameOverride: effect.name+".mat.bump.texInd"; textureUnit: 1; }
    property int bumpTex: s("mat.bump.texInd")

    DrawVB {
        type: "emptyVBO"
        primType: "triangles"
        vboId: sceneName+effect.name+"mesher"
        depthTest: true; depthWrite: true
        blendMode: "off"

        drawNumPoints: 6*effect.div*effect.div  // ball

        Pos { x: s("x"); y: s("y"); z: s("z")}
        Rot { d: s("rot.x"); ax: 1.0; ay: 0.0; az: 0.0 }
        Rot { d: s("rot.y"); ax: 0.0; ay: 1.0; az: 0.0 }
        Rot { d: s("rot.z"); ax: 0.0; ay: 0.0; az: 1.0 }
        Sca { s: sync(effect.name+".scale"); x: 1.0; y: 1.0; z: 1.0 }

        ShaderParam { paramName: "div"; paramValue: div }

        ShaderParam { paramName: "dispBrightMul"; paramValue: s("disp.bright.mul") }
        ShaderParam { paramName: "dispBrightOfs"; paramValue: s("disp.bright.ofs") }
        ShaderParam { paramName: "dispBrightExp"; paramValue: s("disp.bright.exp") }

        ShaderParam { paramName: "scaleX"; paramValue: s("scale.x") }
        ShaderParam { paramName: "scaleY"; paramValue: s("scale.y") }
        ShaderParam { paramName: "scaleZ"; paramValue: s("scale.z") }

        ShaderParam { paramName: "uvScale"; paramValue: s("mat.uvScale") }

        ShaderParam { paramName: "specAmp"; paramValue: s("mat.spec.amp") }
        ShaderParam { paramName: "specExp"; paramValue: s("mat.spec.exp") }
        ShaderParam { paramName: "diffAmp"; paramValue: s("mat.diff.amp") }
        ShaderParam { paramName: "diffExp"; paramValue: s("mat.diff.exp") }
        ShaderParam { paramName: "ambient"; paramValue: s("mat.ambient") }
        ShaderParam { paramName: "texAmount"; paramValue: s("mat.texAmount") }

        ShaderParam { paramName: "bumpUvScale"; paramValue: s("mat.bump.uvScale") }
        ShaderParam { paramName: "bumpStrength"; paramValue: s("mat.bump.strength") }
        ShaderParam { paramName: "bumpTexDelta"; paramValue: s("mat.bump.texDelta") }
        ShaderParam { paramName: "bumpTexInd"; paramValue: bumpTex }
    }

}
