import QtQuick 2.3
import AdaptDemoSystem 1.0

GroupBase {
  id: effect
  name: "palaFlow"
  effectName: "PalaFlow"
  property bool enabledIn: true
  enabled: syncRootOn(effect.name, effectName) & enabledIn;

  property PalaFlowImpl impl
  Component {
    id: ec
    PalaFlowImpl {}
  }

  property bool effectExists: false
  onEnabledChanged: {
    if (!enabled && effectExists) {
      effectExists = false;
      impl.destroy(0);
      //log("PalaFlow removed:"+effect.name)
      impl = undefined;
    }
  }

  Connections {
    target: demo
    onFrameRendered: {
      if (effect.enabled && !effectExists) {
        effectExists = true;
        impl = ec.createObject(effect, { name: effect.name } );
      }
    }
  }
}
