import QtQuick 2.3
import AdaptDemoSystem 1.0

Effect {
    id: effect
    name: "spaceWiper"
    effectName: "SpaceWiper"

    enabled: syncRootOn(effect.name, effectName);

    Blit { textureRT: "current" }
    Shader { file: "spaceWiper" }
    Texture { textureUnit: 0; textureRT: "current" }
    Texture { textureUnit: 1; textureRT: "mainDepth" }
    DrawVB {
        type: "quad"
        depthTest: false; depthWrite: false
        blendMode: "off"
        drawBuffers: 1
        ShaderParam { paramName: "wipeWidth"; syncFFTName: ns("wipe.width") }
        ShaderParam { paramName: "wipePosX"; syncFFTName: ns("wipe.posX") }
        ShaderParam { paramName: "wipePosY"; syncFFTName: ns("wipe.posY") }
        ShaderParam { paramName: "wipePosZ"; syncFFTName: ns("wipe.posZ") }
        ShaderParam { paramName: "wipeExp"; paramValueVec4: sync(effect.name+".wipe.exp")+","+sync(effect.name+".wipe.expBelow")+","+sync(effect.name+".wipe.expAbove") }
        ShaderParam { paramName: "wipeZero"; paramValue: sync(effect.name+".wipe.zero") }
        ShaderParam { paramName: "wipeOrig"; paramValue: sync(effect.name+".wipe.orig") }
        ShaderParam { paramName: "wipeBright"; paramValue: sync(effect.name+".wipe.bright") }
        ShaderParam { paramName: "wipeRepeX"; syncName: ns("wipe.repeX"); syncDefault: 1000.0 }
        ShaderParam { paramName: "wipeRepeY"; syncName: ns("wipe.repeY"); syncDefault: 1000.0 }
        ShaderParam { paramName: "wipeRepeZ"; syncName: ns("wipe.repeZ"); syncDefault: 1000.0 }

        ShaderParam { paramName: "rotX"; syncName: ns("wipe.rotX"); syncDefault: 0.0 }
        ShaderParam { paramName: "rotY"; syncName: ns("wipe.rotY"); syncDefault: 0.0 }
        ShaderParam { paramName: "rotZ"; syncName: ns("wipe.rotZ"); syncDefault: 0.0 }
    }
}
