import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: vox
    name: "voxel"
    enabled: syncRoot(vox.name+".ON");

    property real voxAreaSize: sync("voxel.areaSize")

    property int staticUpdateCounter: 0
    property int frameIndex: 0
    Connections {
        target: demo; onFrameRendered: {
            frameIndex++;

            staticUpdateCounter++;
            if (staticUpdateCounter > 2) {
              //  transMesh.enabled = false;
            }
        }
    }

    // debug cube for displaying the voxel grid area
    Shader { file: "smVoxDebug" }
    DrawMesh {
        enabled: sync("voxel.areaDebug") > 0.01;
        file: "mesh/cube.x";
        smoothNormals: true; normalSmoothAngle: 80;
        depthTest: true; depthWrite: false;
        blendMode: "add"
        Sca { s: voxAreaSize; x: 1.0; y: 1.0; z: 1.0 }
        Pos { x: 0.0; y: 0.0; z: 0.0}
        Rot { d: -0; ax: 1.0; ay: 0.0; az: 0.0 }
        ShaderParam { paramName: "g_texBrightness"; paramValue: 0.0 }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync("voxel.areaDebug")*0.1 }
    }

    // draw the 3d voxel texture (ultimately with 8xMSAA rendertarget to avoid getting holes into the voxel)
    // rgb is the accumulated normal and a has accumulation of drawn pixels to the voxel grid

    RenderTarget {
        RenderTargetLayer {
            id: voxel
            textureRT: "voxel"
            format: "R32F"
            property int baseDim: 8 // voxel dimension is baseDim*baseDim
            property int dim: baseDim*baseDim*baseDim
            width: dim; height: dim
            Clear {
           //     enabled: isStaticUpdating()
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
            }
        }
    }


    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxelHP"; format: "R32F"; property int dim: voxel.baseDim*voxel.baseDim*voxel.baseDim; width: dim; height: dim
            Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxelNP"; format: "R32F"; property int dim: voxel.baseDim*voxel.baseDim*voxel.baseDim; width: dim; height: dim
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxelVel"; format: "RGBA32F"; property int dim: voxel.baseDim*voxel.baseDim*voxel.baseDim; width: dim; height: dim
            Clear { cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0; }
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxPos"; format: "RGBA32F"; property int dim: voxel.baseDim*voxel.baseDim*voxel.baseDim; width: dim; height: dim/4
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxelPos"; format: "RGBA32F"
            property int dim: voxel.baseDim*voxel.baseDim*voxel.baseDim; width: dim; height: dim/4
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxelNor"; format: "RGBA32F"
            property int dim: voxel.baseDim*voxel.baseDim*voxel.baseDim; width: dim; height: dim/4
        }
    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxPosComp"; format: "RGBA32F"
            width: voxel.baseDim*voxel.baseDim*voxel.baseDim; height: width/4
        }
    }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxNorComp"
            format: "RGBA32F"
            width: voxel.baseDim*voxel.baseDim*voxel.baseDim; height: width/4
        }
    }

//    Shader { file: sceneDir+"smPlastic" }
//    DrawMesh {
//        id: meshDraw
//        name: "voxMesh"
//        enabled: true;
//        // smoothNormals: true; normalSmoothAngle: 60;
//        file: meshSel(name)
//        blendMode: "off";
//        depthTest: true; depthWrite: true;
//        drawBuffers: 1

//        ShaderParam { paramName: "g_voxelDim"; paramValue: voxel.baseDim }

//        Sca { s: sync(meshDraw.name+".sca"); x: 1.0; y: 1.0; z: 1.0 }
//        Pos { x: sync(meshDraw.name+".x"); y: sync(meshDraw.name+".y"); z: sync(meshDraw.name+".z")}
//    }

    Shader { file: "smVox" }
    ShaderAtomicCounter { property string name: "acVox"; bind: 0; clear: true }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "voxel"; }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "voxelHP"; }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "voxelNP" }
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "voxelPos" }
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "voxelNor" }
    RenderTarget {
        RenderTargetLayer {
            textureRT: "voxelTemp" // used just for rendering the baseDim*baseDim stuff
            format: "R32F"
            property int dim: 16*16 // voxel.baseDim*voxel.baseDim
            width: dim
            height: dim
            samples: frameIndex < 8 ? 1 : 1 // HACK to make 8 samples to work from the start.....
//            Clear {
//           //     enabled: isStaticUpdating()
//                cR: 0.0; cG: 0.0; cB: 0.0; cA: 0.0;
//            }
        }
     //   TextureSel { name: "voxMesh"}
        DrawMesh {
            id: mesh
            name: "voxMesh"
            enabled: true;
            // smoothNormals: true; normalSmoothAngle: 60;
            file: meshSel(name)
            blendMode: "add";
            depthTest: false; depthWrite: false;
            drawBuffers: 1
            ShaderParam { paramName: "g_voxelDim"; paramValue: voxel.baseDim }
            ShaderParam { paramName: "g_voxelAreaSize"; paramValue: voxAreaSize }
            Pos { x: syncOsc(mesh.name+".x"); y: syncOsc(mesh.name+".y"); z: syncOsc(mesh.name+".z")}
            Rot { d: syncOsc(mesh.name+".rotX"); ax: 1.0; ay: 0.0; az: 0.0 }
            Rot { d: syncOsc(mesh.name+".rotY"); ax: 0.0; ay: 1.0; az: 0.0 }
            Rot { d: syncOsc(mesh.name+".rotZ"); ax: 0.0; ay: 0.0; az: 1.0 }
            Sca { s: syncFFT(mesh.name+".scale"); x: 1.0; y: 1.0; z: 1.0 }
        }
    }


    // compact: draw the positions etc of existing voxels into texture
    Shader { file: "smVoxComp" }
    ShaderAtomicCounter { property string name: "sacCubes"; bind: 0; clear: true }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: "voxelHP"; } // read int head pointers, 0 if no data for the cell
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "voxelNP" } // read int next pointers
    Texture { textureUnit: 2; imageUnit: 2; textureRT: "voxPosComp" } // write compacted position of the voxel
    Texture { textureUnit: 3; imageUnit: 3; textureRT: "voxNorComp" } // write compacted normal of the voxel
    Texture { textureUnit: 4; imageUnit: 4; textureRT: "voxelVel" }

    Texture { textureUnit: 0; textureRT: "voxelPos"; } // read linked list position lists (can have multiple per voxel)
    Texture { textureUnit: 1; textureRT: "voxelNor"; } // read linked list normal lists (can have multiple per voxel)
        RenderTarget {
        RenderTargetLayer {
            textureRT: "voxPosTemp"
            format: "RGBA16F"
            width: voxel.baseDim*voxel.baseDim*voxel.baseDim
            height: width
        }
        DrawVB {
            type: "quad"
            depthTest: false; depthWrite: false
            blendMode: "off"
            ShaderParam { paramName: "g_voxelDim"; paramValue: voxel.baseDim }
            ShaderParam { paramName: "g_voxelAreaSize"; paramValue: voxAreaSize }
        }
    }



    // render the vox with instancing

    property string shaderVaryings: "
            vec3 posG;
            vec2 uvG;
            vec3 velG;
            float ageG;
            float recG;
            float ageSplitG;
            vec4 posInitG;"

    property int maxInstanceCount: 80000

    Shader { file: "smVoxInst" }
    ShaderAtomicCounter { property string name: "sacCubes"; bind: 0; clear: false }
    DrawVB { // actually don't draw, just generate the vbo for instanced drawing below..
        enabled: true
        type: "pointGrid"
        vboId: sceneName+"_vox"
        tfVaryings: shaderVaryings
        gridWidth: 400
        gridHeight: 200
        drawNumPoints: 0
    }

    Texture { textureUnit: 0; imageUnit: 0; textureRT: "voxPosComp" }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: "voxNorComp" }

    TextureSel { name: "voxMesh" }
    TextureImage { textureUnit: 1; file: "../../images/mettex_microscope.png"}
    TextureImage { textureUnit: 2; file: "../../images/mettex_microscope.png"}
    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }

    DrawMesh {
        id: meshInst
        property string name: "voxInstMesh"
        file: "mesh/cube.x"
        depthTest: true
        depthWrite: true
        blendMode: "normal"
        instanceVBO: sceneName+"_vox"
        instanceCount: maxInstanceCount
        tfVaryings: shaderVaryings

        smoothNormals: true; normalSmoothAngle: 60;

        ShaderParam { paramName: "g_voxelDim"; paramValue: voxel.baseDim }
        ShaderParam { paramName: "g_voxelAreaSize"; paramValue: voxAreaSize }

        Pos { x: sync(meshInst.name+".x"); y: sync(meshInst.name+".y"); z: sync(meshInst.name+".z") }
        Sca { s: sync(meshInst.name+".scale"); x: 1.0; y: 1.0; z: sync(meshInst.name+".scaleZ") }

        ShaderParam { paramName: "g_texBrightness"; paramValue: sync(meshInst.name+".bright") }
        ShaderParam { paramName: "g_texAmbient"; paramValue: sync(meshInst.name+".ambient") }
        ShaderParam { paramName: "g_uvScale"; paramValue: sync(meshInst.name+".uvScale") }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync(meshInst.name+".prevBlur") }
        ShaderParam { paramName: "g_bump"; paramValue: sync(meshInst.name+".bump") }
    }



}
