#version 430

// layout(binding=0) uniform sampler2D tex;
layout(location = 0) out vec4 frag;
layout(binding=0, r32i) uniform iimage2D particleGridCounts;
layout(binding=1, r32i) uniform iimage2D particleGridOfs;
// layout(binding=0, offset=0) uniform atomic_uint ac;

void main() {

  vec4 c = vec4(1.0, 0.5, 0.0, 1.0);

  ivec2 p = ivec2(gl_FragCoord.xy);

 // atomicAdd(ac, 16);

  ivec4 kp = imageLoad(particleGridCounts, p);

  int counter = imageAtomicAdd(particleGridOfs, ivec2(0,0), kp.x);

  if (p.x > 0 || p.y > 0) {
    imageStore(particleGridOfs, p, ivec4(counter));
  }

  frag = c;
  frag.a = 1.0;

}
