#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(triangles) in;
layout(triangle_strip, max_vertices = 15) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];
in float bright[3];

out vec4 posG;
out vec3 normalG;
out vec3 normalWSG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out float brightG;
out float triangleIdG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;


uniform float g_quadsPerRow = 128;
uniform float g_texW = 1280;
uniform float g_texH = 720;

layout(binding=0) uniform sampler2D tex;

layout(binding=0, offset=0) uniform atomic_uint ac;


void main(void) {

//    uint quadIndex = gl_PrimitiveIDIn/2;
//    uint quadHalf = gl_PrimitiveIDIn&1;
    uint quadIndex = gl_PrimitiveIDIn;
    uint quadHalf = 1; //gl_PrimitiveIDIn&1;

  //  uint counter = atomicCounterIncrement(ac);

    //gl_PrimitiveID = gl_PrimitiveIDIn;

    float quadSize = g_texW/g_quadsPerRow;
    float pid = float(quadIndex);
    float pidf = pid/g_quadsPerRow;
    float quadX = fract(pidf);
    float quadY = floor(pidf);


    // to target texture coordinates 0.0 - 1.0x
    float quadSW = quadSize/g_texW;
    float quadSH = quadSize/g_texH;
    //quadX *= ;
    quadY *= quadSH;

    triangleIdG = quadIndex+1;


    vec3 faceNormal = vec3(0.0);
    vec4 facePos = vec4(0.0);
    for (int i = 0; i < gl_in.length(); ++i) {
            gl_Position = gl_in[i].gl_Position;
            facePos += origPos[i];
            posW = modelMatrix*gl_Position;
            posG = projectionMatrix * modelViewMatrix * gl_Position;

            if (quadHalf==0) {
                if (i==0) {
                    gl_Position.xyz = vec3(quadX, quadY, 0.0);
                } else if (i==1) {
                    gl_Position.xyz = vec3(quadX+quadSW, quadY, 0.0);
                } else if (i==2) {
                    gl_Position.xyz = vec3(quadX, quadY+quadSH, 0.0);
                }
            } else {
                if (i==0) {
                    gl_Position.xyz = vec3(quadX+quadSW, quadY+quadSH, 0.0);
                } else if (i==1) {
                    gl_Position.xyz = vec3(quadX, quadY+quadSH, 0.0);
                } else if (i==2) {
                    gl_Position.xyz = vec3(quadX+quadSW, quadY, 0.0);
                }
            }
            gl_Position.xyz *= 2.0;
            gl_Position.xyz -= vec3(1.0);
            // gl_Position.y *= -1.0;

            normalG = normal[i];
            colorG = vec3(1.0, 1.0, 1.0)/60.0*float(1.0+gl_PrimitiveIDIn%60);

            vec4 jk = (modelMatrix * vec4(normalG, 0.0));
            normalWSG = jk.xyz;
            normalG = (modelMatrix * vec4(normalG, 0.0)).xyz;

            brightG = bright[i];

            faceNormal += normal[i];
            uvG = uv[i];
            tangentG = tangent[i];
            EmitVertex();
    }
    facePos /= 3.0;

    EndPrimitive();


}
