@tool
extends Node

# "Godot's scene system, while powerful and flexible, has a drawback:
# there is no method for storing information
# (e.g. a player's score or inventory) that is needed by more than one scene.
# Source: https://docs.godotengine.org/en/3.3/getting_started/step_by_step/singletons_autoload.html

# -> Using Global.gd as a storage for globals
# I couldn't find a way to show variables exported from Global.gd to show
# in Godot editor's inspector so initializing them in GlobalInit.gd instead.
# this is quite ugly and maybe there is neater way(?)

# This is meant to be used in @tool-scripts so they can clean the tree of any 
# generated nodes etc (if true) to prevent bloat in tscn-files
var cleanTempToolData:bool = false

# "Master" replay time used to sycn things during playback.
# This is used differently when using editor (@tool) and running the project
# (playback is synchronized to sound playback when not using editor)
var masterReplayTime:float = 0

# Not using @export as I couln't find a way to edit these in editor anyway...
#@export var replayTime:float = 0
#@export var lidarPointMaterial:Material
var replayTime_Lidar:float = 0
var replayTimeShift_Lidar:float = 0

# For animation:
var overrideReplayTime_WireFrames:bool = false
var replayTimeOverride_WireFrames:float = 0
var overrideReplayTime_AdditiveGeometries:bool = false
var replayTimeOverride_AdditiveGeometries:float = 0

var lidarPointMaterial:ShaderMaterial
var lidarLineMaterial:ShaderMaterial
var blockableGNSSSignalMaterial:ShaderMaterial

#var oscilloscopeCanvasShader:Shader
var oscilloscope3DShader:Shader
#var oscTestShader:Shader

var lidarPointVisibleTime:int = 100000
var lidarLineVisibleTime:int = 20000

var oscilloscopeSoundMasterPosition:int = 0
var deathRaySoundMasterPosition:int = 0

var soundData = []
var lowPassFilteredSoundAmplitudeData = []
var soundDataTexture:ImageTexture
var lowPassFilteredSoundDataTexture:ImageTexture

# Since shaders use only 32-bit floats,
# time needs to be shifted to get the resolution of it adequate
# This indicates the shift used (basically should be starting time of beamdata)
# TODO: Update this somewhere!
var scanTrackerShaderBaseTime:float = 2415057	# 2415057 from walkaround2

var oscilloscopeDataStorage	#:OscilloscopeDataStorage

var blockableGNSSSignalRaycast:bool = true

var processActionKeys:bool = false

enum DemoState {
	DS_SHOWING_START_DIALOG,
	DS_WAIT_FOR_ASYNC_LOADING,
	DS_INIT,
	DS_PRECOMPILING_SHADERS,
	DS_RUNNING }

var demoState:DemoState = DemoState.DS_SHOWING_START_DIALOG

# Called when the node enters the scene tree for the first time.
func _ready():
#	print_debug("_ready\t",Time.get_ticks_msec(),"\t",self.get_path())
	if (Engine.is_editor_hint() && cleanTempToolData):
		# @tool-scripts will generate changes that are saved into .tscn (scene)-files.
		# Clean them when requested
		
		print("Cleaning data generated by @tool, ", self.name)
		return

var totalTime:float = 0
var soundDataSamplerSet:bool = false

# Called every frame. 'delta' is the elapsed time since the previous frame.
func _process(delta):
	totalTime += delta
	
	if ((totalTime >= 1) && (!soundDataSamplerSet)):
		# blockableGNSSSignalMaterial is shared between quite a lot instances.
		# Setting the shader param here so no need to set them in every instance.

		# There is also some weird timing-related-things here that got worse in
		# godot 4.2 (about RC1). Therefore waiting a while before trying to set.
		# (I tried to migrate this project to godot 4.2, but failed, mostly due to
		# differences in animation handling. This code is from there. Maybe it
		# it safer implementation than 3 * await get_tree().process_frame
		# as this was before...
		blockableGNSSSignalMaterial.set_shader_parameter("soundDataSampler", soundDataTexture)
		print("SoundDataSampler set")
		soundDataSamplerSet = true
		
	elif (Engine.is_editor_hint() && Global.cleanTempToolData):		# This is not initialized until GlobalInit inits it
		# (can't set shader param in _ready)
		blockableGNSSSignalMaterial.set_shader_parameter("soundDataSampler", null)
		return

	var shiftedReplayTime = replayTime_Lidar - scanTrackerShaderBaseTime
	
	# This way to get a rounding error when converting from double to float
	# is super-ugly. However, it works.
	# Don't know how to "force-cast" to float-type (32-bit) in godot in a neater way...
	# This is used to get more precice times into shaders for super slo-mo.
	var fractionConvertFloat32Array = PackedFloat32Array()
	fractionConvertFloat32Array.push_back(shiftedReplayTime)
	var replayTimeRemainder = shiftedReplayTime - fractionConvertFloat32Array[0]
	
	if (lidarPointMaterial):
		lidarPointMaterial.set_shader_parameter("replayTime", shiftedReplayTime)
		lidarPointMaterial.set_shader_parameter("replayTimeRemainder", replayTimeRemainder)

	if (lidarLineMaterial):
		lidarLineMaterial.set_shader_parameter("replayTime", shiftedReplayTime)
		lidarLineMaterial.set_shader_parameter("replayTimeRemainder", replayTimeRemainder)

class StashData:
	var blockableGNSSSignalMaterial_SoundDataSampler

func stashToolData():
	var stashStorage:StashData = StashData.new()
	
	stashStorage.blockableGNSSSignalMaterial_SoundDataSampler = blockableGNSSSignalMaterial.get_shader_parameter("soundDataSampler")
	blockableGNSSSignalMaterial.set_shader_parameter("soundDataSampler", null)

	return stashStorage

func stashPullToolData(stashStorage:StashData):
	blockableGNSSSignalMaterial.set_shader_parameter("soundDataSampler", stashStorage.blockableGNSSSignalMaterial_SoundDataSampler)
