@tool
extends Node3D

var animResetStashDone:bool = false

@export var trigStashToolData:bool = false:
	set(param):
		print("trigStashToolData setter called (BlockableGNSSSignal): ", param)
		if (!animResetStashDone && param):
			stashToolData()
			animResetStashDone = true
	get:
		return false
		
func _ready():
#	print_debug("_ready\t",Time.get_ticks_msec(),"\t",self.get_path())
	if (!Global):
		return
	
	if (Engine.is_editor_hint() && Global.cleanTempToolData):
		# @tool-scripts will generate changes that are saved into .tscn (scene)-files.
		# Clean them when requested
		
		print("Cleaning data generated by @tool, ", self.name)
		$Surface.material_override = null
		return

	# Not sure if this is needed:
	await get_tree().process_frame

	$Surface.material_override = Global.blockableGNSSSignalMaterial
	$Surface.material_override.set_shader_parameter("startOrigin_Object", Vector3($Surface.mesh.size.x / 2, 0, 0) + $Surface.mesh.center_offset)
	$Surface.material_override.set_shader_parameter("endOrigin_Object", Vector3(-$Surface.mesh.size.x / 2, 0, 0) + $Surface.mesh.center_offset)

#func _process(_delta):
# Another hack: When physics are disabled (due to scaling breaking it)
# raycasting is _physics_process is not ran.
# So show all signals when physics is disabled

# no get_active here...........
#	if (!PhysicsServer3D.get_active()):
#		$Surface.visible = true
		
# NOTE: These are not set here since the same material is shared between
# all instances of this class. So you can't have different signals this way, 
# sorry (not sorry)
#	if (Global.soundDataTexture != null) && (!initDone):
#		$Surface.material_override.set_shader_param("soundDataSampler", Global.soundDataTexture)
#		initDone = true
#	$Surface.material_override.set_shader_param("startOrigin_Object", Vector3($Surface.mesh.size.x / 2, 0, 0) + $Surface.mesh.center_offset)
#	$Surface.material_override.set_shader_param("endOrigin_Object", Vector3(-$Surface.mesh.size.x / 2, 0, 0) + $Surface.mesh.center_offset)

func _physics_process(_delta):
	if (!Global || (Engine.is_editor_hint() && Global.cleanTempToolData)):
		return

	if (animResetStashDone):
		stashPullToolData()
		animResetStashDone = false

	if (Global.blockableGNSSSignalRaycast):
#	$Surface.visible = true
#	return
	
#	if (Engine.is_editor_hint()):
#		$Surface.visible = true
#	else:
		var space_state = get_world_3d().direct_space_state
		# use global coordinates, not local to node
		var params:PhysicsRayQueryParameters3D = PhysicsRayQueryParameters3D.new()
		params.from = self.global_transform.origin
		params.to = self.global_transform.origin - global_transform.basis.x * 20
		var result = space_state.intersect_ray(params)
		$Surface.visible = result.is_empty()
	else:
		$Surface.visible = true

class StashData:
	var blockableGNSSSignalMaterial
	var startOrigin_Object
	var endOrigin_Object

var stashStorage:StashData = StashData.new()

func stashToolData():
	var surface = get_node_or_null("Surface")
	
	if (surface):
		print("Stashing tool data (BlockableGNSSSignal)")
		stashStorage.blockableGNSSSignalMaterial = surface.material_override
		stashStorage.startOrigin_Object = surface.material_override.get_shader_parameter("startOrigin_Object")
		stashStorage.endOrigin_Object = surface.material_override.get_shader_parameter("endOrigin_Object")
		surface.material_override = null

func stashPullToolData():
	var surface = get_node_or_null("Surface")
	
	if (surface):
		print("Stash pulling tool data (BlockableGNSSSignal)")
		surface.material_override = stashStorage.blockableGNSSSignalMaterial
		surface.material_override.set_shader_parameter("startOrigin_Object", stashStorage.startOrigin_Object)
		surface.material_override.set_shader_parameter("endOrigin_Object", stashStorage.endOrigin_Object)
