#version 330 core

out vec4 FragColor;

in vec3 ourColor; 
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture12; 
varying vec3 position;
int MAX_STEPS = 100;
float MAX_DIST = 100.;
float SURF_DIST = .01;
float b_time = u_time - 270;
void main()
{
	// Flopine way:
	vec2 uv = vec2(gl_FragCoord.x / u_resolution.x, gl_FragCoord.y / u_resolution.y);
	vec3 canvas = vec3(texture(texture12, uv).rgb);
	uv -= 0.5;
	uv /= vec2(u_resolution.y / u_resolution.x, 1);
	float hellox = length(uv.x) - (length(position.x) / cos(length(uv.x))) - sin(length(dot(uv.x, uv.y)));
	float helloy = pow(length(uv.y), 2.) / sin(length(position.y)) - length(hellox);
	float helloa = dot(length(uv.y * 10.5), length(uv.y)) / helloy;
	float result = tan(2. - (pow(hellox - helloy, -1.))) - (helloa / hellox * 0.1) * (atan(b_time *.2));
	float hellob = dot(length(helloa)  / length(sqrt(hellox)), length(uv.y));
	vec2 coord = (gl_FragCoord.xy / u_resolution.xy);
	vec3 color = vec3(0.0);
	
	if(b_time < 14) {
		color = vec3(result +sin(coord.x - hellox) * cos(b_time)) ;
		color *= (hellox * helloa) - result - (atan(b_time * .2)) * length(result);
		color -= sin(abs(coord.y + result)) - atan(length(helloa));
	  FragColor = vec4(vec3(color.x *.3, color.y *.15, color.z *.57 ), 1.0);
	}
	if(b_time > 14){
		
		color += vec3(result +sin(coord.x / hellox)) ; //* atan(b_time)
		color *= atan(length(abs(coord.x)- coord.y* tan(b_time * .1))/ hellox + length(pow(uv.y, -1.)))  / (length(pow(helloy, -1.) - pow(hellox, -1.))) * cos(b_time)  ; // + (atan(b_time * .2))
		FragColor = mix(vec4(vec3(color.x *.3, color.y *.15, color.z *.57 ), 1.0), vec4(canvas.r, canvas.g, canvas.b, 1.), .5);
	 // might not work here : mix( vec4( col.x * curly.x, col.y * .1, col.z * curly.y, 1.0) , vec4(rcol.x, rcol.y, rcol.z, 1.), abs(sin(mixer * b_time)));
	}
	
	
	//FragColor = vec4(vec3(color.x *.3, color.y *.15, color.z *.57 ), 1.0);
	
	
}