#version 330 core

out vec4 FragColor;

in vec3 ourColor;
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture12;
varying vec3 position;
float b_time = u_time - 364.0;
float MAX_STEPS = 100.;
float MAX_DIST = 100.;
float SURF_DIST = .001;
#define S smoothstep;
#define T u_time;
float pi = 3.141592;

float sdSphere( vec2 p, float s )
{
  return length(p)-s;
}

mat2 Rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

float Hash21(vec2 p) {
	p = fract(p*vec2(123.34, 233.53));
	p += dot(p, p+23.234);
	return fract(p.x * p.y);
}

float sdBox(vec3 p, vec3 s) {
    p = abs(p)-s;
	return length(max(p, 0.))+min(max(p.x, max(p.y, p.z)), 0.);
}

float sdBox2d(vec2 p, vec2 s) {
    p = abs(p)-s;
	return length(max(p, 0.))+min(max(p.x, p.y), 0.);
}

float GetDist(vec3 p) {
    //float d = sdBox(p, vec3(1));

    float r1 = 1.7, r2 = .2;
	vec2 cp = vec2(length(p.xz)-r1, p.y);
	//cp *= Rot(u_time); in and out rotation of 2 donuts
	float a = atan(p.x, p.z); // angle around center point
						     // polar angle between -pi and pi
	a += sin(p.y) * sin(b_time);
	cp.x += 1.4 - (dot(cp.x - length(cp.x), 1. -pow(cp.x , 2.))) + ceil(sqrt(cp.x)) * dot(cp.x - .1 - ( cp.x * (floor(cp.x))), sqrt(cp.x)); 
	cp *= Rot(a  - b_time *.5);
	cp.x -= .75 - abs(atan(cp.x)) -.33;
	// you can do length on vec2 too!!
	float d = length(cp)-r2;
    d = sdBox2d(cp, vec2(.1, .3*(sin(4.*a)*.5+.5)))-.1;
	return d * .7; // can make points dissapear, but makes raymarcher slower
}

float RayMarch(vec3 ro, vec3 rd)
	{
	
	float Do = 0.;
	
    for(int i=0; i < MAX_STEPS; i++) {
    	vec3 p = ro + rd * Do;
        float dS = GetDist(p);
        Do += dS;
        if( Do > MAX_DIST || abs(dS) < SURF_DIST) break;
    }
    
    return Do;
}

vec3 GetNormal(vec3 p) {
	float d = GetDist(p);
    vec2 e = vec2(.001, 0);
    
    vec3 n = d - vec3(
        GetDist(p-e.xyy),
        GetDist(p-e.yxy),
        GetDist(p-e.yyx));
    
    return normalize(n);
}

vec3 GetRayDir(vec2 uv, vec3 p, vec3 l, float z) {
    vec3 f = normalize(l-p),
        r = normalize(cross(vec3(0,1,0), f)),
        u = cross(f,r),
        c = f*z,
        i = c + uv.x*r + uv.y*u,
        d = normalize(i);
    return d;
}

vec3 Bg(vec3 rd){
	float k = rd.y * .5 + .5 ; // 0 - 1 range
	
	vec3 col = mix(vec3(.9, .1, .1), vec3(.2, .2, 1.), k);
	return col;
}

void main()
{
	vec2 uv = (gl_FragCoord.xy - .5*u_resolution.xy) /u_resolution.y;
	vec3 col = vec3(0);
	vec3 ro = vec3(0, 3, -3);
    ro.yz *= Rot(-0.5);
    ro.xz *= Rot(.995);
    vec3 rd = GetRayDir(uv, ro, vec3(0,0.,0), 1.);
    
	
	col += Bg(rd);
   
    float d = RayMarch(ro, rd);

    if(d<MAX_DIST) {
        vec3 p = ro + rd * d;
        vec3 n = GetNormal(p);
        vec3 r = reflect(rd, n);
		
		// for allowing spec to go negative :: float spec = r.y;
		// or not::
		//float spec = max(0., r.y);
		// or even sharper::
		float spec = pow(max(0., r.y), 30.);
		
        float dif = dot(n, normalize(vec3(1,2,3)))*.5+.5;
        //col += vec3(dif);
		//col = Bg(r);
		col = mix(Bg(r), vec3(dif), .5)+spec;
	}
    
    col = pow(col, vec3(.4545));

	FragColor = vec4(col, 1.);
}