#version 330 core
out vec4 FragColor;

in vec3 ourColor; // is this necessary?
in vec2 TexCoord;

uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture14; 
float pi = 3.149293;

vec2 uv = (gl_FragCoord.xy -.5*u_resolution.xy)/u_resolution.y;
vec2 UV = gl_FragCoord.xy/u_resolution.xy; // to change the width of the thing based on the location on screen
												// original uv coordinates without any changes :: 0,0 to 1,1    
#define coloured_grid(_id) vec3(1., rand(_id.x), rand(_id.y))
#define anim(t) (3.141592/3. * (floor(t)+pow(fract(t),3.))) 
vec2  hr = vec2(1., sqrt(3.));
float detail = 16.; // 25. for this?
float time = u_time;
float b_time = time - 180;

float HexDist2(vec2 p)
{
	p = abs(p);
	p.x = pow(p.x, -1);
	float c = dot(p, normalize(vec2(1, 1.73)));
	c = max(c, p.x);
	c = pow(c, -1);
	return c;

}

vec4 HexCoords2(vec2 uv)
{
	vec2 r = vec2(1, 1.73);
	vec2 h = r*.5;
	vec2 a = mod(uv, r)-h;
	vec2 b = mod(uv-h, r)-h;
	vec2 gv = dot(a,a) < dot(b,b) ? a : b;
	
	float x = atan(gv.x, gv.y);
	float y = .5-HexDist2(gv);
	vec2 id = uv-gv;
	return vec4(x, y, id.x, id.y);
	
}

float rand (float x)
{ return fract(sin(x)*25.55);}
 
mat2 rot(float a)
{
	return mat2(cos(a), sin(a), -sin(a), cos(a));
}

vec2 moda(inout vec2 uv, float rep)
{
	float per = 2. * pi/rep;
	float a = atan(uv.y, uv.x);
	float l = length(uv);
	a = mod(a, per)-per*0.5;
	return vec2(cos(a), sin(a))*l;

}
float HexDist (vec2 uv)
{

	uv = (uv)*(1/atan(uv.x-sin(b_time*.1)));
	return max(dot(uv, normalize(hr)), uv.x);
}

vec4 HexGrid(vec2 uv)
{
	uv *= detail;
	vec2 ga = mod(uv, hr)-hr*0.5;
	vec2 gb = mod(uv-hr*0.5, hr) - hr*0.5;
	vec2 guv = dot(ga, ga) < dot(gb, gb) ? ga : gb;
	
	vec2 id = uv-guv;
	//guv.y = HexDist(guv);
	guv.y = .5-HexDist(guv);
	return vec4(guv.x, guv.y, id.x, id.y);
}
vec4 HexGrid2(vec2 uv)
{
	uv *= detail;
	vec2 ga = mod(uv, hr)-hr*0.5;
	vec2 gb = mod(uv-hr*0.5, hr) - hr*0.5;
	vec2 guv = dot(ga, ga) < dot(gb, gb) ? ga : gb;
	
	vec2 id = uv-guv;
	//guv.y = HexDist(guv);
	guv.y = .5-HexDist(guv);
	guv.x = pow(guv.x, -1);
	return vec4(guv.x, guv.y, id.x, id.y);
}

float sphere_mask(vec2 id)
{
	float s1 = step(length(id), 2.5);
	//here rotating is fine :: id *= rot(-time);
	id *= rot(-anim(-b_time)); // difference between -anim and -time?
	id = moda(id, 7.);
	//if rotating after moda() then artifacts :: id *= rot(time);
	id.x -= 5.5 * fract(id.x * length(s1));
	return smoothstep(fract(id.x)-sqrt(.1 - id.y), 2., length(id)) + s1;
	//return smoothstep(2.5, 2.*fract(abs(sin(b_time))), length(id)) + s1;
}

float line_mask(vec2 id)
{
	id *= rot(-anim(b_time));
	id.yx = moda(id.yx, 3.);
	id.x -= 1.;
	//id.x += sin(id.y + b_time);
	return step(abs(id.x), 2.);//return step(abs(id.x), 2.+id.y*.4);
} 
float sphere_mask2(vec2 id)
{
	float s1 = step(length(id), 2.5*fract(sin(time)));
	//here rotating is fine :: id *= rot(-time);
	id *= rot(time + (.1 *id.x)) + (tan(time ) * .2);
	id = moda((id), fract(s1));
	//if rotating after moda() then artifacts :: id *= rot(time);
	id.x -= 5.5;
	return smoothstep(fract(s1), fract(id.x - 1.), length(id)) + s1;
	//return smoothstep(2.5, 2.*fract(abs(sin(time))), length(id)) + s1;
}

float line_mask2(vec2 id)
{
	//id *= rot(pi/3.*(floor(-time)+pow(fract(-time), 5.)));
	id.yx = moda(id.yx, 3.);
	id.x -= 1.;
	//id.x += sin(id.y + time);
	return step(abs(id.x), 2.);//return step(abs(id.x), 2.+id.y*.4);
} 
float wave1 (vec2 id)
{
	id.y += 2.5;
	id.y += sin(id.x + b_time*2.);
	return step(id.y, .5);
}

float wave2 (vec2 id)
{
	id.y -= 2.5;
	id.y += sin(id.x - b_time*3.);
	return step(.5, id.y);
}



vec3 lines_hexa (vec2 id)
{
	float m = clamp(line_mask(id) - sphere_mask(id), 0., 1.);
	return coloured_grid(id).xxy*.7*m;

}

vec3 spheres_hexa(vec2 id)
{
	return coloured_grid(id).yxz * .6  * sphere_mask(id);
}

vec3 background(vec2 id)
{
	float foreground_masks = sphere_mask(id) + line_mask(id);
	float m1 = clamp(wave1(id)-foreground_masks, 0., 1.);
	float m2 = clamp(wave2(id)-foreground_masks, 0., 1.);
	return (coloured_grid(id).zyx * .7 * m1 + coloured_grid(id).xyz * 0.7 * m2) *.5;
}


vec3 frame(vec2 uv)
{
	vec4 hc = HexGrid(uv);
	
	
	vec3 col = lines_hexa(hc.zw) + spheres_hexa(hc.zw) + background(hc.zw);
	col += step(1. - (hc.y + sin(length(uv + b_time)*.5)), 0.9 )*.4;
	//col = vec3(wave2(hc.zw) + wave1(hc.zw) );
	
	return col;
}
vec3 frame2(vec2 uv)
{
	vec4 hc = HexGrid2(uv);
	hc.x = pow(hc.y, -1.) * sin(-b_time *.2);
	//vec3 col = coloured_grid(hc.zw).zyy * line_mask2(hc.zw) + step(1. - hc.y, 0.9 )*.5;
	vec3 col = coloured_grid(hc.zw).zyy * sphere_mask2(hc.zw) + step(1. - hc.y, 0.9 )*.5;
	col += vec3(sphere_mask(hc.wz) * line_mask(hc.yx));
	col = vec3(col.x * smoothstep(pow(hc.z, 2.) , (hc.x) * 2.,sqrt(col.x)), col.y * smoothstep(sqrt(hc.y), sqrt(col.y), pow(hc.w, 2.)), smoothstep(pow(col.z, -1), sqrt(hc.y), pow(hc.x, -1)) );
	return col;
}
void main()
{
	vec3 col = vec3(0.);

	//if(b_time > 11 && b_time < 14)FragColor = texture(texture14, TexCoord);
	
	if(b_time < 12 )
	{
		uv *= 15.;
		vec4 hc = HexCoords2(uv);
	
		float c = smoothstep(.05, .1, hc.y*sin(hc.z*hc.w+b_time -( uv.x * uv.y)));
		c = abs(atan(pow(c, -1) * b_time));
		col += c;
		FragColor = texture(texture14, TexCoord) *vec4(col.x * .1, col.y, col.z * 0.9, 1.0);
	}
	
	if(b_time > 12 && b_time < 22)
	{
		vec3 col = frame(uv);
		FragColor = texture(texture14, TexCoord) *vec4( pow(col,vec3(1.5)), 1.0); //pow(col, vec3(5.5)) for completely black background hexas
	}
	if(b_time > 22){
	vec3 col = frame2(uv);
	
	FragColor = texture(texture14, TexCoord) * vec4(col, 1.);
	}
}