; Suburbs by MX^Addict 2023 (mxadd@mxadd.org)

;
; Config
;
%define TESTKEYEXIT    1				; Exit on keypress
%define RESTORETXTMODE 0				; Restore text mode on exit (usefull for debugging)
%define ASSUMEREGS     1                ; Assume: ax=0 bx=0 cx=255 si=100h

BITS 16
org 100h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;
; Entry point
;
start:

		; ax=0 bx=0 cx=255 si=100h (if assumed)

		; Init gfx

		mov     al, 0x13
		int     0x10
		push    0xa000
		pop     es
		
		; Pal setup

		mov     dx, 0x3c8

%if !ASSUMEREGS
		mov     si, dx					; Frame counter (must be > 100, so use dx value now)
		mov     cx, 255
%endif

		salc                            ; ax = 0
        out     dx, al
		inc		dx						; 0x3c9 - palette port

.palloop:
		mov     al, cl                  ; color index
		neg     al
		shr     al, 1
		out     dx, al                  ; R [0-63]
		shr     al, 1
		out     dx, al                  ; G [0-63]
		shl		al, 2
		out     dx, al                  ; B [0-63]
		loop	.palloop

										; al == 255, cl == 0, dx == 0x3c9, si >= 0x100

		; Main loop

.top:

		inc     si						; next frame
		mov     di, 64000               ; frame buffer offset
		mov     cx, 200                 ; y position (count backwards)

%if TESTKEYEXIT

		; Wait for key

		in      al, 0x60				; read a character from keyboard into AL
		dec     al
		jnz     .yloop                  ; return to top of loop if AL != 1 (ESC)

%if RESTORETXTMODE

		; Restore text mode (for debugging only)

		mov		ax, 0x3
		int		0x10
%endif

		; End!

		ret
%endif

		; YLoop

.yloop:

		mov     bx, 320                 ; x position (count backwards)

		; XLoop

.xloop:

		dec		di						; decrease frame buffer offset (we draw from bottom-right to top-left)
		jz      .top

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		; si == frame index
		; di == pixel position [0 - 320*200]
		; bx == X [0 ... 320]
		; cx == Y [0 ... 200]
		; [es:di] == current pixel address
        ; bp == free
		; dx == free
		; ax == free

       ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		xor		bp, bp					; bz
        
.innerloop:

			push	bx

            inc		bp					; bz++

            mov		ax, bp
            mul		bx
            shr		ax, 7
            add		ax, si
            mov		bx, ax				; bx = ((PX * bz)>>7) + (_Frame>>2);

            mov		ax, bp
            mul		cx
            shr		ax, 6
			mov		dx, si
			shr		dx, 1
            add		ax, dx				; by = ((PY * bz)>>6) + (_Frame>>2);

            ; bx - bx
            ; ax - by
            ; bp - bz
            ; dx - free
            ; if ((((((bx^(bx>>3))&62)&by)|bz)&63)<99-bz) goto .innerloop;

			mov		dx, bx
			shr		dx, 3
			xor		dx, bx	
			and		dx, 62  
			and		dx, ax  
			or		dx, bp  
			and		dx, 63				; (((((bx^(bx>>3))&62)&by)|bz)&63)

			pop		bx

			mov		ax, 99
			sub		ax, bp
            cmp		dx, ax

            jl		.innerloop

		mov		ax, bp					; result in bp
		mul		bp						; res *= res 
		shr		ax, 3					; res >>= 3
		neg		al 
		mov		[es:di], al

		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		; Loop maintance

		dec     bx                              ; next X
		jnz     .xloop
		dec     cx                              ; next Y
		jmp     .yloop

		;; EOP
		
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; EOF