# XGNR23-musica-digital

## Contest Rules

https://xgnr23.xgnrencounter.gal/arte-digital/musica-digital.html

## Project Name

Generative Sountrack Music for Video Games

## Description

This project focuses on creating a generative soundtrack for video games using Python, Pygame, and other related libraries. Generative music is dynamically generated and adapts to the in-game action, providing a unique and immersive musical experience for players.

## Key Features

- **Generative Soundtrack:** Music is generated in real-time and adapts to the game's state, providing a unique musical experience in every playthroug
h.

- **Customizable Classes and Methods:** The project utilizes classes and methods to generate the rhythmic base, melody, and accompaniments. You can customize these elements to suit your game's needs.

- **Music Recording:** The project allows you to record the audio output to WAV files for later use in the game.

## Getting started

```
git clone https://gitlab.com/d3v-pyth0n/xgnr23-musica-digital.git
```

## Development Stack

This project was developed using the following technologies:
- **Python:** The core programming language used for music generation.
- **Audacity:** Used for audio editing and processing.
- **Linux:** The development environment for creating and testing the project.

## Scripts and Usage

**effects_generator.py**
$ python3 effects_generator.py

**melody_generator.py**
$ python3 melody_generator.py

**soundtrack_generator.py**
$ python3 soundtrack_generator.py

## Contributing

Contributions to the project are welcome. If you want to contribute, you can open issues, send pull requests, or collaborate on the development and improvement of generative music.

## Authors and acknowledgment
4lfon (Clan Chiwire) <siempregaming@proton.me>

## License
AGPLv3
