#!/usr/bin/python3
#|----------------------------------------------------------------------------|#
#| Project: Generative Sountrack Music for Video Games.
#| Script: melody_generator.py
#| Description: Generate melodies based on piano sounds effects played randomly
#|   with this script. Part of a toolkit for generative audio.
#| Event: XGNR 2023
#| Author: 4lf0n (clan chiwire) <siempregaming@proton.me>
#| License: AGPLv3
#|----------------------------------------------------------------------------|#
# Modules.
import random
import pygame

# Class.
class MelodyGenerator:
    # Init.
    def __init__(self):
        pygame.mixer.init()
        self.tones = [
            "Piano/Piano19.ogg",
            "Piano/Piano18.ogg",
            "Piano/Piano17.ogg",
            "Piano/Piano16.ogg",
            "Piano/Piano15.ogg",
            "Piano/Piano14.ogg",
            "Piano/Piano13.ogg",
            "Piano/Piano12.ogg",
            "Piano/Piano125.ogg",
            "Piano/Piano124.ogg",
            "Piano/Piano123.ogg",
            "Piano/Piano122.ogg",
            "Piano/Piano121.ogg",
            "Piano/Piano120.ogg",
            "Piano/Piano11.ogg",
            "Piano/Piano119.ogg",
            "Piano/Piano118.ogg",
            "Piano/Piano117.ogg",
            "Piano/Piano116.ogg",
            "Piano/Piano115.ogg",
            "Piano/Piano114.ogg",
            "Piano/Piano113.ogg",
            "Piano/Piano112.ogg",
            "Piano/Piano111.ogg",
            "Piano/Piano110.ogg"
        ]
        # Duration in miliseconds (short, medium, long)
        self.durations = [300, 600, 1000]

    # Choice.
    def choice_tone(self):
        tone = random.choice(self.tones)
        duration = random.choice(self.durations)
        self.play_tone(tone, duration)

    # Play.
    def play_tone(self, filename, duration):
        sonido = pygame.mixer.Sound(filename)
        sonido.play()
        pygame.time.wait(duration)

    # Generate.
    def generate_melodies(self, num_tones):
        for _ in range(num_tones):
            self.choice_tone()


# Main.
if __name__ == "__main__":
    generator = MelodyGenerator()
    generator.generate_melodies(num_tones=30)
