
.include "globals.inc"

; ping sound reconstructed from EX-DOS II / Disk Doctor

; taken from cc65/asminc/c64.inc:
; I/O: SID

SID             := $D400
SID2_offset     := $20
SID_S1Lo        := $D400
SID_S1Hi        := $D401
SID_PB1Lo       := $D402
SID_PB1Hi       := $D403
SID_Ctl1        := $D404
SID_AD1         := $D405
SID_SUR1        := $D406

SID_S2Lo        := $D407
SID_S2Hi        := $D408
SID_PB2Lo       := $D409
SID_PB2Hi       := $D40A
SID_Ctl2        := $D40B
SID_AD2         := $D40C
SID_SUR2        := $D40D

SID_S3Lo        := $D40E
SID_S3Hi        := $D40F
SID_PB3Lo       := $D410
SID_PB3Hi       := $D411
SID_Ctl3        := $D412
SID_AD3         := $D413
SID_SUR3        := $D414

SID_FltLo       := $D415
SID_FltHi       := $D416
SID_FltCtl      := $D417
SID_Amp         := $D418
SID_ADConv1     := $D419
SID_ADConv2     := $D41A
SID_Noise       := $D41B
SID_Read3       := $D41C

.segment "DATA"

pingdata:
   .byte $bb,$22,$00,$00,$10,$0a,$00
   .byte $cf,$22,$00,$00,$10,$0a,$00
   .byte $e3,$22,$00,$00,$10,$0a,$00
   .byte $00,$00,$00,$0f
pingdataend:

.segment "STARTUP"

playping:
   ldx   #$18
:
   lda   pingdata,x
   sta   SID,x
   sta   SID+SID2_offset,x
   dex
   bpl   :-
   lda   #$11
   sta   SID_Ctl1
   sta   SID_Ctl2
   sta   SID_Ctl3
   sta   SID_Ctl1+SID2_offset
   sta   SID_Ctl2+SID2_offset
   sta   SID_Ctl3+SID2_offset
:
   lda   SID_Read3
   bpl   :-
:
   lda   SID_Read3
   bne   :-
   stz   SID_Ctl1
   stz   SID_Ctl2
   stz   SID_Ctl3
   stz   SID_Ctl1+SID2_offset
   stz   SID_Ctl2+SID2_offset
   stz   SID_Ctl3+SID2_offset

   rts

