
.include "fb32x32.inc"

.include "globals.inc"

.define  ROTATE16TO32MATRIX   $e400

.segment "PADATA"

imgcomptable:
   .byte $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f
   .byte $80,$01,$02,$03,$04,$05,$06,$07,$09,$0a,$0b,$0c,$0d,$0e,$0f,$80
   .byte $80,$80,$01,$02,$03,$05,$06,$07,$09,$0a,$0b,$0d,$0e,$0f,$80,$80
   .byte $80,$80,$80,$01,$03,$04,$06,$07,$09,$0b,$0c,$0e,$0f,$80,$80,$80
   .byte $80,$80,$80,$80,$01,$03,$05,$07,$09,$0b,$0d,$0f,$80,$80,$80,$80
   .byte $80,$80,$80,$80,$80,$02,$05,$07,$0a,$0d,$0f,$80,$80,$80,$80,$80
   .byte $80,$80,$80,$80,$80,$80,$03,$07,$0b,$0f,$80,$80,$80,$80,$80,$80
   .byte $80,$80,$80,$80,$80,$80,$80,$07,$0f,$80,$80,$80,$80,$80,$80,$80
   ; reversing could be calculated
   .byte $80,$80,$80,$80,$80,$80,$80,$0f,$07,$80,$80,$80,$80,$80,$80,$80
   .byte $80,$80,$80,$80,$80,$80,$0f,$0b,$07,$03,$80,$80,$80,$80,$80,$80
   .byte $80,$80,$80,$80,$80,$0f,$0d,$0a,$07,$05,$02,$80,$80,$80,$80,$80
   .byte $80,$80,$80,$80,$0f,$0d,$0b,$09,$07,$05,$03,$01,$80,$80,$80,$80
   .byte $80,$80,$80,$0f,$0e,$0c,$0b,$09,$07,$06,$04,$03,$01,$80,$80,$80
   .byte $80,$80,$0f,$0e,$0d,$0b,$0a,$09,$07,$06,$05,$03,$02,$01,$80,$80
   .byte $80,$0f,$0e,$0d,$0c,$0b,$0a,$09,$07,$06,$05,$04,$03,$02,$01,$80
   .byte $0f,$0e,$0d,$0c,$0b,$0a,$09,$08,$07,$06,$05,$04,$03,$02,$01,$00

.assert <* = 0, error, "not page aligned"

.segment "CODE"

clearfb:
   lda   #$00
fillfb:
   ldx   #$00
:
   sta   FRAMEBUFFER+$000,x
   sta   FRAMEBUFFER+$100,x
   sta   FRAMEBUFFER+$200,x
   sta   FRAMEBUFFER+$300,x
   inx
   bne   :-
   rts

showfb:
   jsr   setfbregs
   stz   FB32X32_COPY
   rts

prepfb:
   jsr   setfbregs
   stz   FB32X32_COPYN
   rts

setfbregs:
   stz   FB32X32_SRC+0
   lda   #>FRAMEBUFFER
   sta   FB32X32_SRC+1

   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y

   lda   #$1f
   sta   FB32X32_STEP
   sta   FB32X32_WIDTH
   sta   FB32X32_HEIGHT
   rts


parabola:
   stz   vector2+0
   stz   vector2+1

   ldy   #$00

@loop:
   tya
   clc
   adc   vector2+0
   sta   vector2+0
   lda   vector2+1
   adc   #$00
   sta   vector2+1

   lsr
   lsr
   lsr
   sta   (vector),y

   iny
   bne   @loop

   rts


imgcompress:
   ; in:
   ; TMPBUFFER: src image ($100 bytes)
   ; rotable: image rotation in values $00,$10,$20,...,$f0 ($10 bytes)
   ; A: page of output image
   ldx   #$00
   sta   @shrinkdest+2
   sta   @cleardest+2
@cleardest:
   stz   $ff00,x
   inx
   bne   @cleardest

   ldy   #$00
@shrinkloop:
   tya
   and   #$0f
   sta   @lower4+1
   tya
   and   #$f0
   sta   @upper4+1
   lsr
   lsr
   lsr
   lsr
   tax
@shrinktable:
   lda   rotable,x
@lower4:
   ora   #$00
   tax                     ; X = offset into shrink table
   lda   imgcomptable,x
   bmi   @shrinknext
@upper4:
   ora   #$00
   tax
   lda   TMPBUFFER,x
@shrinkdest:
   sta   $ff00,y
@shrinknext:
   iny
   bne   @shrinkloop
   rts

rotate16to32genmatrix:
   lda   #$0f
   ldy   #$00
@loop2:
   clc
@loop1:
   sta   ROTATE16TO32MATRIX,y
   iny
   adc   #$10
   bcc   @loop1
   dec
   cpy   #$00
   bne   @loop2
   rts


rotate16to32:
   ldx   #$00
:
   lda   ROTATE16TO32MATRIX,x
   tay
   lda   FRAMEBUFFER+$000,x
   sta   FRAMEBUFFER+$100,y
   inx
   bne   :-

   ldy   #$ff
:
   lda   FRAMEBUFFER+$000,x
   sta   FRAMEBUFFER+$300,y
   lda   FRAMEBUFFER+$100,x
   sta   FRAMEBUFFER+$200,y
   dey
   inx
   bne   :-
   bra   show4fb


flip16to32:
   ; take a 16x16 pixel framebuffer and mirror that to 32x32
   ; and display
.if 0
   lda   #>FRAMEBUFFER
   sta   @src1+2
   sta   @src2+2
   sta   @src3+2
   inc
   sta   @dest1+2
   inc
   sta   @dest2+2
   inc
   sta   @dest3+2
.endif

   ldx   #$00
@loop:
   txa
   eor   #$0f
   tay
;@src1:
   lda   FRAMEBUFFER,x
;@dest1:
   sta   FRAMEBUFFER+$100,y

   txa
   eor   #$f0
   tay
;@src2:
   lda   FRAMEBUFFER,x
;@dest2:
   sta   FRAMEBUFFER+$200,y

   txa
   eor   #$ff
   tay
;@src3:
   lda   FRAMEBUFFER,x
;@dest3:
   sta   FRAMEBUFFER+$300,y
   inx
   bne   @loop
   rts

show4fb:
   ldy   #$10
   stz   FB32X32_SRC+0
   lda   #>FRAMEBUFFER
   sta   FB32X32_SRC+1
   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y
   ldx   #$0f
   stx   FB32X32_WIDTH
   stx   FB32X32_HEIGHT
   stx   FB32X32_STEP
   stz   FB32X32_COPYN

   inc
   sta   FB32X32_SRC+1
   sty   FB32X32_DEST_X
   stz   FB32X32_DEST_Y
   stz   FB32X32_COPYN

   inc
   sta   FB32X32_SRC+1
   stz   FB32X32_DEST_X
   sty   FB32X32_DEST_Y
   stz   FB32X32_COPYN

   inc
   sta   FB32X32_SRC+1
   sty   FB32X32_DEST_X
   sty   FB32X32_DEST_Y
   stz   FB32X32_COPY

   rts
