
.include "fb32x32.inc"

.include "globals.inc"

.segment "DATA"

myschedule:
   .word $0000, rotor_init
   .word $0001, rotor_run
   .word $00ff, schedulenext

colortab:
   .byte $0e,$1e,$2e,$3e,$4e,$5e,$6e,$7e,$8e,$9e,$ae,$be,$ce,$de,$ee,$fe
   .byte $0e,$1e,$2e,$3e,$4e,$5e,$6e,$7e,$8e,$9e,$ae,$be,$ce,$de,$ee,$fe

pos      = localram+0
idx      = localram+1
colidx   = localram+2

.segment "CODE"

rotor:
   lda   #<myschedule
   ldx   #>myschedule
   jmp   subschedule

rotor_init:
   ldx   #$00
   lda   #$80
:
   sta   FRAMEBUFFER,x
   inx
   bne   :-

   lda   #FB32X32_CMAP_A800
   sta   FB32X32_COLMAP

   jmp   rotate16to32genmatrix


rotor_run:
   jsr   rotor_darken
   jsr   rotor_turn
;   jsr   rotor_darken
   jsr   rotor_turn
   jmp   rotate16to32


rotor_darken:
   ldx   #$00
@darkenloop:
   lda   FRAMEBUFFER,x
   and   #$0f
   beq   @next
   dec   FRAMEBUFFER,x
@next:
   inx
   bne   @darkenloop
   rts


rotor_turn:
   lda   colidx
   dec
   sta   colidx
   lsr
   ;lsr
   and   #$0f
   clc
   adc   #<colortab
   sta   @lineloop+1
   lda   #>colortab
   adc   #$00
   sta   @lineloop+2

   lda   idx
   and   #$10
   bne   @part2

   lda   idx
   and   #$0f
   eor   #$0f              ; frame 0 starts at pos y0=15
   stz   bl_x0             ; x0=0
   sta   bl_y0
   asl
   asl
   asl
   asl
   sta   pos
   lda   #$0f
   sta   bl_x1
   sta   bl_y1

.if 0
   ldx   bl_x0
   lda   bl_y0
   int   PRHEX16
   lda   #'>'
   jsr   CHROUT
   ldx   bl_x1
   lda   bl_y1
   int   PRHEX16
   lda   #' '
   jsr   CHROUT
.endif

   jsr   bresenhelp

   ldx   #$0f
:
   lda   bresensteps,x
   and   #$10
   ora   #$01
   sta   bresensteps,x
   dex
   bpl   :-
   bra   @draw

@part2:
   lda   idx
   and   #$0f
   sta   bl_x0
   sta   pos
   stz   bl_y0
   lda   #$0f
   sta   bl_x1
   sta   bl_y1

.if 0
   ldx   bl_x0
   lda   bl_y0
   int   PRHEX16
   lda   #'>'
   jsr   CHROUT
   ldx   bl_x1
   lda   bl_y1
   int   PRHEX16
   lda   #' '
   jsr   CHROUT
.endif

   jsr   bresenhelp

   ldx   #$0f
:
   lda   bresensteps,x
   and   #$01
   ora   #$10
   sta   bresensteps,x
   dex
   bpl   :-

@draw:

.if 0
   ldx   #$00
:
   lda   bresensteps,x
   int   PRHEX8
   inx
   cpx   #$10
   bcc   :-
.endif

   lda   idx
   lsr
   and   #$70
   ora   #$8f
   sta   tmp8

   ldx   #$0e
   ldy   pos
@lineloop:
   lda   colortab,x
   sta   FRAMEBUFFER,y

   tya
   clc
   adc   bresensteps,x
   tay

   dex
   bpl   @lineloop

   inx
   lda   colortab,x
   sta   FRAMEBUFFER,y

.if 0
   lda   #$0a
   jsr   CHROUT
.endif

   dec   idx
   lda   pos
   bne   :+
   dec   idx
:
   rts
