#version 450
//#extension GL_EXT_debug_printf : enable

layout(location = 0) in vec3 inPos;
layout(location = 1) in vec3 inNormal;
layout(location = 2) in vec3 inUV;

layout(location = 0) out vec3 outNormal;
layout(location = 1) out vec3 outColor;

layout (push_constant) uniform PushConstants {
    mat4 modelTransform;
    mat4 modelTransformIT;
};

layout(set = 0, binding = 0) uniform FrameUniforms {
    mat4 viewProjMatrix;
    mat4 viewMatrix;
    vec3 cameraPosition;
    float time;
} frameUniforms;

void main() {
//    debugPrintfEXT("MVP is %f", mvpTransform[0][0]);

    vec4 worldPosition = modelTransform  * vec4(inPos, 1.0);
    gl_Position = frameUniforms.viewProjMatrix * worldPosition;
    //outPosition = worldPosition.xyz;

    //outNormal = mat3(modelTransformIT) * inNormal; // world-space normal
    outNormal = inNormal; // object-space normal

    outColor = vec3(1,1,1);
}
