//var gl = new WebGL2RenderingContext(); //enable WebGL 2 partial support

Demo.prototype.init = function()
{
    const settings = new Settings();

    var start = 0;
    var duration = 100;
    var layer = 1; 

    this.loader.addAnimation(
    {
        "start": 0, "duration": duration, "layer": layer
        ,"image": "_embedded/defaultWhite.png",
        color: [
            {
              r: 0,
              g: 0,
              b: 0
            }
          ],
    });

    this.loader.addAnimation(
        {
            "start": 0, "duration": duration, "layer": layer
            ,"image": "_embedded/defaultWhite.png",
            scale: [{ uniform3d: () => (getSceneTimeFromStart()%0.288)*0.3+0.6 }],
            color: [
                {
                  r: 1,
                  g: 0,
                  b: 0
                }
              ],
        });

    this.loader.addAnimation(
        {
            "start": 0, "duration": duration, "layer": layer
            ,"image": "_embedded/defaultWhite.png",
            scale: [{ uniform3d: 0.2 }],
            color: [
                {
                  r: 0,
                  g: 0.5,
                  b: 1
                }
              ],
              position: [
                {
                  x: () => 0.3*Math.sin(Math.sin(getSceneTimeFromStart()*5)),
                  y: () => 0.3*Math.sin(Math.sin(getSceneTimeFromStart()*5)),
                  z: () => 0
                }
              ]
        });
        this.loader.addAnimation(
            {
                "start": 0, "duration": duration, "layer": layer
                ,"image": "_embedded/defaultWhite.png",
                scale: [{ uniform3d: 0.2 }],
                color: [
                    {
                      r: 0,
                      g: 0.5,
                      b: 1
                    }
                  ],
                  position: [
                    {
                      x: () => 0.3*Math.sin(Math.sin(getSceneTimeFromStart()*5)),
                      y: () => -0.3*Math.sin(Math.sin(getSceneTimeFromStart()*5)),
                      z: () => 0
                    }
                  ]
            });
            
            for(let i = 0; i<2; i++)
            {
                this.loader.addAnimation(
                    {
                        "start": 0, "duration": duration, "layer": layer
                        ,"image": "_embedded/defaultWhite.png",
                        scale: [{ uniform3d: 0.2 }],
                        color: [
                            {
                            r: 0,
                            g: 0.5,
                            b: 0,
                            a: () => Math.sin(getSceneTimeFromStart()*4+i) 
                            }
                        ],
                        position: [
                            {
                            x: () => 0.4 - (0.8 * i),
                            y: () => 0.4,
                            z: () => 0
                            }
                        ]
                    });
            }
            for(let i = 0; i<2; i++)
                {
                    this.loader.addAnimation(
                        {
                            "start": 0, "duration": duration, "layer": layer
                            ,"image": "_embedded/defaultWhite.png",
                            scale: [{ uniform3d: 0.2 }],
                            color: [
                                {
                                r: 0,
                                g: 1.0,
                                b: 0.3,
                                a: () => Math.sin(getSceneTimeFromStart()*5+i) 
                                }
                            ],
                            position: [
                                {
                                x: () => 0.4 - (0.8 * i),
                                y: () => -0.4,
                                z: () => 0
                                }
                            ]
                        });
                }
    

    this.loader.addAnimation({
        start: start,
        duration: duration,
        layer: 500,
        light: {
          type: 'Directional',
          // animate intensity
          properties: { intensity: () => 13 }
        },
        color: [{ r: 1.0, g: 1.0, b: 1.0 }],
        position: [
          {
            x: () => 0,
            y: () => 2,
            z: () => 1
          }
        ]
      });

    this.loader.addAnimation([
        {
          start: start,
          duration: 100,
          layer: 500,
          scale: [{ uniform3d: 1.5 }],
          
          object: { name: 'chicken.obj' },
          position: [
            {
              x: () => 0,
              y: () => Math.sin(Math.sin(getSceneTimeFromStart()*5)),
              z: () => 0.
            }
          ],
          color: [
            {
              r:  () => Math.sin(Math.sin(getSceneTimeFromStart()*1)),
              g:  () => Math.sin(Math.sin(getSceneTimeFromStart()*4)),
              b:  () => Math.sin(Math.sin(getSceneTimeFromStart()*7))
            }
          ],
          angle: [
            {
              degreesY: () => getSceneTimeFromStart()*150,
              degreesX: () => 0,
              degreesZ: () => 0
            }
          ]
        }
      ]);

      this.loader.addAnimation([
        {
          start: start,
          duration: 100,
          layer: 500,
          scale: [{ uniform3d: 0.5 }],
          
          object: { name: 'chicken nugget.obj' },
          position: [
            {
              x: () => 2,
              y: () => 0,
              z: () => -1.
            }
          ],
          color: [
            {
              r:  () => Math.sin(Math.sin(getSceneTimeFromStart()*4)),
              g:  () => Math.sin(Math.sin(getSceneTimeFromStart()*7)),
              b:  () => Math.sin(Math.sin(getSceneTimeFromStart()*1))
            }
          ],
          angle: [
            {
              degreesY: () => getSceneTimeFromStart()*150,
              degreesX: () => 90,
              degreesZ: () => 0
            }
          ]
        }
      ]);

      this.loader.addAnimation([
        {
          start: start,
          duration: 100,
          layer: 500,
          scale: [{ uniform3d: 0.5 }],
          
          object: { name: 'chicken nugget.obj' },
          position: [
            {
              x: () => -2,
              y: () => 0,
              z: () => -1.
            }
          ],
          color: [
            {
              r:  () => Math.sin(Math.sin(getSceneTimeFromStart()*4)),
              g:  () => Math.sin(Math.sin(getSceneTimeFromStart()*7)),
              b:  () => Math.sin(Math.sin(getSceneTimeFromStart()*1))
            }
          ],
          angle: [
            {
              degreesY: () => getSceneTimeFromStart()*150,
              degreesX: () => 90,
              degreesZ: () => 0
            }
          ]
        }
      ]);

}