Demo.prototype.pressFire = function (player, isFire)
{
    if (window.gameActive) {
        window.fire[player-1] = isFire;
    }
};

Demo.prototype.gameInput = function (action) {
    if(!window.gameActive) {
        return;
    }

    let down = undefined;

    if (action === 'mousedown' || action === 'touchstart') {
        down = true;
    } else if (action === 'mouseup' || action === 'touchend') {
        down = false;
    } else {
        throw new Error(`Unknown action: ${action}`);
    }

    //const mouseX = (new window.DemoEngine.Input()).cursorPosition?.x || 0;
    // TODO: left screen P1, right screen P2
    this.pressFire(1, down);

};

Demo.prototype.addGameInput = function ()
{
    const demo = this;

    window.menuSelection = 0;
    window.menuSelect = false;

    let touchEndHandled = false;
    let touchEndTimeout = null;

    const handleEndEvent = (eventType, event) => {

        // Set cursor position and call the end handler
        if (eventType === 'mouseup') {
            (new DemoEngine.Input()).setCursorPosition(event);
        }

        if(window.gameActive) {
            this.gameInput(eventType);
        }
        else {
            if (touchEndHandled) {
                return;
            }
            touchEndHandled = true;        
            if (touchEndTimeout) {
                clearTimeout(touchEndTimeout);
            }
            touchEndTimeout = setTimeout(() => {
                touchEndHandled = false;
                touchEndTimeout = null;
            }, 100);

            if (window.gameActive) {
                this.backToMainMenu();
            } else {
                this.menuInput('Click');
            }
        }

    };

    const canvas = document.getElementById('canvas');
    if (canvas) {
        // set mouse cursor visible
        canvas.style.cursor = 'crosshair';

        // prevent default click behavior (stop demo) on the canvas
        canvas.onclick = function (event) {
            event.stopImmediatePropagation();

            //console.log(`Canvas clicked at: ${event.clientX}, ${event.clientY}`);
        };

        canvas.addEventListener('mousedown', (event) => {
            event.stopImmediatePropagation();
            if (event.repeat) return;

            //console.log(`Mouse down at: ${event.clientX}, ${event.clientY}`);
            (new DemoEngine.Input()).setCursorPosition(event);
            demo.gameInput('mousedown');
        });

        canvas.addEventListener('mouseup', (event) => {
            event.stopImmediatePropagation();
            if (event.repeat) return;

            //console.log(`Mouse up at: ${event.clientX}, ${event.clientY}`);
            handleEndEvent('mouseup', event);
        });
        window.addEventListener('touchmove', (event) => {
            event.stopImmediatePropagation();
            if (event.repeat) return;
            const touch = event.touches[0];
            //console.log(`Touch move at: ${touch.clientX}, ${touch.clientY}`);
            input.setCursorPosition(touch);
        });
        canvas.addEventListener('touchstart', (event) => {
            event.stopImmediatePropagation();
            if (event.repeat) return;

            const touch = event.touches[0];
            //console.log(`Touch started at: ${touch.clientX}, ${touch.clientY}`);
            (new DemoEngine.Input()).setCursorPosition(touch);

            demo.gameInput('touchstart');
        });

        canvas.addEventListener('touchend', (event) => {
            event.stopImmediatePropagation();
            if (event.repeat) return;

            //console.log(`Touch ended`);
            handleEndEvent('touchend', event);
        });
    }
    
  document.addEventListener('keydown', (event) => {
    event.stopImmediatePropagation();
    if (event.key === 'Escape') {
     // console.log('Escape pressed');
        if(window.gameActive) {
            demo.backToMainMenu();
        } else {
            if (demo.closeHighScoreDiv()) {
                demo.backFromLevelEnd();
            } else if (demo.activeDialog) {
                demo.handleDialogInput(event.key);
            } else {
                demo.exitGame();
            }
        }
      return;
    }

        if (event.repeat) return;

        if (event.key === ' ')
        {
            if(window.gameActive)
                demo.pressFire(1, true);
            else
                demo.menuInput('Enter');
        } else if (window.gameActive === false) {
            demo.menuInput(event.key);
        }

        if (event.key === 'Enter')
        {
            if(window.gameActive)
                demo.pressFire(2, true);
            else
                demo.menuInput('Enter');
        } else if (window.gameActive === false) {
            demo.menuInput(event.key);
        }

      }, true);

    window.addEventListener('keyup', (event) =>
    {
        if (event.repeat) return;
     //   console.log(`Key raised: ${event.key}`);

        if (event.key === ' ')
        {
            demo.pressFire(1, false);
        }

        if (event.key === 'Enter')
        {
            demo.pressFire(2, false);
        }

    });


};
