
Demo.prototype.sceneChoice = function () {
  this.setScene('choice');

  this.loader.addAnimation({ image: '_embedded/defaultWhite.png', color: [{ r: 0, g: 0, b: 0 }] });

    const addPlasmaSkysphere = () => {
    const angle = -20.0;
  const skyColor = 0.3;
  this.loader.addAnimation({
    object: 'multiSceneEffects/tex_milky_way.png',
    shape: { type: 'SKYSPHERE' },
    color: [{ r: skyColor, g: skyColor, b: skyColor }],
    "angle":[{
      "degreesX":angle
      }],
    shader:{
      vertexShaderPrefix:`
        uniform float time;
      `,
      vertexShaderSuffix:`
        vMapUv.x = vMapUv.x - time * 0.002;
      `,
      fragmentShaderPrefix:`
        uniform float time;
        //uniform vec4 color;
void drawSphereEffect()
{
  vec2 uv = vMapUv.xy;

  vec2 uvWavy = uv;
  uvWavy.x += sin(uv.y * 10.0 + time * 1.) * 0.05;
  uvWavy.y += cos(uv.x * 10.0 + time * 1.) * 0.05;
  vec4 originalTexture = texture(map,uvWavy);

  vec2 uvWavy2 = uv*0.8;
  uvWavy2.x += sin(uv.x * 10.0 + time * 2.) * 0.05;
  uvWavy2.y += cos(uv.y * 10.0 + time * 1.) * 0.05;
  vec4 originalTexture2 = texture(map,uvWavy2);

  vec2 uvWavy3 = uv*0.6;
  uvWavy3.x += sin(uv.x * 10.0 + time * 2.) * 0.05;
  uvWavy3.y += cos(uv.y * 10.0 + time * 0.8) * 0.05;
  vec4 originalTexture3 = texture(map,uvWavy3);

  vec3 textureBlend = min(originalTexture.rgb + originalTexture2.rgb + originalTexture3.rgb, vec3(1.0));

  uv *= 1.0;
  float plasma1 = sin(uv.x + time * 2.);
  float plasma2 = sin(uv.y + time * 2.);
  float plasma3 = sin((uv.x + uv.y) * 0.5 + time * 4.);
  float plasma4 = sin(sqrt(uv.x * uv.x + uv.y * uv.y) + time * 5.);
  float plasma = (plasma1 + plasma2 + plasma3 + plasma4) * 0.25;
  vec3 color1 = vec3(1.0, 0.2, 0.1);
  vec3 color2 = vec3(0.1, 0.3, 1.0);
  vec3 color3 = vec3(1.0, 0.8, 0.1);
  
  vec3 finalColor = mix(color1, color2, sin(plasma * 3.14159) * 0.5 + 0.5);
  finalColor = mix(finalColor, color3, cos(plasma * 2.0 + time * 0.001) * 0.3 + 0.3);
  float brightness = sin(plasma * 2.0 + time * 0.002) * 0.3 + 0.7;
  finalColor *= brightness;

  gl_FragColor = vec4(min(finalColor * (textureBlend*1.5), vec3(1.0)), 1.0);
  gl_FragColor.rgb *= ${skyColor};
}
      `,
      fragmentShaderSuffix:`

      drawSphereEffect();
      `
    }
  });
  };
  
  addPlasmaSkysphere();


  this.addTrailerText({text:"Meaningful Choices",x:0,y:.24,scale:2.2, gray:true});

    this.loader.addAnimation([
    {
      object: {
        name: '3d_models/obj_earth.obj'
      },
      position: [
        {
          x: .25 ,
          y: ()=>.05*Math.sin(getSceneTimeFromStart()*3)+.1,
          z: 0
        }
      ],
      angle: [
        {
          degreesY: () => -200*getSceneTimeFromStart(),
        }
      ],
      scale: [{ uniform3d: 1  }]
    }
  ]);

  this.loader.addAnimation({
    image: 'images/textbox_choice.png',
    color: [{r:1,g:()=>Sync.get('Choices:SelectR') > .01 ? 0 : 1.0 ,b:()=>Sync.get('Choices:SelectR') > .01 ? 0 : 1.0,"a":1}],
    perspective:"2d",
    position:[{x:.22, y:-.1}],
    angle:[{degreesZ:0}],
    scale: [{ x: ()=>1.4+Sync.get('Choices:SelectR')*Math.sin(5*getSceneTimeFromStart()),y:()=>1.4+Sync.get('Choices:SelectR')*Math.sin(5*getSceneTimeFromStart()) }],
    material:{
      blending: 'NormalBlending',
      transparent:true,
      alphaTest:0.01,
      depthWrite:true,
    }
  });

  this.loader.addAnimation({
    image: 'images/textbox_choice.png',
    color: [{r:1,g:()=>Sync.get('Choices:SelectL') > .01 ? 0 : 1.0 ,b:()=>Sync.get('Choices:SelectL') > .01 ? 0 : 1.0,"a":1}],
    perspective:"2d",
    position:[{x:-.22, y:-.1}],
    angle:[{degreesZ:0}],
    scale: [{ x: ()=>1.4+Sync.get('Choices:SelectL')*Math.sin(5*getSceneTimeFromStart()),y:()=>1.4+Sync.get('Choices:SelectL')*Math.sin(5*getSceneTimeFromStart()) }],
    material:{
      blending: 'NormalBlending',
      transparent:true,
      alphaTest:0.01,
      depthWrite:true,
    }
  });

  let rX = .155;
  let lX = -.155;
    this.addTrailerText({text:"DESTROY",x:rX,y:.14,scale:2.1, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"Adapt",x:rX,y:.07,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"MFX",x:rX,y:.02,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"Unique",x:rX,y:-.03,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"Wide Load",x:rX,y:-.08,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"Cr!sp",x:rX,y:-.13,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"Graymarchers",x:rX,y:-.17,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"Minihakkerit",x:rX,y:-.22,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
    this.addTrailerText({text:"RBBS",x:rX,y:-.27,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:RB')});
     
    
    this.addTrailerText({text:"KILL",x:lX,y:.14,scale:2.1, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"Matt Current",x:lX,y:.07,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"ByteRapers",x:lX,y:.02,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"Gorbat Soft",x:lX,y:-.03,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"Future Crew",x:lX,y:-.08,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"U+1F35E",x:lX,y:-.13,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"Magnetismin *",x:lX,y:-.17,scale:1.6, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"Marmot",x:lX,y:-.22,scale:1.6, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
    this.addTrailerText({text:"Chiken",x:lX,y:-.27,scale:1.7, monoSpace:true, blinkable:true, blinkCol:()=>Sync.get('Choices:LB')});
};