
local retval, filePath = reaper.GetUserFileNameForRead("", "Save note data as", ".js")
if not retval or filePath == "" then return end

local itemCount = reaper.CountSelectedMediaItems(0)
if itemCount == 0 then
  reaper.ShowMessageBox("No items selected.", "Error", 0)
  return
end

local notes = {}

for i = 0, itemCount - 1 do
  local item = reaper.GetSelectedMediaItem(0, i)
  local pos = reaper.GetMediaItemInfo_Value(item, "D_POSITION")
  local len = reaper.GetMediaItemInfo_Value(item, "D_LENGTH")
  table.insert(notes, string.format('  { "time": %.6f, "duration": %.6f }', pos, len))
end

local jsArray = "[\n" .. table.concat(notes, ",\n") .. "\n]"

local file = io.open(filePath, "w")
if not file then
  reaper.ShowMessageBox("Failed to write file.", "Error", 0)
  return
end

file:write(jsArray)
file:close()

reaper.ShowMessageBox("Success!", "Export Done", 0)
