; Title: PolyRoll
; Category: 256b DOS Intro
; Author: LBi / Bitbandit
; Date: 2025.09.13
; Compiler: NASM

; Filled vector idea borrowed from Final Bytes by TomCat/Abaddon
; Color palette taken from Gitter by Frag/Fsqrt

	bits 16			; 16bit code generation
	org 0x100		; code start address 100h (COM program)

; AX=0000h, BX=0000h, CX=00FFh, DX=CS, SI=0100h, DI=FFFEh, BP=?, SP=FFFEh, CS=DS=ES=SS

        push 0xa000             ; set es to VGA screen segment
	mov bp, sp
        pop es

	add si, si

	mov al, 0x13		; MCGA mode (320x200x256)
	int 0x10

	salc
	mov dx, 0x3c9
.1:	mov cl, 3
.2:	imul ax, bx, 2
	sar ax, cl
	out dx, al
	loop .2
	inc bx
	jnz .1			; ax=ffff,bx=0,cx=0
	inc ax

	inc cx			; cx=1 (Radius increment)
	mov dx, cx		; dx=1 Polyhedron generation turn count

main:
	add al, cl		; Radius +/-
	cmp al, 150
	jb m1
	neg cl			; Rinc=-1
m1:	test al, al
	jnz m2
	neg cl			; Rinc=+1

	inc dx			; PolyCnt++
	cmp dl, 4
	jbe m2
	mov dl, 1
m2:
	pusha			; -14:di -12:si -10:bp -8:sp -6:bx (-4:dx=PolyCnt) (-2:cx=Rinc) (0:ax=Radius)

	mov al,64
	mul dl
	push ax			; (-16:ax=Palette)

	;xor bx, bx		; count normals
	fld dword [di]	; [a]
	fadd dword [byte si-$100+AINC]	; [a=a+AINC]
	fstp dword [di]	; FPU stack is empty

poly:
	;	xyzxyzxyzxyz
	mov ax, 101110000011b	; 4 normals encoded

.1:
	fld dword [di]	; [angle]
	fld st0			; [a] [a]
	fadd st0		; [2a] [a]
	fldpi			; [pi] [2a] [a]
	fidiv word [bp-4]	; [pi/poly] [2a] [a]
	push dx			; -18:dx
	fimul word [bp-18]	; [pi/poly*dx] [2a] [a]
	pop dx
	fadd st2		; [ra] [2a] [a]

	mov cl, 3
.2:	fld1			; load 1 normal, 3 cooridnates
	shr ax, 1
	jnc .3
 	fchs
.3:	loop .2

	mov cl, 3		; rotate normal 3 times: around X, Y, Z
.4:				; [x] [y] [z] [ra] [2a] [a] - [y] [z] [x] [2a] [a] - [z] [x] [y] [a]
	fxch st3		; [ra] [y] [z] [x] [2a] [a] - [2a] [z] [x] [y] [a] - [a] [x] [y] [z]
	fsincos			; [cos] [sin] [y] [z] [x] [2a] [a]
	fld st3			; [z] [cos] [sin] [y] [z] [x] [2a] [a]
	fmul st1		; [z*cos] [cos] [sin] [y] [z] [x] [2a] [a]
	fxch st4		; [z] [cos] [sin] [y] [z*cos] [x] [2a] [a]
	fmul st2		; [z*sin] [cos] [sin] [y] [z*cos] [x] [2a] [a]
	fxch st3		; [y] [cos] [sin] [z*sin] [z*cos] [x] [2a] [a]
	fmul st2, st0		; [y] [cos] [y*sin] [z*sin] [z*cos] [x] [2a] [a]
	fmulp			; [y*cos] [y*sin] [z*sin] [z*cos] [x] [2a] [a]
	fsubrp st2, st0		; [y*sin] [y*cos-z*sin] [z*cos] [x] [2a] [a]
	faddp st2, st0		; [y'=y*cos-z*sin] [z'=y*sin+z*cos] [x] [2a] [a]
				; [y] [z] [x] [2a] [a] - [z] [x] [y] [a] - [x] [y] [z]
	loop .4

	mov cl, 3
.5:	add si, 4
	fstp dword [si]		; 0=x, 4=y, 8=z
	loop .5
				; FPU stack is empty
	inc bx

	test ax, ax		; rotate all 4 normals
	jnz .1

	dec dx
	jnz poly

	hlt
	xor di, di
	mov cl, 200
yloop:
	push cx			; -18:cx
	sub cx, 100		; Py = Y - 100

	mov dx, 320
xloop:
	push dx			; -20:dx
	sub dx, 160		; Px = X - 160

	pusha			; -36:di -34:si -32:bp -30:sp -28:bx (-26:dx=Px) (-24:cx=Py) (-22:ax=Color)
	fld dword [BIGP]	; [Zmin]
	fld dword [BIGN]	; [Zmax] [Zmin]

sides:
	fld dword [si-8]	; [Nx] [Zmax] [Zmin]
	fimul word [bp-26]	; [Nx*Px] [Zmax] [Zmin]
	fld dword [si-4]	; [Ny] [Nx*Px] [Zmax] [Zmin]
	fimul word [bp-24]	; [Ny*Py] [Nx*Px] [Zmax] [Zmin]
	faddp st1		; [Ny*Py+Nx*Px] [Zmax] [Zmin]
	fisubr word [bp]	; [R-(Ny*Py+Nx*Py)] [Zmax] [Zmin]
	fld dword [si]		; [Nz] [R-(Ny*Py+Nx*Py)] [Zmax] [Zmin]
	fldz			; [0] [Nz] [R-(Ny*Py+Nx*Py)] [Zmax] [Zmin]
	fucomip st1		; [Nz] [R-(Ny*Py+Nx*Py)] [Zmax] [Zmin]
	fdivp st1		; [Pz=(R-(Ny*Py+Nx*Py))/Nz] [Zmax] [Zmin]
	jbe .2

	fucomi st1		; [Pz] [Zmax] [Zmin]
	fcmovb st1		; [Pz] [Zmax] [Zmin] - if (Pz < Zmax) Pz = Zmax
	fstp st1		; [Zmax] [Zmin] - Zmax = Pz
	jb .3
	fld dword [si]		; [Nz] [Zmax] [Zmin]
	fimul word [ZCOLOR]	; [Color] [Zmax] [Zmin]
	fistp word [bp-22]	; [Zmax] [Zmin]
	jmp .3

.2:	fucomi st2		; [Pz] [Zmax] [Zmin]
	fcmovnb st2		; [Pz] [Zmax] [Zmin] - if (Pz >= Zmin) Pz = Zmin(
	fstp st2		; [Zmax] [Zmin] - Zmin = Pz

.3:	sub si, 12
	dec bx
	jnz sides
	popa
	add ax, [bp-16]
BIGN equ $-2
BIGP equ $+1
	fucomip st1		; [Zmin]
	fstp st0		; FPU stack is empty
	jc .1
	salc
.1:
	stosb

	pop dx

	dec dx
	jnz xloop

	pop cx
	loop yloop

	pop ax
	popa
	jmp main

;	in al, 0x60
;	dec ax
;	jnz main
;	ret

AINC equ $
ZCOLOR:	dw -32 ; -129
	dw 0x3d13		; 0.03613 rad = 2.07 deg
