#ifndef RAYTRACE_SETUP_H
#define RAYTRACE_SETUP_H

#define USE_LINKED_LISTS
#define GRID_RES 256
#define VERTEX_BUFFER_SIZE 10000000
#define FACE_BUFFER_SIZE 6000000
#define RT_LINKED_LIST_BUFFER_SIZE 64000000

#define VERTEX_COORD_OFFSET_FLOATS (0)
#define VERTEX_NORMAL_OFFSET_FLOATS (VERTEX_COORD_OFFSET_FLOATS + 3 * VERTEX_BUFFER_SIZE)
#define VERTEX_UV0_OFFSET_FLOATS (VERTEX_NORMAL_OFFSET_FLOATS + 2 * VERTEX_BUFFER_SIZE)
#define VERTEX_COLOR_OFFSET_FLOATS (VERTEX_UV0_OFFSET_FLOATS + 2 * VERTEX_BUFFER_SIZE)

#define VERTEX_COORD_STRIDE_FLOATS 3
#define VERTEX_NORMAL_STRIDE_FLOATS 2
#define VERTEX_UV0_STRIDE_FLOATS 2
#define VERTEX_COLOR_STRIDE_FLOATS 1
#define VERTEX_SIZE_FLOATS (VERTEX_COORD_STRIDE_FLOATS + VERTEX_NORMAL_STRIDE_FLOATS + VERTEX_UV0_STRIDE_FLOATS + VERTEX_COLOR_STRIDE_FLOATS)

// either texture or normal buffer. both are 32bit uint
//#define RT_USE_TEXTURE_GRID_MARKERS 1

// NOTE: We always use raw buffer for partitioning, so enabling this will invoke tiny cost
// of copying the data. The buffer is just few MB though
#define RT_USE_TEXTURE_GRID_MARKERS_FOR_TRAVERSAL 1

#ifdef RT_READ_ONLY
#define BUFF_ATTR readonly
#else
#define BUFF_ATTR
#endif

#endif