#version 460

#define LIGHT_PROPERTIES_BINDING 1
#ifndef MATERIAL_PROPERTIES_BINDING
#define MATERIAL_PROPERTIES_BINDING 2
#endif

#include <shaders/materials/commons.glsl>
#include <shaders/materials/commons_rand.glsl>
#include <shaders/commons_hlsl.glsl>
#include <shaders/materials/noise/noise3d.glsl>
#include <shaders/particles/particles_commons.glsl>

uniform sampler2DArray s_BlueNoise;
uniform sampler2D s_NoiseRGBA;

#include <shaders/deferred/lighting/lighting_support.glsl>

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

layout(location = 1) out struct
{
	vec3    vLocalPos;
	f16vec4 vColor;
	f16vec2 vUV0;
	uint    vIdx;
} vtx_output;

layout(location = 0) out uint instanceID;

// Custom vertex modifiers params

#ifdef INLINE_VERTEX_MODIFIERS_PARAMS_BLOCK

struct VertexInput
{
	uint id;
	vec3 pos;
	vec3 norm;
	vec4 color;
	vec2 uv0;
};

#inline <INLINE_VERTEX_MODIFIERS_PARAMS_BLOCK>
#endif

#ifdef INLINE_VERTEX_MODIFIERS_TRANSFORM_LOCAL_BLOCK
vec3 apply_vtx_modifier(vec3 pos, vec3 norm, in out vec3 color, uint particle_id)
{
	VertexInput vtx_input;
	vtx_input.id    = particle_id;
	vtx_input.pos   = pos;
	vtx_input.norm  = norm;
	vtx_input.color = vec4(color, 1.0);
	vtx_input.uv0   = vec2(0.0, 0.0);

	ModifierFactor modifier_factor = modifier_factor_defaults();
	modifier_factor.factor      = 1.0;
	modifier_factor.hash        = uint(particle_id);
	modifier_factor.id          = uint(particle_id);
	modifier_factor.instance_id = uint(particle_id);

	modifier_factor.position    = pos;
	modifier_factor.is_spawned  = false;

	CoordinateSystemTrasforms cs_transforms;
	cs_transforms.mat_local_to_model     = transform_params.mModel;
	cs_transforms.mat_local_to_instance  = mat_identity();
	cs_transforms.mat_local_to_model_inv = transform_params.mModelInv;

#inline <INLINE_VERTEX_MODIFIERS_TRANSFORM_LOCAL_BLOCK>

	pos   = vtx_input.pos;
	color = vtx_input.color.rgb;
	return pos;
}
#else
vec3 apply_vtx_modifier(vec3 pos, vec3 norm, in out vec3 color, uint particle_id)
{
	return pos;
}
#endif

void main()
{

	instanceID = SYS_VertexIndex;

	int particle_id = SYS_VertexIndex;
	
	vtx_output.vLocalPos = vec3(0.0, 0.0, 0.0);
	vtx_output.vIdx = 0;
	
	// NOTE: Here it somehow prohibts shader optimization? Or just the vs <> fs ratio is so much skewed?:(
	// NOTE: With latest drivers seems to be faster again....
	if (!prt_is_alive(particle_id))
	{
		gl_Position = vec4(0.0 / 0.0, 0.0 / 0.0, 0.0 / 0.0, 0.0 / 0.0);
		return;
	}

	//vec3 vInstPosition = ribbon_get_coords_for_segment(ribbon_id, ribbon_segment);
	
	vec3 vInstPosition = prt_get_position(particle_id);

	vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
	vec4 vInstColor = prt_get_color(particle_id);

	vInstPosition = apply_vtx_modifier(vInstPosition, vInstNormal, vInstColor.rgb, particle_id);

	ParticleState vState = prt_get_state(particle_id);

	vec3 pos = vInstPosition;

	vtx_output.vLocalPos = pos;

	vec3 vPos1 = pos;
	vec3 vPos = vector_transform_by_mat43(vPos1, transform_params.mModelView);

	vtx_output.vColor = f16vec4(vInstColor);
	vtx_output.vIdx = 1;
	
	gl_Position = vector_transform_by_mat_projection(vPos, transform_params.mProjection);
}



