#version 450
#extension GL_EXT_debug_printf : enable

#define MATERIAL_PROPERTIES_BINDING 1
#include <shaders/materials/commons.glsl>
#include <shaders/commons_hlsl.glsl>

#define RT_READ_ONLY 1
#include <shaders/geometry_partitioning/raytrace_buffers.glsl>
#include <shaders/geometry_partitioning/raytrace_commons.glsl>

in vec2 vTexcoord0;

// Use the intersection buffer to detect the edges of the objects. This should not only flag
// rt-nonrt edges (against background or non -raytraced objects) but also edges in the actual reflections
// which we want to refine. This pass is called when rendering RT with VRS

layout(r32ui)    uniform readonly uimage2D imNormalMaterial;
layout(rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(rgba32f)  uniform readonly image2D  imHitDirectionPrimitiveIDReflection;

struct RaytraceRefinementToStencilParams
{
	int scale_denominator;
	int material_flags;
	int _pad0;
	int _pad1;
};

layout (std140, row_major) uniform RaytraceRefinementToStencilParamsBuffer
{
	RaytraceRefinementToStencilParams params;
};

void main() {

	ivec2 pixel_pos = ivec2(gl_FragCoord.xy);

	MetalnessRoughnessMeterialTags mrmt = decode_metalness_roughness_material_tags(imageLoad(imMetalnessRoughnessMaterialTags, pixel_pos));
	
	bool is_background = true;
	uint encoded_normal_material = imageLoad(imNormalMaterial, pixel_pos).r;
	int materialId = decode_material(encoded_normal_material);
	if ((materialId & MATERIAL_ID_MASK_ATTR) != ATTR_BACKGROUND)
		is_background = false;

	if (is_background)
	{
		discard;
		return;
	}

	vec4 hit_direction_primitiveID_reflection = imageLoad(imHitDirectionPrimitiveIDReflection, pixel_pos);
	uint hit_primitiveID = asuint(hit_direction_primitiveID_reflection.a);
	int  hit_material    = rt_get_triangle_material(hit_primitiveID);

	bool is_candidate = false;

#if 0
	const int search_r    = 1;
	const int search_step = 1;
	for(int iy = -search_r; iy <= search_r; iy+=search_step)
	{
		for(int ix = -search_r; ix <= search_r; ix+=search_step)
		{
			if (ix == 0 && iy == 0)
				continue;

			ivec2 neighbor_pixel_pos = pixel_pos + ivec2(ix, iy);

			MetalnessRoughnessMeterialTags neighbor_mrmt = decode_metalness_roughness_material_tags(imageLoad(imMetalnessRoughnessMaterialTags, neighbor_pixel_pos));
			uint neighbor_encoded_normal_material = imageLoad(imNormalMaterial, neighbor_pixel_pos).r;
			int  neighbor_materialId = decode_material(neighbor_encoded_normal_material);
			if ((neighbor_materialId & MATERIAL_ID_MASK_ATTR) != ATTR_BACKGROUND)
			{
				if (mrmt.material_index != neighbor_mrmt.material_index)
					is_candidate = true;

				vec4 neighbor_hit_direction_primitiveID = imageLoad(imHitDirectionPrimitiveIDReflection, neighbor_pixel_pos);
				uint neighbor_hit_primitiveID = asuint(neighbor_hit_direction_primitiveID.a);
				int  neighbor_hit_material    = rt_get_triangle_material(neighbor_hit_primitiveID);

				if (hit_material != neighbor_hit_material)
					is_candidate = true;
			}
		}
	}
#else
	// any VRS-related artifacts will be inside aligned 2x2 block. Analyze aligned 2x2 blocks only. This has a limitation that
	// we are only detecting material discontinuities. We can not detect hit discontinuities.
	uint x0 = pixel_pos.x & (~1);
	uint y0 = pixel_pos.y & (~1);

	for(int iy = 0; iy < 2; iy++)
	{
		for(int ix = 0; ix < 2; ix++)
		{
			ivec2 neighbor_pixel_pos = ivec2(x0, y0) + ivec2(ix, iy);
			ivec2 neighbor_block_pixel_pos = ivec2(x0, y0) + ivec2(ix, iy) * 2;	// skip to the adjacent block
			if (neighbor_pixel_pos.x == pixel_pos.x && neighbor_pixel_pos.y == pixel_pos.y)
				continue;

			MetalnessRoughnessMeterialTags neighbor_mrmt = decode_metalness_roughness_material_tags(imageLoad(imMetalnessRoughnessMaterialTags, neighbor_pixel_pos));
			uint neighbor_encoded_normal_material = imageLoad(imNormalMaterial, neighbor_pixel_pos).r;
			int  neighbor_materialId = decode_material(neighbor_encoded_normal_material);
			if ((neighbor_materialId & MATERIAL_ID_MASK_ATTR) != ATTR_BACKGROUND)
			{
				if (mrmt.material_index != neighbor_mrmt.material_index)
					is_candidate = true;

				vec4 neighbor_hit_direction_primitiveID = imageLoad(imHitDirectionPrimitiveIDReflection, neighbor_block_pixel_pos);
				uint neighbor_hit_primitiveID = asuint(neighbor_hit_direction_primitiveID.a);
				int  neighbor_hit_material    = rt_get_triangle_material(neighbor_hit_primitiveID);

				if (hit_material != neighbor_hit_material)
					is_candidate = true;
			}
		}
	}
#endif
	if (is_candidate == false)
		discard;
}

