#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_shader_explicit_arithmetic_types_int16 : require
#extension GL_EXT_shader_16bit_storage : require
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
#extension GL_KHR_shader_subgroup_ballot : require
#extension GL_KHR_shader_subgroup_basic : require
#extension GL_KHR_shader_subgroup_shuffle : require
#extension GL_KHR_shader_subgroup_arithmetic : require
#extension GL_EXT_debug_printf : require
#extension GL_EXT_shader_realtime_clock : require
layout(local_size_x = 8, local_size_y = 4, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct intersection
{
    float t;
    vec3 normal;
    float denom;
    vec2 bc;
};

struct ray_state_user_data
{
    uint primitiveId;
};

struct ray_traversal_params
{
    float trace_range_primary;
    float trace_range_secondary;
};

struct ray_state
{
    vec3 color;
    vec3 normal;
    vec3 dir;
    vec3 origin;
    float transparency;
    int16_t bounces;
    int16_t material;
    int tests;
    int face_tests;
    uint flags;
    uint active_threads_factor;
    uint active_threads_samples;
    float final_color_factor;
    ray_state_user_data user_data;
};

struct RTSetup
{
    mat4 mat_projection;
    mat4 mat_model;
    vec3 camera_position;
    int screen_sampling_scale;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 frustum_shift;
    vec2 resolution;
    uint64_t buff_grid_markers_ptr;
    float trace_range_primary;
    float trace_range_secondary;
    float roughness_clamp;
    float env_map_intensity;
    int lights_num;
    float initial_face_start_distance;
    uint material_flags;
    int reflect_rays;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _662;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _715;

layout(set = 0, binding = 3, std430) readonly buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _1081;

layout(set = 0, binding = 4, std430) readonly buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint occupied_cell_counter;
    uint _pad0;
    uint _pad1;
    uint _pad2;
    uint _pad3;
    uint _pad4;
    uint _pad5;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 0, binding = 5, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 7, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _2370;

layout(set = 0, binding = 8, std140) uniform RTSetupBuffer
{
    layout(row_major) RTSetup rt_setup;
} _2509;

layout(set = 0, binding = 9, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _2528;

layout(set = 0, binding = 6, std430) readonly buffer buff_dispatch_elements
{
    uint dispatch_elements[];
} _2732;

layout(set = 0, binding = 14) uniform usampler3D s_grid_marker;
layout(set = 0, binding = 15) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 10, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 16) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 11, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 12, rgba8) uniform writeonly image2D imOutDebug;
layout(set = 0, binding = 13, rgba32f) uniform writeonly image2D imOutHitDirectionPrimitiveID;

uint64_t g_buff_grid_markers_ptr;
shared int shared_hit_lane_idx;
shared int shared_closest_fi;
shared float shared_closest_it;

float asfloat(uint v)
{
    return uintBitsToFloat(v);
}

uvec2 dispatch_get_xy(uint dispatch)
{
    uvec2 p;
    p.x = (dispatch >> uint(0)) & 4095u;
    p.y = (dispatch >> uint(12)) & 4095u;
    return p;
}

uint dispatch_get_mask(uint dispatch)
{
    return (dispatch >> uint(26)) & 15u;
}

ivec2 dispatch_get_subsample_offset(uint dispatch)
{
    uint param = dispatch;
    uint mask = dispatch_get_mask(param);
    if ((mask & 1u) != 0u)
    {
        return ivec2(0);
    }
    else
    {
        if ((mask & 2u) != 0u)
        {
            return ivec2(1, 0);
        }
        else
        {
            if ((mask & 4u) != 0u)
            {
                return ivec2(0, 1);
            }
            else
            {
                return ivec2(1);
            }
        }
    }
}

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

float linearizeDepth(float d)
{
    return _2370.dispatch_setup.near_far_plane.z / ((_2370.dispatch_setup.near_far_plane.y + _2370.dispatch_setup.near_far_plane.x) - (d * _2370.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_2370.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _333;
    if (nor.x > 0.0)
    {
        _333 = -t;
    }
    else
    {
        _333 = t;
    }
    nor.x += _333;
    float _348;
    if (nor.y > 0.0)
    {
        _348 = -t;
    }
    else
    {
        _348 = t;
    }
    nor.y += _348;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

uint rt_set_mask(inout uint f, uint m)
{
    uint _832 = f;
    uint _833 = _832 | m;
    f = _833;
    return _833;
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 rt_randomize_dir_for_roughness(inout ivec2 screen_pos, inout vec3 dir, vec3 n, inout float roughness, inout float bounce_throughput)
{
    bounce_throughput = 1.0;
    if (roughness > 0.0)
    {
        roughness = min(_2509.rt_setup.roughness_clamp, roughness);
        roughness = dot(dir, n) * roughness;
        bounce_throughput *= max(0.0, 1.0 - roughness);
        int frame = _2528.globals.monotonic & 127;
        float clamped_roughness = roughness * roughness;
        screen_pos &= ivec2(127);
        vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, 0), 0).xy;
        vec2 hash = fract(_noise + vec2(float(frame) * 1.61803400516510009765625));
        float param = hash.x * clamped_roughness;
        float param_1 = hash.y;
        vec3 d = CosineSampleHemisphere(param, param_1);
        vec3 param_2 = dir;
        mat3 _2577 = matrixFromVector(param_2);
        mat3 vecSpace = _2577;
        d = vecSpace * d;
        float VdotN = dot(d, n);
        if ((VdotN < 0.0) && true)
        {
            hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
            float param_3 = hash.x * clamped_roughness;
            float param_4 = hash.y;
            d = CosineSampleHemisphere(param_3, param_4);
            d = vecSpace * d;
            VdotN = dot(d, n);
            if (VdotN > 0.0)
            {
                dir = d;
            }
        }
        else
        {
            dir = d;
        }
    }
    return dir;
}

vec3 glass_refract(vec3 v, vec3 n)
{
    float s = (dot(v, n) < 0.0) ? 1.0 : (-1.0);
    vec3 new_v = refract(v, n * s, 0.800000011920928955078125);
    if (dot(new_v, new_v) == 0.0)
    {
        return v;
    }
    return new_v;
}

uint rt_clear_mask(inout uint f, uint m)
{
    uint _847 = f;
    uint _848 = _847 & (~m);
    f = _848;
    return _848;
}

uint ballot_count(bool v)
{
    uvec4 ballot = subgroupBallot(v);
    uint cnt = uint(bitCount(ballot.x));
    cnt += uint(bitCount(ballot.y));
    return cnt;
}

uint rt_clear_mask_if(inout uint f, uint m, bool v)
{
    if (v)
    {
        f &= (~m);
    }
    return f;
}

bool rt_is_mask_set(uint f, uint mask)
{
    return (f & mask) != 0u;
}

uint rt_set_mask_if(inout uint f, uint m, bool v)
{
    if (v)
    {
        f |= m;
    }
    return f;
}

bool is_pos_inside_grid(ivec3 icell)
{
    int icell_mask = (icell.x | icell.y) | icell.z;
    if ((icell_mask & (-256)) == 0)
    {
        return true;
    }
    else
    {
        return false;
    }
}

void rt_pack_grid_marker_to_uint_img(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

bool rt_read_grid_marker_high_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint_img(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 0).x & (1u << bit)) != 0u) ? true : false;
}

bool rt_read_grid_marker_low_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint_img(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 2).x & uint(1 << int(bit))) != 0u) ? true : false;
}

bool fetch_grid_marker_for_cell(ivec3 icell, int mip)
{
    if (mip == 0)
    {
        ivec3 param = icell;
        return rt_read_grid_marker_high_res(s_grid_marker, param);
    }
    else
    {
        ivec3 param_1 = icell >> ivec3(2);
        return rt_read_grid_marker_low_res(s_grid_marker, param_1);
    }
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _715.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _715.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _715.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_662.in_vtx_data[coord_offset + 0u], _662.in_vtx_data[coord_offset + 1u], _662.in_vtx_data[coord_offset + 2u]);
    return p;
}

intersection intersectTriangle3(vec3 orig, vec3 dir, vec3 v0, vec3 v1, vec3 v2)
{
    intersection it;
    it.t = -1.0;
    vec3 e1 = v1 - v0;
    vec3 e2 = v2 - v0;
    vec3 pvec = cross(dir, e2);
    float det = dot(e1, pvec);
    if (abs(det) < 1.0000000116860974230803549289703e-07)
    {
        return it;
    }
    float inv_det = 1.0 / det;
    vec3 tvec = orig - v0;
    float u = dot(tvec, pvec) * inv_det;
    if ((u < 0.0) || (u > 1.0))
    {
        return it;
    }
    vec3 qvec = cross(tvec, e1);
    float v = dot(dir, qvec) * inv_det;
    bool _1019 = v < 0.0;
    bool _1027;
    if (!_1019)
    {
        _1027 = (u + v) > 1.0;
    }
    else
    {
        _1027 = _1019;
    }
    if (_1027)
    {
        return it;
    }
    float t = dot(e2, qvec) * inv_det;
    if (t > 1.0000000116860974230803549289703e-07)
    {
        it.normal = normalize(cross(e2, e1));
        float denom = dot(vec3(it.normal), dir);
        vec3 p0l0 = v0 - orig;
        it.t = t;
        it.denom = denom;
        it.bc.x = u / denom;
        it.bc.y = v / denom;
    }
    return it;
}

void findClosestBucket2_Multi(uint list_index, uint fi_first, uint fi_step, vec3 origin, vec3 dir, int skip_fi, float max_t, out int closest_fi, uint material_flags, inout float closest_it, vec3 closest_norm, vec2 closest_bc)
{
    closest_fi = -1;
    closest_it = max_t;
    uint head = _1081.in_faces_list_tails_data[list_index];
    uint cnt = in_faces_list_data.node_buffer[head];
    for (uint fi_idx = fi_first; fi_idx < cnt; fi_idx += fi_step)
    {
        int fi = int(in_faces_list_data.node_buffer[(head + fi_idx) + 1u]);
        if (fi == skip_fi)
        {
            continue;
        }
        uint param = uint(fi);
        RTFace rt_face = rt_get_face(param);
        uint param_1 = rt_face.v0;
        vec3 p0 = rt_get_vertex(param_1);
        uint param_2 = rt_face.v1;
        vec3 p1 = rt_get_vertex(param_2);
        uint param_3 = rt_face.v2;
        vec3 p2 = rt_get_vertex(param_3);
        vec3 param_4 = origin;
        vec3 param_5 = dir;
        vec3 param_6 = p2;
        vec3 param_7 = p1;
        vec3 param_8 = p0;
        intersection it1 = intersectTriangle3(param_4, param_5, param_6, param_7, param_8);
        bool _1303 = it1.t >= 0.0;
        bool _1310;
        if (_1303)
        {
            _1310 = it1.t <= closest_it;
        }
        else
        {
            _1310 = _1303;
        }
        if (_1310)
        {
            if ((rt_face.material_flags & 64u) == 0u)
            {
                if (dot(dir, it1.normal) >= 0.0)
                {
                    continue;
                }
            }
            closest_fi = fi;
            closest_it = it1.t;
        }
    }
}

vec2 rt_barycentric_yz(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 v0 = b - a;
    vec3 v1 = c - a;
    vec3 v2 = p - a;
    float d00 = dot(v0, v0);
    float d01 = dot(v0, v1);
    float d11 = dot(v1, v1);
    float d20 = dot(v2, v0);
    float d21 = dot(v2, v1);
    float denom = (d00 * d11) - (d01 * d01);
    vec3 bc;
    bc.y = ((d11 * d20) - (d01 * d21)) / denom;
    bc.z = ((d00 * d21) - (d01 * d20)) / denom;
    return bc.yz;
}

vec2 barycentric_for_face_yz(int idx, vec3 p)
{
    uint param = uint(idx);
    RTFace rt_face = rt_get_face(param);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_1 = p0_idx;
    vec3 a = rt_get_vertex(param_1);
    uint param_2 = p1_idx;
    vec3 b = rt_get_vertex(param_2);
    uint param_3 = p2_idx;
    vec3 c = rt_get_vertex(param_3);
    vec3 param_4 = p;
    vec3 param_5 = a;
    vec3 param_6 = b;
    vec3 param_7 = c;
    return rt_barycentric_yz(param_4, param_5, param_6, param_7);
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _662.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _662.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 interpolate_normal_from_bc_yz(int fi, vec2 bc_yz, vec3 ref_normal)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec3 n0 = vec3(rt_get_vertex_normal(param_1));
    uint param_2 = i1;
    vec3 n1 = vec3(rt_get_vertex_normal(param_2));
    uint param_3 = i2;
    vec3 n2 = vec3(rt_get_vertex_normal(param_3));
    vec3 smooth_normal = ((n0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (n1 * bc_yz.x)) + (n2 * bc_yz.y);
    return normalize(smooth_normal);
}

void evaluate_material(inout ray_state state, vec3 prev_state_origin, int hit_face, uint hit_material_flags, vec2 bc, bool flip_normal_on_glass)
{
    state.user_data.primitiveId = uint(hit_face);
    uint param = state.flags;
    uint param_1 = 32u;
    uint _2494 = rt_clear_mask(param, param_1);
    state.flags = _2494;
    uint param_2 = state.flags;
    uint param_3 = 4u;
    uint _2500 = rt_set_mask(param_2, param_3);
    state.flags = _2500;
}

void findClosestBucket2(ray_state_user_data user_data, uint list_index, bool bucket_full, uint max_tests, vec3 origin, vec3 dir, int skip_fi, float max_t, inout int closest_fi, inout uint material_flags, inout float closest_it, inout vec3 closest_norm, inout vec2 closest_bc, out int face_tests)
{
    face_tests = 0;
    closest_fi = -1;
    closest_it = max_t;
    uint head = _1081.in_faces_list_tails_data[list_index];
    uint cnt = in_faces_list_data.node_buffer[head];
    if ((max_tests != 4294967295u) && (cnt >= max_tests))
    {
        closest_fi = -1;
        return;
    }
    face_tests = int(cnt);
    for (int fi_idx = 0; uint(fi_idx) < cnt; fi_idx++)
    {
        int fi = int(in_faces_list_data.node_buffer[(head + uint(fi_idx)) + 1u]);
        if (fi == skip_fi)
        {
            continue;
        }
        uint param = uint(fi);
        RTFace rt_face = rt_get_face(param);
        uint param_1 = rt_face.v0;
        vec3 p0 = rt_get_vertex(param_1);
        uint param_2 = rt_face.v1;
        vec3 p1 = rt_get_vertex(param_2);
        uint param_3 = rt_face.v2;
        vec3 p2 = rt_get_vertex(param_3);
        vec3 param_4 = origin;
        vec3 param_5 = dir;
        vec3 param_6 = p2;
        vec3 param_7 = p1;
        vec3 param_8 = p0;
        intersection it1 = intersectTriangle3(param_4, param_5, param_6, param_7, param_8);
        bool _1164 = it1.t >= 0.0;
        bool _1171;
        if (_1164)
        {
            _1171 = it1.t <= closest_it;
        }
        else
        {
            _1171 = _1164;
        }
        if (_1171)
        {
            if ((rt_face.material_flags & 64u) == 0u)
            {
                if (dot(dir, it1.normal) >= 0.0)
                {
                    continue;
                }
            }
            closest_fi = fi;
            closest_it = it1.t;
        }
    }
    if (closest_fi != (-1))
    {
        uint param_9 = uint(closest_fi);
        RTFace rt_face_1 = rt_get_face(param_9);
        uint param_10 = rt_face_1.v0;
        vec3 p0_1 = rt_get_vertex(param_10);
        uint param_11 = rt_face_1.v1;
        vec3 p1_1 = rt_get_vertex(param_11);
        uint param_12 = rt_face_1.v2;
        vec3 p2_1 = rt_get_vertex(param_12);
        vec3 param_13 = origin;
        vec3 param_14 = dir;
        vec3 param_15 = p2_1;
        vec3 param_16 = p1_1;
        vec3 param_17 = p0_1;
        intersection it1_1 = intersectTriangle3(param_13, param_14, param_15, param_16, param_17);
        closest_norm = it1_1.normal;
        closest_bc = it1_1.bc;
        material_flags = rt_face_1.material_flags;
    }
}

ivec3 dda_step_from_dir(vec3 dir, vec3 cell_step)
{
    vec3 s;
    s.x = (dir.x > 0.0) ? 1.0 : (-1.0);
    s.y = (dir.y > 0.0) ? 1.0 : (-1.0);
    s.z = (dir.z > 0.0) ? 1.0 : (-1.0);
    vec3 sgn = s * cell_step;
    return ivec3(sgn);
}

int findClosestDDAMultibounce_New(ray_traversal_params traversal_params, inout ray_state state, inout int skip_fi, inout int closest_fi, inout float closest_it, int max_bounces, float tmax)
{
    closest_fi = -1;
    closest_it = 1000000.0;
    vec3 cellDimension = in_bbox_data.grid_size_raytrace.xyz;
    vec3 cellDimensionRecip = in_bbox_data.grid_size_raytrace_recip.xyz;
    float tmin = 0.0;
    vec3 ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro_cell * cellDimensionRecip));
    vec3 s = step(vec3(0.0), state.dir);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 deltaT = (sgn * cellDimension) / state.dir;
    vec3 nextCrossingT = vec3(tmin) + ((((floor(ro_cell * cellDimensionRecip) + s) * cellDimension) - ro_cell) / state.dir);
    uint traversal_flags = 0u;
    int max_iter = 512;
    bool param = true;
    int threads_running = int(ballot_count(param));
    int param_34;
    uint param_35;
    float param_36;
    vec3 param_37;
    vec2 param_38;
    vec3 closest_normal;
    uint closest_material_flags;
    int param_82;
    uint param_83;
    float param_84;
    vec3 param_85;
    vec2 param_86;
    int param_87;
    for (;;)
    {
        bool hit = false;
        max_iter--;
        state.tests++;
        float rt = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
        uint param_1 = state.flags;
        uint param_2 = 32u;
        bool param_3 = rt >= tmax;
        uint _1509 = rt_clear_mask_if(param_1, param_2, param_3);
        state.flags = _1509;
        uint param_4 = state.flags;
        uint param_5 = 32u;
        bool param_6 = max_iter < 0;
        uint _1518 = rt_clear_mask_if(param_4, param_5, param_6);
        state.flags = _1518;
        uint param_7 = traversal_flags;
        uint param_8 = 1u;
        uint param_9 = traversal_flags;
        uint param_10 = 2u;
        bool param_11 = rt_is_mask_set(param_7, param_8);
        uint _1528 = rt_set_mask_if(param_9, param_10, param_11);
        traversal_flags = _1528;
        uint param_12 = traversal_flags;
        uint param_13 = 1u;
        uint _1532 = rt_clear_mask(param_12, param_13);
        traversal_flags = _1532;
        bool search_bucket = false;
        bool bucket_full = false;
        uint param_14 = state.flags;
        uint param_15 = 32u;
        if (rt_is_mask_set(param_14, param_15))
        {
            ivec3 param_16 = icell;
            if (is_pos_inside_grid(param_16))
            {
                uint param_17 = traversal_flags;
                uint param_18 = 1u;
                uint _1550 = rt_set_mask(param_17, param_18);
                traversal_flags = _1550;
                ivec3 param_19 = icell;
                int param_20 = 0;
                bucket_full = fetch_grid_marker_for_cell(param_19, param_20);
            }
        }
        uint param_21 = state.flags;
        uint param_22 = 32u;
        bool is_running = rt_is_mask_set(param_21, param_22);
        bool param_23 = is_running;
        uint is_running_num = ballot_count(param_23);
        bool param_24 = true;
        uint is_active_num = ballot_count(param_24);
        int prev_closest_fi = closest_fi;
        int set_from_lane = -1;
        uint icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
        float rt_1 = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
        uvec4 active_ballot = subgroupBallot(true);
        uvec4 bucket_full_ballot = subgroupBallot(bucket_full);
        uint64_t bucket_full_mask = (uint64_t(bucket_full_ballot.y) << 32) | uint64_t(bucket_full_ballot.x);
        bool participating = false;
        uint param_25 = state.flags;
        uint param_26 = 128u;
        if (rt_is_mask_set(param_25, param_26) && (bucket_full_mask != 0ul))
        {
            if ((bucket_full_mask & uint64_t(1u << gl_SubgroupInvocationID)) != 0ul)
            {
                participating = true;
            }
        }
        if (bucket_full)
        {
            uint head = _1081.in_faces_list_tails_data[icell_idx];
            uint cnt = in_faces_list_data.node_buffer[head];
            state.face_tests += int(cnt);
        }
        while (bucket_full_mask != 0ul)
        {
            int bucket_full_first_idx = findLSB(uint(bucket_full_mask));
            if (bucket_full_first_idx == (-1))
            {
                bucket_full_first_idx = 32 + findLSB(uint(bucket_full_mask >> 32));
            }
            int _closest_fi = -1;
            uint iterator_idx = subgroupBallotExclusiveBitCount(active_ballot);
            uint iterator_cnt = subgroupBallotBitCount(active_ballot);
            uint param_27 = subgroupShuffle(icell_idx, uint(bucket_full_first_idx));
            uint param_28 = iterator_idx;
            uint param_29 = iterator_cnt;
            vec3 param_30 = subgroupShuffle(state.origin, uint(bucket_full_first_idx));
            vec3 param_31 = subgroupShuffle(state.dir, uint(bucket_full_first_idx));
            int param_32 = subgroupShuffle(skip_fi, uint(bucket_full_first_idx));
            float param_33 = min(tmax, subgroupShuffle(rt_1, uint(bucket_full_first_idx)));
            findClosestBucket2_Multi(param_27, param_28, param_29, param_30, param_31, param_32, param_33, param_34, param_35, param_36, param_37, param_38);
            _closest_fi = param_34;
            uint _closest_material_flags = param_35;
            float _closest_it = param_36;
            vec3 _closest_normal = param_37;
            vec2 _closest_bc = param_38;
            SPIRV_CROSS_BRANCH
            if (subgroupMax(_closest_fi) > (-1))
            {
                shared_hit_lane_idx = -1;
                SPIRV_CROSS_BRANCH
                if (_closest_it == subgroupMin(_closest_it))
                {
                    shared_hit_lane_idx = int(gl_SubgroupInvocationID);
                    shared_closest_fi = _closest_fi;
                }
                memoryBarrierShared();
                SPIRV_CROSS_BRANCH
                if (uint(bucket_full_first_idx) == gl_SubgroupInvocationID)
                {
                    closest_fi = shared_closest_fi;
                    if (closest_fi != (-1))
                    {
                        uint param_39 = uint(closest_fi);
                        RTFace rt_face = rt_get_face(param_39);
                        uint param_40 = rt_face.v0;
                        vec3 p0 = rt_get_vertex(param_40);
                        uint param_41 = rt_face.v1;
                        vec3 p1 = rt_get_vertex(param_41);
                        uint param_42 = rt_face.v2;
                        vec3 p2 = rt_get_vertex(param_42);
                        vec3 param_43 = state.origin;
                        vec3 param_44 = state.dir;
                        vec3 param_45 = p2;
                        vec3 param_46 = p1;
                        vec3 param_47 = p0;
                        intersection it1 = intersectTriangle3(param_43, param_44, param_45, param_46, param_47);
                        closest_normal = it1.normal;
                        vec2 closest_bc = it1.bc;
                        closest_material_flags = rt_face.material_flags;
                    }
                    set_from_lane = shared_hit_lane_idx;
                    uint param_48 = state.flags;
                    uint param_49 = 128u;
                    if (rt_is_mask_set(param_48, param_49))
                    {
                        debugPrintfEXT("  [%04d] Running:%d closest_it:%f for thread:%d, hit_lane:%d = %f material_flags:%d, subgroupID:%d closest_fi:%d\n", max_iter, is_running_num, closest_it, bucket_full_first_idx, shared_hit_lane_idx, subgroupShuffle(_closest_it, uint(shared_hit_lane_idx)), closest_material_flags, gl_SubgroupInvocationID, closest_fi);
                        for (int ii = 0; ii < 64; ii++)
                        {
                            uint head_1 = _1081.in_faces_list_tails_data[subgroupShuffle(icell_idx, uint(ii))];
                            debugPrintfEXT("  ++ %f faces_in_bucket:%d, iterator_idx:%d, iterator_stride:%d\n", subgroupShuffle(_closest_it, uint(ii)), in_faces_list_data.node_buffer[head_1], subgroupShuffle(iterator_idx, uint(ii)), subgroupShuffle(iterator_cnt, uint(ii)));
                        }
                    }
                }
            }
            bucket_full_mask -= uint64_t(1l << bucket_full_first_idx);
        }
        bool _1865 = closest_fi != prev_closest_fi;
        bool _1873;
        if (_1865)
        {
            uint param_50 = state.flags;
            uint param_51 = 32u;
            _1873 = rt_is_mask_set(param_50, param_51);
        }
        else
        {
            _1873 = _1865;
        }
        if (_1873)
        {
            uint param_52 = state.flags;
            uint param_53 = 128u;
            if (rt_is_mask_set(param_52, param_53))
            {
                debugPrintfEXT("  FI:%d OLD:%d LANE:%d, gl_SubgroupInvocationID:%d\n", closest_fi, prev_closest_fi, set_from_lane, gl_SubgroupInvocationID);
            }
        }
        bool _1890 = closest_fi != (-1);
        bool _1898;
        if (_1890)
        {
            uint param_54 = state.flags;
            uint param_55 = 32u;
            _1898 = rt_is_mask_set(param_54, param_55);
        }
        else
        {
            _1898 = _1890;
        }
        if (_1898)
        {
            state.bounces += 1s;
            state.normal = closest_normal;
            hit = true;
            skip_fi = closest_fi;
            bool _1915 = int(state.bounces) >= max_bounces;
            bool _1923;
            if (!_1915)
            {
                _1923 = (closest_material_flags & 2048u) != 0u;
            }
            else
            {
                _1923 = _1915;
            }
            if (_1923)
            {
                uint param_56 = state.flags;
                uint param_57 = 32u;
                uint _1930 = rt_clear_mask(param_56, param_57);
                state.flags = _1930;
                uint param_58 = state.flags;
                uint param_59 = 128u;
                if (rt_is_mask_set(param_58, param_59))
                {
                    debugPrintfEXT("  Terminate:%02d subgroup size:%d, %f, %f, %f, FI:%d\n", gl_SubgroupInvocationID, gl_SubgroupSize, closest_normal.x, closest_normal.y, closest_normal.z, closest_fi);
                }
            }
            int param_60 = closest_fi;
            vec3 param_61 = state.origin + (state.dir * closest_it);
            vec2 bc = barycentric_for_face_yz(param_60, param_61);
            if ((closest_material_flags & 128u) == 0u)
            {
                int param_62 = closest_fi;
                vec2 param_63 = bc;
                vec3 param_64 = state.normal;
                state.normal = interpolate_normal_from_bc_yz(param_62, param_63, param_64);
            }
            bool flip_normal_on_glass = false;
            if ((closest_material_flags & 32u) != 0u)
            {
                flip_normal_on_glass = (dot(state.normal, state.dir) > 0.0) ? true : false;
            }
            vec3 prev_state_origin = state.origin;
            state.origin += (state.dir * closest_it);
            uint param_65 = state.flags;
            uint param_66 = 128u;
            if (rt_is_mask_set(param_65, param_66))
            {
                debugPrintfEXT("  %f, %f %f, %f\n", state.origin.x, state.origin.y, state.origin.z, closest_it);
            }
            ray_state param_67 = state;
            vec3 param_68 = prev_state_origin;
            int param_69 = closest_fi;
            uint param_70 = closest_material_flags;
            vec2 param_71 = bc;
            bool param_72 = flip_normal_on_glass;
            evaluate_material(param_67, param_68, param_69, param_70, param_71, param_72);
            state = param_67;
        }
        if (false)
        {
            if (bucket_full)
            {
                uint icell_idx_1 = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
                bool param_73 = true;
                state.active_threads_factor += ballot_count(param_73);
                state.active_threads_samples++;
                int face_tests = 0;
                uint max_tests = 4294967295u;
                float rt_2 = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
                ray_state_user_data param_74 = state.user_data;
                uint param_75 = icell_idx_1;
                bool param_76 = bucket_full;
                uint param_77 = max_tests;
                vec3 param_78 = state.origin;
                vec3 param_79 = state.dir;
                int param_80 = skip_fi;
                float param_81 = min(tmax, rt_2);
                findClosestBucket2(param_74, param_75, param_76, param_77, param_78, param_79, param_80, param_81, param_82, param_83, param_84, param_85, param_86, param_87);
                state.user_data = param_74;
                closest_fi = param_82;
                uint closest_material_flags_1 = param_83;
                closest_it = param_84;
                vec3 closest_normal_1 = param_85;
                vec2 closest_bc_1 = param_86;
                face_tests = param_87;
                state.face_tests += face_tests;
                bool param_88 = true;
                uint hit_threads = ballot_count(param_88);
                uint param_89 = state.flags;
                uint param_90 = 128u;
                if (rt_is_mask_set(param_89, param_90))
                {
                    debugPrintfEXT("  Tests:%d (%d) at %d hit_threads:%d active_threads:%d (running:%d)\n", face_tests, state.face_tests, state.tests, hit_threads, is_active_num, is_running_num);
                }
                if (closest_fi != (-1))
                {
                    state.bounces += 1s;
                    state.normal = closest_normal_1;
                    hit = true;
                    skip_fi = closest_fi;
                    bool _2152 = int(state.bounces) >= max_bounces;
                    bool _2159;
                    if (!_2152)
                    {
                        _2159 = (closest_material_flags_1 & 2048u) != 0u;
                    }
                    else
                    {
                        _2159 = _2152;
                    }
                    if (_2159)
                    {
                        uint param_91 = state.flags;
                        uint param_92 = 32u;
                        uint _2166 = rt_clear_mask(param_91, param_92);
                        state.flags = _2166;
                    }
                    int param_93 = closest_fi;
                    vec3 param_94 = state.origin + (state.dir * closest_it);
                    vec2 bc_1 = barycentric_for_face_yz(param_93, param_94);
                    if ((closest_material_flags_1 & 128u) == 0u)
                    {
                        int param_95 = closest_fi;
                        vec2 param_96 = bc_1;
                        vec3 param_97 = state.normal;
                        state.normal = interpolate_normal_from_bc_yz(param_95, param_96, param_97);
                    }
                    bool flip_normal_on_glass_1 = false;
                    if ((closest_material_flags_1 & 32u) != 0u)
                    {
                        flip_normal_on_glass_1 = (dot(state.normal, state.dir) > 0.0) ? true : false;
                    }
                    vec3 prev_state_origin_1 = state.origin;
                    state.origin += (state.dir * closest_it);
                    ray_state param_98 = state;
                    vec3 param_99 = prev_state_origin_1;
                    int param_100 = closest_fi;
                    uint param_101 = closest_material_flags_1;
                    vec2 param_102 = bc_1;
                    bool param_103 = flip_normal_on_glass_1;
                    evaluate_material(param_98, param_99, param_100, param_101, param_102, param_103);
                    state = param_98;
                }
            }
        }
        uint param_104 = state.flags;
        uint param_105 = 32u;
        if (rt_is_mask_set(param_104, param_105))
        {
            uint param_106 = traversal_flags;
            uint param_107 = 1u;
            bool _2243 = rt_is_mask_set(param_106, param_107) == false;
            bool _2251;
            if (_2243)
            {
                uint param_108 = traversal_flags;
                uint param_109 = 2u;
                _2251 = rt_is_mask_set(param_108, param_109) == true;
            }
            else
            {
                _2251 = _2243;
            }
            if (_2251)
            {
                uint param_110 = state.flags;
                uint param_111 = 32u;
                uint _2258 = rt_clear_mask(param_110, param_111);
                state.flags = _2258;
                uint param_112 = state.flags;
                uint param_113 = 64u;
                uint _2264 = rt_set_mask(param_112, param_113);
                state.flags = _2264;
                uint param_114 = state.flags;
                uint param_115 = 8u;
                uint _2271 = rt_set_mask(param_114, param_115);
                state.flags = _2271;
            }
            if (!hit)
            {
                vec3 mm = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
                vec3 param_116 = state.dir;
                vec3 param_117 = mm;
                icell += dda_step_from_dir(param_116, param_117);
                nextCrossingT += (mm * deltaT);
            }
        }
        bool _2306;
        if (false)
        {
            _2306 = state.face_tests >= 128;
        }
        else
        {
            _2306 = false;
        }
        if (_2306)
        {
            uint param_118 = state.flags;
            uint param_119 = 32u;
            uint _2313 = rt_clear_mask(param_118, param_119);
            state.flags = _2313;
            uint param_120 = state.flags;
            uint param_121 = 64u;
            uint _2319 = rt_set_mask(param_120, param_121);
            state.flags = _2319;
            uint param_122 = state.flags;
            uint param_123 = 8u;
            uint _2325 = rt_set_mask(param_122, param_123);
            state.flags = _2325;
        }
        if (false)
        {
            bool _2335;
            if (true)
            {
                _2335 = state.face_tests >= 8192;
            }
            else
            {
                _2335 = true;
            }
            if (_2335)
            {
                uint param_124 = state.flags;
                uint param_125 = 32u;
                bool is_running_1 = rt_is_mask_set(param_124, param_125);
                bool param_126 = is_running_1;
                if (ballot_count(param_126) <= 4u)
                {
                    break;
                }
            }
        }
        uint param_127 = state.flags;
        uint param_128 = 32u;
        bool is_running_2 = rt_is_mask_set(param_127, param_128);
        bool param_129 = is_running_2;
        if (ballot_count(param_129) == 0u)
        {
            break;
        }
        continue;
    }
    return 0;
}

vec3 TurboColormap(inout float x)
{
    x = clamp(x, 0.0, 1.0);
    vec4 v4 = vec4(1.0, x, x * x, (x * x) * x);
    vec2 v2 = v4.zw * v4.z;
    return vec3(dot(v4, vec4(0.135721385478973388671875, 4.6153926849365234375, -42.6603240966796875, 132.1310882568359375)) + dot(v2, vec2(-152.9423980712890625, 59.286380767822265625)), dot(v4, vec4(0.091402612626552581787109375, 2.1941883563995361328125, 4.842966556549072265625, -14.1850337982177734375)) + dot(v2, vec2(4.277298450469970703125, 2.82956600189208984375)), dot(v4, vec4(0.106673300266265869140625, 12.64194583892822265625, -60.5820465087890625, 110.36277008056640625)) + dot(v2, vec2(-89.903106689453125, 27.3482494354248046875)));
}

void main()
{
    g_buff_grid_markers_ptr = 0ul;
    uint param = 4294967295u;
    vec4 outHitDirectionPrimitiveID = vec4(0.0, 0.0, 0.0, asfloat(param));
    vec4 outDebug = vec4(0.0);
    g_buff_grid_markers_ptr = _2509.rt_setup.buff_grid_markers_ptr;
    uvec2 group_id = gl_WorkGroupID.xy;
    uvec2 group_id_mask_for_tile = uvec2(7u, 15u);
    uint groups_per_tile = 128u;
    uvec2 tile_id = group_id / uvec2(8u, 16u);
    uint group_in_tile_idx = ((group_id.x & group_id_mask_for_tile.x) * 16u) + (group_id.y & group_id_mask_for_tile.y);
    uint dispatch_in_tile_idx = (group_in_tile_idx * 32u) + gl_LocalInvocationIndex;
    uint tile_idx = (tile_id.y * 30u) + tile_id.x;
    uint tile_buff_base = tile_idx * 4097u;
    uint dispatches_num = _2732.dispatch_elements[tile_buff_base];
    bool is_discarded = false;
    if (dispatch_in_tile_idx >= dispatches_num)
    {
        is_discarded = true;
        dispatch_in_tile_idx = group_in_tile_idx * 32u;
    }
    uint dispatch = _2732.dispatch_elements[(tile_buff_base + 1u) + dispatch_in_tile_idx];
    uint param_1 = dispatch;
    uvec2 dispatch_xy = dispatch_get_xy(param_1);
    uint param_2 = dispatch;
    ivec2 native_sample_pos = ivec2(dispatch_xy) + dispatch_get_subsample_offset(param_2);
    uint _px = dispatch_in_tile_idx & 15u;
    uint _py = dispatch_in_tile_idx / 16u;
    DispatchDeferredParams _2775;
    _2775.mat_projection = _2370.dispatch_setup.mat_projection;
    _2775.mat_projection_previous = _2370.dispatch_setup.mat_projection_previous;
    _2775.mat_model = _2370.dispatch_setup.mat_model;
    _2775.mat_model_previous = _2370.dispatch_setup.mat_model_previous;
    _2775.mat_view_inverse = _2370.dispatch_setup.mat_view_inverse;
    _2775.mat_view_previous = _2370.dispatch_setup.mat_view_previous;
    _2775.camera_position = _2370.dispatch_setup.camera_position;
    _2775.camera_projection_params = _2370.dispatch_setup.camera_projection_params;
    _2775.camera_projection_params_previous = _2370.dispatch_setup.camera_projection_params_previous;
    _2775.near_far_plane = _2370.dispatch_setup.near_far_plane;
    _2775.resolution = _2370.dispatch_setup.resolution;
    _2775.inv_resolution = _2370.dispatch_setup.inv_resolution;
    _2775.frustum_shift = _2370.dispatch_setup.frustum_shift;
    DispatchDeferredParams param_3 = _2775;
    vec2 param_4 = vec2(native_sample_pos);
    vec3 view_direction = deferred_get_view_direction_from_screen_pos(param_3, param_4);
    vec3 origin = _2370.dispatch_setup.camera_position;
    int closest_fi = -1;
    uvec4 param_5 = imageLoad(imMetalnessRoughnessMaterialTags, native_sample_pos);
    MetalnessRoughnessMeterialTags mrmt = decode_metalness_roughness_material_tags(param_5);
    int16_t material = int16_t(uint16_t(mrmt.material_index));
    float param_6 = texelFetch(sTextureDepth, native_sample_pos, 0).x;
    float depth = linearizeDepth(param_6);
    vec3 param_7 = view_direction;
    float param_8 = depth;
    vec3 view_coords = positionFromDepth(param_7, param_8);
    vec3 dir = -normalize(origin - view_coords);
    float closest_it = length(origin - view_coords);
    uint encoded_normal_material = imageLoad(imNormalMaterial, native_sample_pos).x;
    uint param_9 = encoded_normal_material;
    vec3 _2839 = decode_normal(param_9);
    vec3 normal = normalize(_2839);
    vec3 worldNorm = normal;
    vec3 ro = (origin + (dir * closest_it)) - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro * in_bbox_data.grid_size_raytrace_recip.xyz));
    bool _2863 = icell.x >= 0;
    bool _2869;
    if (_2863)
    {
        _2869 = icell.y >= 0;
    }
    else
    {
        _2869 = _2863;
    }
    bool _2875;
    if (_2869)
    {
        _2875 = icell.z >= 0;
    }
    else
    {
        _2875 = _2869;
    }
    bool _2881;
    if (_2875)
    {
        _2881 = icell.x < 256;
    }
    else
    {
        _2881 = _2875;
    }
    bool _2887;
    if (_2881)
    {
        _2887 = icell.y < 256;
    }
    else
    {
        _2887 = _2881;
    }
    bool _2893;
    if (_2887)
    {
        _2893 = icell.z < 256;
    }
    else
    {
        _2893 = _2887;
    }
    if (_2893)
    {
        uint icell_idx = uint(((icell.z * 65536) + (icell.y * 256)) + icell.x);
    }
    uint64_t _2910 = clockRealtimeEXT();
    uint64_t clock_start = _2910;
    origin += (dir * closest_it);
    ray_traversal_params traversal_params;
    traversal_params.trace_range_primary = _2509.rt_setup.trace_range_primary;
    traversal_params.trace_range_secondary = _2509.rt_setup.trace_range_secondary;
    ray_state state;
    state.normal = normal;
    state.material = material;
    state.dir = dir;
    state.origin = origin;
    state.bounces = 1s;
    state.tests = 0;
    state.face_tests = 0;
    state.active_threads_factor = 0u;
    state.active_threads_samples = 0u;
    state.final_color_factor = 1.0;
    state.flags = 0u;
    uint param_10 = state.flags;
    uint param_11 = 32u;
    uint _2943 = rt_set_mask(param_10, param_11);
    state.flags = _2943;
    bool _2948 = native_sample_pos.x == 547;
    bool _2955;
    if (_2948)
    {
        _2955 = native_sample_pos.y == 649;
    }
    else
    {
        _2955 = _2948;
    }
    if (_2955)
    {
        uint param_12 = state.flags;
        uint param_13 = 128u;
        uint _2962 = rt_set_mask(param_12, param_13);
        state.flags = _2962;
    }
    bool pre_step_along_ray = false;
    bool pre_step_along_normal = !pre_step_along_ray;
    if (pre_step_along_normal)
    {
        if (_2509.rt_setup.reflect_rays != 0)
        {
            state.origin += (vec3(normal) * _2509.rt_setup.initial_face_start_distance);
        }
        else
        {
            state.origin += (vec3(-normal) * _2509.rt_setup.initial_face_start_distance);
        }
    }
    if (_2509.rt_setup.reflect_rays != 0)
    {
        state.dir = reflect(state.dir, vec3(state.normal));
        ivec2 param_14 = ivec2(native_sample_pos);
        vec3 param_15 = state.dir;
        vec3 param_16 = state.normal;
        float param_17 = mrmt.roughness;
        float param_18;
        vec3 _3034 = rt_randomize_dir_for_roughness(param_14, param_15, param_16, param_17, param_18);
        state.final_color_factor = param_18;
        state.dir = _3034;
        if (state.final_color_factor <= 0.0)
        {
            return;
        }
    }
    else
    {
        vec3 param_19 = state.dir;
        vec3 param_20 = -state.normal;
        state.dir = glass_refract(param_19, param_20);
        uint param_21 = state.flags;
        uint param_22 = 16u;
        uint _3058 = rt_set_mask(param_21, param_22);
        state.flags = _3058;
    }
    dir = state.dir;
    if (pre_step_along_ray)
    {
        state.origin += (state.dir * _2509.rt_setup.initial_face_start_distance);
    }
    if (is_discarded)
    {
        uint param_23 = state.flags;
        uint param_24 = 32u;
        uint _3081 = rt_clear_mask(param_23, param_24);
        state.flags = _3081;
    }
    ray_traversal_params param_25 = traversal_params;
    ray_state param_26 = state;
    int param_27 = closest_fi;
    int param_30 = 1;
    float param_31 = traversal_params.trace_range_primary;
    int param_28;
    float param_29;
    int _3095 = findClosestDDAMultibounce_New(param_25, param_26, param_27, param_28, param_29, param_30, param_31);
    state = param_26;
    closest_fi = param_28;
    closest_it = param_29;
    outDebug.x = 0.0;
    outDebug.y = 0.0;
    outDebug.z = 0.0;
    if (state.face_tests > 0)
    {
    }
    uint hitPrimitiveId = 4294967295u;
    outDebug.x = 0.0;
    outDebug.y = 0.0;
    outDebug.z = 0.0;
    uint param_32 = state.flags;
    uint param_33 = 4u;
    if (rt_is_mask_set(param_32, param_33))
    {
        hitPrimitiveId = state.user_data.primitiveId;
        float param_34 = fract(float(state.user_data.primitiveId) / 512.0);
        vec3 _3133 = TurboColormap(param_34);
        outDebug.x = _3133.x;
        outDebug.y = _3133.y;
        outDebug.z = _3133.z;
    }
    if (false)
    {
        uint64_t _3143 = clockRealtimeEXT();
        uint64_t clock_end = _3143;
        uint64_t clock_diff = clock_end - clock_start;
        float c = float(clock_diff / 1000ul);
        float param_35 = c / 512.0;
        vec3 _3156 = TurboColormap(param_35);
        outDebug.x = _3156.x;
        outDebug.y = _3156.y;
        outDebug.z = _3156.z;
    }
    if (is_discarded == false)
    {
        uint param_36 = dispatch;
        if ((dispatch_get_mask(param_36) & 1u) != 0u)
        {
            uint param_37 = dispatch;
            imageStore(imOutDebug, ivec2(dispatch_get_xy(param_37)) + ivec2(0), outDebug);
        }
        uint param_38 = dispatch;
        if ((dispatch_get_mask(param_38) & 2u) != 0u)
        {
            uint param_39 = dispatch;
            imageStore(imOutDebug, ivec2(dispatch_get_xy(param_39)) + ivec2(1, 0), outDebug);
        }
        uint param_40 = dispatch;
        if ((dispatch_get_mask(param_40) & 4u) != 0u)
        {
            uint param_41 = dispatch;
            imageStore(imOutDebug, ivec2(dispatch_get_xy(param_41)) + ivec2(0, 1), outDebug);
        }
        uint param_42 = dispatch;
        if ((dispatch_get_mask(param_42) & 8u) != 0u)
        {
            uint param_43 = dispatch;
            imageStore(imOutDebug, ivec2(dispatch_get_xy(param_43)) + ivec2(1), outDebug);
        }
    }
    uint param_44 = hitPrimitiveId;
    outHitDirectionPrimitiveID = vec4(state.dir, asfloat(param_44));
    if (is_discarded == false)
    {
        uint param_45 = dispatch;
        if ((dispatch_get_mask(param_45) & 1u) != 0u)
        {
            uint param_46 = dispatch;
            imageStore(imOutHitDirectionPrimitiveID, ivec2(dispatch_get_xy(param_46)) + ivec2(0), outHitDirectionPrimitiveID);
        }
        uint param_47 = dispatch;
        if ((dispatch_get_mask(param_47) & 2u) != 0u)
        {
            uint param_48 = dispatch;
            imageStore(imOutHitDirectionPrimitiveID, ivec2(dispatch_get_xy(param_48)) + ivec2(1, 0), outHitDirectionPrimitiveID);
        }
        uint param_49 = dispatch;
        if ((dispatch_get_mask(param_49) & 4u) != 0u)
        {
            uint param_50 = dispatch;
            imageStore(imOutHitDirectionPrimitiveID, ivec2(dispatch_get_xy(param_50)) + ivec2(0, 1), outHitDirectionPrimitiveID);
        }
        uint param_51 = dispatch;
        if ((dispatch_get_mask(param_51) & 8u) != 0u)
        {
            uint param_52 = dispatch;
            imageStore(imOutHitDirectionPrimitiveID, ivec2(dispatch_get_xy(param_52)) + ivec2(1), outHitDirectionPrimitiveID);
        }
    }
}

 