#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GPUHashMapLookupResult
{
    uint slot;
    bool found;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometrySubdivideParams
{
    uint max_faces_num;
    uint surfaces_num;
    uint surface_idx;
    uint attribute_mask;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer EdgeHashMapKeysBuffer
{
    GPUHashMapHeader header;
    uint64_t keys[];
} edge_hashmap;

layout(set = 0, binding = 2, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _158;

layout(set = 0, binding = 3, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 4, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 5, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 12, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _248;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 13, std140) uniform GeometrySubdivideParamsBuffer
{
    GeometrySubdivideParams geometry_subdivide_params;
} _368;

layout(set = 0, binding = 11, std430) buffer EdgeHashMapValuesBuffer
{
    uint values[];
} edge_hashmap_values;

uint get_idx(inout uint idx)
{
    idx += _248.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

vec3 get_coords(inout uint idx)
{
    idx *= _248.input_geometry_information.attributes[0].stride;
    idx += _248.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _158.output_geometry_information.attributes[0].stride;
    idx += _158.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

uint64_t build_edge_key(uint a, uint b)
{
    if (a < b)
    {
        return (uint64_t(a) << 32) | uint64_t(b);
    }
    else
    {
        return (uint64_t(b) << 32) | uint64_t(a);
    }
}

uint64_t GPUHashMapHash64(inout uint64_t h)
{
    h ^= (h >> 33);
    h *= 18397679294719823053ul;
    h ^= (h >> 33);
    h *= 14181476777654086739ul;
    h ^= (h >> 33);
    return h;
}

GPUHashMapLookupResult edge_hashmap_lookup(uint64_t key)
{
    GPUHashMapLookupResult res;
    res.slot = 0u;
    res.found = false;
    uint64_t param = key;
    uint64_t _98 = GPUHashMapHash64(param);
    uint64_t hash = _98;
    uint slot = uint(hash & uint64_t(edge_hashmap.header.capacity - 1u));
    while (true)
    {
        uint64_t map_key = edge_hashmap.keys[slot];
        if (map_key == 18446744073709551615ul)
        {
            break;
        }
        if (map_key == key)
        {
            res.slot = slot;
            res.found = true;
            return res;
        }
        slot = (slot + 1u) & (edge_hashmap.header.capacity - 1u);
    }
    return res;
}

vec3 get_normal(inout uint idx)
{
    idx *= _248.input_geometry_information.attributes[1].stride;
    idx += _248.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _158.output_geometry_information.attributes[1].stride;
    idx += _158.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

uint get_custom0(inout uint idx)
{
    idx *= _248.input_geometry_information.attributes[6].stride;
    idx += _248.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _158.output_geometry_information.attributes[6].stride;
    idx += _158.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

void put_idx(inout uint idx, uint v)
{
    idx += _158.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = _368.geometry_subdivide_params.surface_idx;
    uint src_faces_num = _248.input_geometry_information.faces_num_per_surface[surface_idx];
    uint ie;
    uint ni0;
    uint ni1;
    uint ni2;
    uint ni3;
    uint ie0;
    uint ie1;
    uint ni0_1;
    uint ni1_1;
    uint ni2_1;
    uint ni3_1;
    uint ni4;
    for (uint src_face_idx = thread_idx; src_face_idx < src_faces_num; src_face_idx += 131072u)
    {
        uint param = (src_face_idx * 3u) + 0u;
        uint _393 = get_idx(param);
        uint i0 = _393;
        uint param_1 = (src_face_idx * 3u) + 1u;
        uint _399 = get_idx(param_1);
        uint i1 = _399;
        uint param_2 = (src_face_idx * 3u) + 2u;
        uint _405 = get_idx(param_2);
        uint i2 = _405;
        uint param_3 = i0;
        vec3 _409 = get_coords(param_3);
        vec3 v0_coords = _409;
        uint param_4 = i1;
        vec3 _413 = get_coords(param_4);
        vec3 v1_coords = _413;
        uint param_5 = i2;
        vec3 _417 = get_coords(param_5);
        vec3 v2_coords = _417;
        uint param_6 = i0;
        vec3 param_7 = v0_coords;
        put_coords(param_6, param_7);
        uint param_8 = i1;
        vec3 param_9 = v1_coords;
        put_coords(param_8, param_9);
        uint param_10 = i2;
        vec3 param_11 = v2_coords;
        put_coords(param_10, param_11);
        uint param_12 = i0;
        uint param_13 = i1;
        uint64_t edge0 = build_edge_key(param_12, param_13);
        uint param_14 = i1;
        uint param_15 = i2;
        uint64_t edge1 = build_edge_key(param_14, param_15);
        uint param_16 = i2;
        uint param_17 = i0;
        uint64_t edge2 = build_edge_key(param_16, param_17);
        uint64_t param_18 = edge0;
        GPUHashMapLookupResult ires0 = edge_hashmap_lookup(param_18);
        uint64_t param_19 = edge1;
        GPUHashMapLookupResult ires1 = edge_hashmap_lookup(param_19);
        uint64_t param_20 = edge2;
        GPUHashMapLookupResult ires2 = edge_hashmap_lookup(param_20);
        uint added_faces = 1u;
        added_faces += uint(int(ires0.found));
        added_faces += uint(int(ires1.found));
        added_faces += uint(int(ires2.found));
        if (added_faces > 1u)
        {
            uint max_ie = _248.input_geometry_information.vtx_num;
            if (added_faces == 2u)
            {
                if (ires0.found)
                {
                    ie = edge_hashmap_values.values[ires0.slot];
                }
                else
                {
                    if (ires1.found)
                    {
                        ie = edge_hashmap_values.values[ires1.slot];
                    }
                    else
                    {
                        ie = edge_hashmap_values.values[ires2.slot];
                    }
                }
                ie += _248.input_geometry_information.vtx_num;
                if (ires0.found)
                {
                    uint param_21 = ie;
                    vec3 param_22 = (v0_coords + v1_coords) * 0.5;
                    put_coords(param_21, param_22);
                }
                else
                {
                    if (ires1.found)
                    {
                        uint param_23 = ie;
                        vec3 param_24 = (v1_coords + v2_coords) * 0.5;
                        put_coords(param_23, param_24);
                    }
                    else
                    {
                        uint param_25 = ie;
                        vec3 param_26 = (v2_coords + v0_coords) * 0.5;
                        put_coords(param_25, param_26);
                    }
                }
                if ((_158.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                {
                    uint param_27 = i0;
                    vec3 _568 = get_normal(param_27);
                    vec3 v0_normal = _568;
                    uint param_28 = i1;
                    vec3 _572 = get_normal(param_28);
                    vec3 v1_normal = _572;
                    uint param_29 = i2;
                    vec3 _576 = get_normal(param_29);
                    vec3 v2_normal = _576;
                    uint param_30 = i0;
                    vec3 param_31 = v0_normal;
                    put_normal(param_30, param_31);
                    uint param_32 = i1;
                    vec3 param_33 = v1_normal;
                    put_normal(param_32, param_33);
                    uint param_34 = i2;
                    vec3 param_35 = v2_normal;
                    put_normal(param_34, param_35);
                    if (ires0.found)
                    {
                        uint param_36 = ie;
                        vec3 param_37 = normalize((v0_normal + v1_normal) * 0.5);
                        put_normal(param_36, param_37);
                    }
                    else
                    {
                        if (ires1.found)
                        {
                            uint param_38 = ie;
                            vec3 param_39 = normalize((v1_normal + v2_normal) * 0.5);
                            put_normal(param_38, param_39);
                        }
                        else
                        {
                            uint param_40 = ie;
                            vec3 param_41 = normalize((v2_normal + v0_normal) * 0.5);
                            put_normal(param_40, param_41);
                        }
                    }
                }
                if ((_158.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                {
                    uint param_42 = i0;
                    uint _638 = get_custom0(param_42);
                    uint v0_custom0 = _638;
                    uint param_43 = i1;
                    uint _642 = get_custom0(param_43);
                    uint v1_custom0 = _642;
                    uint param_44 = i2;
                    uint _646 = get_custom0(param_44);
                    uint v2_custom0 = _646;
                    uint param_45 = i0;
                    uint param_46 = v0_custom0;
                    put_custom0(param_45, param_46);
                    uint param_47 = i1;
                    uint param_48 = v1_custom0;
                    put_custom0(param_47, param_48);
                    uint param_49 = i2;
                    uint param_50 = v2_custom0;
                    put_custom0(param_49, param_50);
                    if (ires0.found)
                    {
                        uint param_51 = ie;
                        uint param_52 = v0_custom0;
                        put_custom0(param_51, param_52);
                    }
                    else
                    {
                        if (ires1.found)
                        {
                            uint param_53 = ie;
                            uint param_54 = v1_custom0;
                            put_custom0(param_53, param_54);
                        }
                        else
                        {
                            uint param_55 = ie;
                            uint param_56 = v2_custom0;
                            put_custom0(param_55, param_56);
                        }
                    }
                }
                uint _690 = atomicAdd(_158.output_geometry_information.faces_num_per_surface[surface_idx], 2u);
                uint dst_face_idx = _690;
                if (ires0.found)
                {
                    ni0 = i2;
                    ni1 = i0;
                    ni2 = ie;
                    ni3 = i1;
                }
                else
                {
                    if (ires1.found)
                    {
                        ni0 = i0;
                        ni1 = i1;
                        ni2 = ie;
                        ni3 = i2;
                    }
                    else
                    {
                        ni0 = i1;
                        ni1 = i2;
                        ni2 = ie;
                        ni3 = i0;
                    }
                }
                uint param_57 = (dst_face_idx * 3u) + 0u;
                uint param_58 = ni0;
                put_idx(param_57, param_58);
                uint param_59 = (dst_face_idx * 3u) + 1u;
                uint param_60 = ni1;
                put_idx(param_59, param_60);
                uint param_61 = (dst_face_idx * 3u) + 2u;
                uint param_62 = ni2;
                put_idx(param_61, param_62);
                dst_face_idx++;
                uint param_63 = (dst_face_idx * 3u) + 0u;
                uint param_64 = ni0;
                put_idx(param_63, param_64);
                uint param_65 = (dst_face_idx * 3u) + 1u;
                uint param_66 = ni2;
                put_idx(param_65, param_66);
                uint param_67 = (dst_face_idx * 3u) + 2u;
                uint param_68 = ni3;
                put_idx(param_67, param_68);
                max_ie = max(max_ie, (ie + 1u));
            }
            else
            {
                if (added_faces == 3u)
                {
                    if (ires0.found == false)
                    {
                        ie0 = edge_hashmap_values.values[ires1.slot];
                        ie1 = edge_hashmap_values.values[ires2.slot];
                    }
                    if (ires1.found == false)
                    {
                        ie0 = edge_hashmap_values.values[ires0.slot];
                        ie1 = edge_hashmap_values.values[ires2.slot];
                    }
                    if (ires2.found == false)
                    {
                        ie0 = edge_hashmap_values.values[ires0.slot];
                        ie1 = edge_hashmap_values.values[ires1.slot];
                    }
                    ie0 += _248.input_geometry_information.vtx_num;
                    ie1 += _248.input_geometry_information.vtx_num;
                    if (ires0.found == false)
                    {
                        uint param_69 = ie0;
                        vec3 param_70 = (v1_coords + v2_coords) * 0.5;
                        put_coords(param_69, param_70);
                        uint param_71 = ie1;
                        vec3 param_72 = (v2_coords + v0_coords) * 0.5;
                        put_coords(param_71, param_72);
                    }
                    if (ires1.found == false)
                    {
                        uint param_73 = ie0;
                        vec3 param_74 = (v0_coords + v1_coords) * 0.5;
                        put_coords(param_73, param_74);
                        uint param_75 = ie1;
                        vec3 param_76 = (v2_coords + v0_coords) * 0.5;
                        put_coords(param_75, param_76);
                    }
                    if (ires2.found == false)
                    {
                        uint param_77 = ie0;
                        vec3 param_78 = (v0_coords + v1_coords) * 0.5;
                        put_coords(param_77, param_78);
                        uint param_79 = ie1;
                        vec3 param_80 = (v1_coords + v2_coords) * 0.5;
                        put_coords(param_79, param_80);
                    }
                    if ((_158.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_81 = i0;
                        vec3 _891 = get_normal(param_81);
                        vec3 v0_normal_1 = _891;
                        uint param_82 = i1;
                        vec3 _895 = get_normal(param_82);
                        vec3 v1_normal_1 = _895;
                        uint param_83 = i2;
                        vec3 _899 = get_normal(param_83);
                        vec3 v2_normal_1 = _899;
                        uint param_84 = i0;
                        vec3 param_85 = v0_normal_1;
                        put_normal(param_84, param_85);
                        uint param_86 = i1;
                        vec3 param_87 = v1_normal_1;
                        put_normal(param_86, param_87);
                        uint param_88 = i2;
                        vec3 param_89 = v2_normal_1;
                        put_normal(param_88, param_89);
                        if (ires0.found == false)
                        {
                            uint param_90 = ie0;
                            vec3 param_91 = normalize((v1_normal_1 + v2_normal_1) * 0.5);
                            put_normal(param_90, param_91);
                            uint param_92 = ie1;
                            vec3 param_93 = normalize((v2_normal_1 + v0_normal_1) * 0.5);
                            put_normal(param_92, param_93);
                        }
                        if (ires1.found == false)
                        {
                            uint param_94 = ie0;
                            vec3 param_95 = normalize((v0_normal_1 + v1_normal_1) * 0.5);
                            put_normal(param_94, param_95);
                            uint param_96 = ie1;
                            vec3 param_97 = normalize((v2_normal_1 + v0_normal_1) * 0.5);
                            put_normal(param_96, param_97);
                        }
                        if (ires2.found == false)
                        {
                            uint param_98 = ie0;
                            vec3 param_99 = normalize((v0_normal_1 + v1_normal_1) * 0.5);
                            put_normal(param_98, param_99);
                            uint param_100 = ie1;
                            vec3 param_101 = normalize((v1_normal_1 + v2_normal_1) * 0.5);
                            put_normal(param_100, param_101);
                        }
                    }
                    if ((_158.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_102 = i0;
                        uint _993 = get_custom0(param_102);
                        uint v0_custom0_1 = _993;
                        uint param_103 = i1;
                        uint _997 = get_custom0(param_103);
                        uint v1_custom0_1 = _997;
                        uint param_104 = i2;
                        uint _1001 = get_custom0(param_104);
                        uint v2_custom0_1 = _1001;
                        uint param_105 = i0;
                        uint param_106 = v0_custom0_1;
                        put_custom0(param_105, param_106);
                        uint param_107 = i1;
                        uint param_108 = v1_custom0_1;
                        put_custom0(param_107, param_108);
                        uint param_109 = i2;
                        uint param_110 = v2_custom0_1;
                        put_custom0(param_109, param_110);
                        if (ires0.found == false)
                        {
                            uint param_111 = ie0;
                            uint param_112 = v1_custom0_1;
                            put_custom0(param_111, param_112);
                            uint param_113 = ie1;
                            uint param_114 = v2_custom0_1;
                            put_custom0(param_113, param_114);
                        }
                        if (ires1.found == false)
                        {
                            uint param_115 = ie0;
                            uint param_116 = v0_custom0_1;
                            put_custom0(param_115, param_116);
                            uint param_117 = ie1;
                            uint param_118 = v2_custom0_1;
                            put_custom0(param_117, param_118);
                        }
                        if (ires2.found == false)
                        {
                            uint param_119 = ie0;
                            uint param_120 = v0_custom0_1;
                            put_custom0(param_119, param_120);
                            uint param_121 = ie1;
                            uint param_122 = v1_custom0_1;
                            put_custom0(param_121, param_122);
                        }
                    }
                    uint _1065 = atomicAdd(_158.output_geometry_information.faces_num_per_surface[surface_idx], 3u);
                    uint dst_face_idx_1 = _1065;
                    if (ires0.found == false)
                    {
                        ni0_1 = i0;
                        ni1_1 = i1;
                        ni2_1 = ie0;
                        ni3_1 = i2;
                        ni4 = ie1;
                    }
                    else
                    {
                        if (ires1.found == false)
                        {
                            ni0_1 = i1;
                            ni1_1 = i2;
                            ni2_1 = ie1;
                            ni3_1 = i0;
                            ni4 = ie0;
                        }
                        else
                        {
                            ni0_1 = i2;
                            ni1_1 = i0;
                            ni2_1 = ie0;
                            ni3_1 = i1;
                            ni4 = ie1;
                        }
                    }
                    uint param_123 = (dst_face_idx_1 * 3u) + 0u;
                    uint param_124 = ni4;
                    put_idx(param_123, param_124);
                    uint param_125 = (dst_face_idx_1 * 3u) + 1u;
                    uint param_126 = ni0_1;
                    put_idx(param_125, param_126);
                    uint param_127 = (dst_face_idx_1 * 3u) + 2u;
                    uint param_128 = ni1_1;
                    put_idx(param_127, param_128);
                    dst_face_idx_1++;
                    uint param_129 = (dst_face_idx_1 * 3u) + 0u;
                    uint param_130 = ni4;
                    put_idx(param_129, param_130);
                    uint param_131 = (dst_face_idx_1 * 3u) + 1u;
                    uint param_132 = ni1_1;
                    put_idx(param_131, param_132);
                    uint param_133 = (dst_face_idx_1 * 3u) + 2u;
                    uint param_134 = ni2_1;
                    put_idx(param_133, param_134);
                    dst_face_idx_1++;
                    uint param_135 = (dst_face_idx_1 * 3u) + 0u;
                    uint param_136 = ni4;
                    put_idx(param_135, param_136);
                    uint param_137 = (dst_face_idx_1 * 3u) + 1u;
                    uint param_138 = ni2_1;
                    put_idx(param_137, param_138);
                    uint param_139 = (dst_face_idx_1 * 3u) + 2u;
                    uint param_140 = ni3_1;
                    put_idx(param_139, param_140);
                    max_ie = max(max_ie, (max(ie0, ie1) + 1u));
                }
                else
                {
                    if (added_faces == 4u)
                    {
                        uint ie0_1 = edge_hashmap_values.values[ires0.slot];
                        uint ie1_1 = edge_hashmap_values.values[ires1.slot];
                        uint ie2 = edge_hashmap_values.values[ires2.slot];
                        ie0_1 += _248.input_geometry_information.vtx_num;
                        ie1_1 += _248.input_geometry_information.vtx_num;
                        ie2 += _248.input_geometry_information.vtx_num;
                        uint param_141 = ie0_1;
                        vec3 param_142 = (v0_coords + v1_coords) * 0.5;
                        put_coords(param_141, param_142);
                        uint param_143 = ie1_1;
                        vec3 param_144 = (v1_coords + v2_coords) * 0.5;
                        put_coords(param_143, param_144);
                        uint param_145 = ie2;
                        vec3 param_146 = (v2_coords + v0_coords) * 0.5;
                        put_coords(param_145, param_146);
                        if ((_158.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                        {
                            uint param_147 = i0;
                            vec3 _1237 = get_normal(param_147);
                            vec3 v0_normal_2 = _1237;
                            uint param_148 = i1;
                            vec3 _1241 = get_normal(param_148);
                            vec3 v1_normal_2 = _1241;
                            uint param_149 = i2;
                            vec3 _1245 = get_normal(param_149);
                            vec3 v2_normal_2 = _1245;
                            uint param_150 = i0;
                            vec3 param_151 = v0_normal_2;
                            put_normal(param_150, param_151);
                            uint param_152 = i1;
                            vec3 param_153 = v1_normal_2;
                            put_normal(param_152, param_153);
                            uint param_154 = i2;
                            vec3 param_155 = v2_normal_2;
                            put_normal(param_154, param_155);
                            uint param_156 = ie0_1;
                            vec3 param_157 = normalize((v0_normal_2 + v1_normal_2) * 0.5);
                            put_normal(param_156, param_157);
                            uint param_158 = ie1_1;
                            vec3 param_159 = normalize((v1_normal_2 + v2_normal_2) * 0.5);
                            put_normal(param_158, param_159);
                            uint param_160 = ie2;
                            vec3 param_161 = normalize((v2_normal_2 + v0_normal_2) * 0.5);
                            put_normal(param_160, param_161);
                        }
                        if ((_158.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                        {
                            uint param_162 = i0;
                            uint _1297 = get_custom0(param_162);
                            uint v0_custom0_2 = _1297;
                            uint param_163 = i1;
                            uint _1301 = get_custom0(param_163);
                            uint v1_custom0_2 = _1301;
                            uint param_164 = i2;
                            uint _1305 = get_custom0(param_164);
                            uint v2_custom0_2 = _1305;
                            uint param_165 = i0;
                            uint param_166 = v0_custom0_2;
                            put_custom0(param_165, param_166);
                            uint param_167 = i1;
                            uint param_168 = v1_custom0_2;
                            put_custom0(param_167, param_168);
                            uint param_169 = i2;
                            uint param_170 = v2_custom0_2;
                            put_custom0(param_169, param_170);
                            uint param_171 = ie0_1;
                            uint param_172 = v0_custom0_2;
                            put_custom0(param_171, param_172);
                            uint param_173 = ie1_1;
                            uint param_174 = v1_custom0_2;
                            put_custom0(param_173, param_174);
                            uint param_175 = ie2;
                            uint param_176 = v2_custom0_2;
                            put_custom0(param_175, param_176);
                        }
                        uint _1339 = atomicAdd(_158.output_geometry_information.faces_num_per_surface[surface_idx], 4u);
                        uint dst_face_idx_2 = _1339;
                        uint param_177 = (dst_face_idx_2 * 3u) + 0u;
                        uint param_178 = i0;
                        put_idx(param_177, param_178);
                        uint param_179 = (dst_face_idx_2 * 3u) + 1u;
                        uint param_180 = ie0_1;
                        put_idx(param_179, param_180);
                        uint param_181 = (dst_face_idx_2 * 3u) + 2u;
                        uint param_182 = ie2;
                        put_idx(param_181, param_182);
                        dst_face_idx_2++;
                        uint param_183 = (dst_face_idx_2 * 3u) + 0u;
                        uint param_184 = ie0_1;
                        put_idx(param_183, param_184);
                        uint param_185 = (dst_face_idx_2 * 3u) + 1u;
                        uint param_186 = i1;
                        put_idx(param_185, param_186);
                        uint param_187 = (dst_face_idx_2 * 3u) + 2u;
                        uint param_188 = ie1_1;
                        put_idx(param_187, param_188);
                        dst_face_idx_2++;
                        uint param_189 = (dst_face_idx_2 * 3u) + 0u;
                        uint param_190 = ie1_1;
                        put_idx(param_189, param_190);
                        uint param_191 = (dst_face_idx_2 * 3u) + 1u;
                        uint param_192 = i2;
                        put_idx(param_191, param_192);
                        uint param_193 = (dst_face_idx_2 * 3u) + 2u;
                        uint param_194 = ie2;
                        put_idx(param_193, param_194);
                        dst_face_idx_2++;
                        uint param_195 = (dst_face_idx_2 * 3u) + 0u;
                        uint param_196 = ie0_1;
                        put_idx(param_195, param_196);
                        uint param_197 = (dst_face_idx_2 * 3u) + 1u;
                        uint param_198 = ie1_1;
                        put_idx(param_197, param_198);
                        uint param_199 = (dst_face_idx_2 * 3u) + 2u;
                        uint param_200 = ie2;
                        put_idx(param_199, param_200);
                        max_ie = max(max_ie, (max(ie0_1, max(ie1_1, ie2)) + 1u));
                    }
                }
            }
            uint _1440 = atomicMax(_158.output_geometry_information.vtx_num, max_ie);
        }
        if (added_faces == 1u)
        {
            if ((_158.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
            {
                uint param_201 = i0;
                vec3 _1454 = get_normal(param_201);
                vec3 v0_normal_3 = _1454;
                uint param_202 = i1;
                vec3 _1458 = get_normal(param_202);
                vec3 v1_normal_3 = _1458;
                uint param_203 = i2;
                vec3 _1462 = get_normal(param_203);
                vec3 v2_normal_3 = _1462;
                uint param_204 = i0;
                vec3 param_205 = v0_normal_3;
                put_normal(param_204, param_205);
                uint param_206 = i1;
                vec3 param_207 = v1_normal_3;
                put_normal(param_206, param_207);
                uint param_208 = i2;
                vec3 param_209 = v2_normal_3;
                put_normal(param_208, param_209);
            }
            if ((_158.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
            {
                uint param_210 = i0;
                uint _1487 = get_custom0(param_210);
                uint v0_custom0_3 = _1487;
                uint param_211 = i1;
                uint _1491 = get_custom0(param_211);
                uint v1_custom0_3 = _1491;
                uint param_212 = i2;
                uint _1495 = get_custom0(param_212);
                uint v2_custom0_3 = _1495;
                uint param_213 = i0;
                uint param_214 = v0_custom0_3;
                put_custom0(param_213, param_214);
                uint param_215 = i1;
                uint param_216 = v1_custom0_3;
                put_custom0(param_215, param_216);
                uint param_217 = i2;
                uint param_218 = v2_custom0_3;
                put_custom0(param_217, param_218);
            }
            uint _1514 = atomicAdd(_158.output_geometry_information.faces_num_per_surface[surface_idx], 1u);
            uint dst_face_idx_3 = _1514;
            uint param_219 = (dst_face_idx_3 * 3u) + 0u;
            uint param_220 = i0;
            put_idx(param_219, param_220);
            uint param_221 = (dst_face_idx_3 * 3u) + 1u;
            uint param_222 = i1;
            put_idx(param_221, param_222);
            uint param_223 = (dst_face_idx_3 * 3u) + 2u;
            uint param_224 = i2;
            put_idx(param_223, param_224);
        }
    }
    if (thread_idx == 0u)
    {
        uint _1546 = atomicMax(_158.output_geometry_information.vtx_num, _248.input_geometry_information.vtx_num);
    }
}

 