#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct InstancingGeneratorParams
{
    int seed;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float surface_distance;
    vec3 instance_scale;
    int alpha_to_modifier_factor;
    vec3 duplicate_elimination_position_decimation;
    int duplicate_elimination_position;
    vec3 duplicate_elimination_position_decimation_rcp;
    float duplicate_elimination_normal_decimation;
    float duplicate_elimination_normal_decimation_rcp;
    int duplicate_elimination_normal;
    float min_face_size;
    int _pad0;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _170;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _231;

layout(set = 0, binding = 3, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _289;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _322;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _574;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _655;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _678;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _698;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _706;

uint particle_emitter_geometry_get_first_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _289.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _289.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _156 = hash(param);
    uint param_1 = _156;
    float _158 = floatConstruct(param_1);
    return _158;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _231.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _231.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _231.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_170.in_vtx_data[coord_offset + 0u], _170.in_vtx_data[coord_offset + 1u], _170.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_170.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    InstancingGeneratorParams _327;
    _327.seed = _322.instancing_generator_params.seed;
    _327.transformed_data_location_idx = _322.instancing_generator_params.transformed_data_location_idx;
    _327.transformed_data_location_num = _322.instancing_generator_params.transformed_data_location_num;
    _327.surface_distance = _322.instancing_generator_params.surface_distance;
    _327.instance_scale = _322.instancing_generator_params.instance_scale;
    _327.alpha_to_modifier_factor = _322.instancing_generator_params.alpha_to_modifier_factor;
    _327.duplicate_elimination_position_decimation = _322.instancing_generator_params.duplicate_elimination_position_decimation;
    _327.duplicate_elimination_position = _322.instancing_generator_params.duplicate_elimination_position;
    _327.duplicate_elimination_position_decimation_rcp = _322.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _327.duplicate_elimination_normal_decimation = _322.instancing_generator_params.duplicate_elimination_normal_decimation;
    _327.duplicate_elimination_normal_decimation_rcp = _322.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _327.duplicate_elimination_normal = _322.instancing_generator_params.duplicate_elimination_normal;
    _327.min_face_size = _322.instancing_generator_params.min_face_size;
    _327._pad0 = _322.instancing_generator_params._pad0;
    InstancingGeneratorParams param = _327;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    InstancingGeneratorParams _333;
    _333.seed = _322.instancing_generator_params.seed;
    _333.transformed_data_location_idx = _322.instancing_generator_params.transformed_data_location_idx;
    _333.transformed_data_location_num = _322.instancing_generator_params.transformed_data_location_num;
    _333.surface_distance = _322.instancing_generator_params.surface_distance;
    _333.instance_scale = _322.instancing_generator_params.instance_scale;
    _333.alpha_to_modifier_factor = _322.instancing_generator_params.alpha_to_modifier_factor;
    _333.duplicate_elimination_position_decimation = _322.instancing_generator_params.duplicate_elimination_position_decimation;
    _333.duplicate_elimination_position = _322.instancing_generator_params.duplicate_elimination_position;
    _333.duplicate_elimination_position_decimation_rcp = _322.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _333.duplicate_elimination_normal_decimation = _322.instancing_generator_params.duplicate_elimination_normal_decimation;
    _333.duplicate_elimination_normal_decimation_rcp = _322.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _333.duplicate_elimination_normal = _322.instancing_generator_params.duplicate_elimination_normal;
    _333.min_face_size = _322.instancing_generator_params.min_face_size;
    _333._pad0 = _322.instancing_generator_params._pad0;
    InstancingGeneratorParams param_1 = _333;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float face_min_size_threshold = _322.instancing_generator_params.min_face_size;
    vec3 bc;
    float _526;
    CoordinateSystemTrasforms cs_transforms;
    Instance instance;
    for (int i = 0; i < 4; i++)
    {
        float fid = float(id);
        float fid_seed = (((fid * 0.0131700001657009124755859375) + float(_322.instancing_generator_params.seed)) + float(i)) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_2));
        face_idx += first_face_idx;
        uint param_3 = face_idx;
        RTFace rt_face = rt_get_face(param_3);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_4 = p0_idx;
        vec3 p0 = rt_get_vertex(param_4);
        uint param_5 = p1_idx;
        vec3 p1 = rt_get_vertex(param_5);
        uint param_6 = p2_idx;
        vec3 p2 = rt_get_vertex(param_6);
        float face_size = length(cross(p0 - p1, p0 - p2));
        if (face_size < face_min_size_threshold)
        {
            continue;
        }
        uint param_7 = p0_idx;
        vec4 c0 = rt_get_vertex_color(param_7);
        uint param_8 = p1_idx;
        vec4 c1 = rt_get_vertex_color(param_8);
        uint param_9 = p2_idx;
        vec4 c2 = rt_get_vertex_color(param_9);
        float param_10 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_10);
        float param_11 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_11);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec4 col = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        vec3 nx = normalize(p0 - p2);
        vec3 ny = normalize(p0 - p1);
        vec3 nz = normalize(cross(nx, ny));
        ny = cross(nz, nx);
        ModifierFactor modifier_factor = modifier_factor_defaults();
        if (_322.instancing_generator_params.alpha_to_modifier_factor != 0)
        {
            _526 = col.w;
        }
        else
        {
            _526 = 1.0;
        }
        modifier_factor.factor = _526;
        modifier_factor.hash = floatBitsToUint(fid_seed);
        modifier_factor.id = id;
        modifier_factor.position = pos;
        modifier_factor.is_spawned = true;
        modifier_factor.color = col;
        modifier_factor.normal = nz;
        cs_transforms.mat_local_to_model = mat_identity();
        cs_transforms.mat_local_to_instance = mat_identity();
        cs_transforms.mat_local_to_model_inv = mat_identity();
        bool _560 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
        bool _567;
        if (!_560)
        {
            _567 = modifier_factor.is_discarded == true;
        }
        else
        {
            _567 = _560;
        }
        if (_567)
        {
            continue;
        }
        if (_574.instance_params.instance_count >= _574.instance_params.buffer_capacity)
        {
            return;
        }
        int _586 = atomicAdd(_574.instance_params.instance_count, 1);
        uint instance_id = uint(_586);
        if (instance_id >= uint(_574.instance_params.buffer_capacity))
        {
            return;
        }
        pos -= (nz * _322.instancing_generator_params.surface_distance);
        nx *= _322.instancing_generator_params.instance_scale.x;
        ny *= _322.instancing_generator_params.instance_scale.y;
        nz *= _322.instancing_generator_params.instance_scale.z;
        instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
        instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
        instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
        instance.hash = modifier_factor.hash;
        instance.c = vec4(1.0);
        instance.flipbook_card = 0u;
        _655.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
        _655.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
        _655.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
        _678.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
        _678.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
        _698.instance_hash[instance_id] = instance.hash;
        _706.instance_flipbook_card[instance_id] = instance.flipbook_card;
        return;
    }
}

 