#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct _212
{
    vec3 vLocalPos;
    vec4 vColor;
    vec2 vUV0;
    uint vIdx;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _138;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _162;

layout(set = 0, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _279;

layout(location = 0) out uint instanceID;
layout(location = 1) out _212 vtx_output;

bool prt_is_alive(uint id)
{
    return _138.prt_states[id].life_time < _138.prt_states[id].life_span;
}

vec3 prt_get_position(uint id)
{
    return vec3(_162.prt_positions[(id * 3u) + 0u], _162.prt_positions[(id * 3u) + 1u], _162.prt_positions[(id * 3u) + 2u]);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _138.prt_states[id].color;
    vec3 _189 = color_convert_uint_to_float3(param);
    c.x = _189.x;
    c.y = _189.y;
    c.z = _189.z;
    return c;
}

vec3 apply_vtx_modifier(vec3 pos, vec3 norm, vec3 color, uint particle_id)
{
    return pos;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _155;
    _155.life_time = _138.prt_states[id].life_time;
    _155.life_span = _138.prt_states[id].life_span;
    _155.generation_id = _138.prt_states[id].generation_id;
    _155.color = _138.prt_states[id].color;
    ParticleState _154 = _155;
    return _154;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    instanceID = uint(gl_VertexIndex);
    int particle_id = gl_VertexIndex;
    vtx_output.vLocalPos = vec3(0.0);
    vtx_output.vIdx = 0u;
    uint param = uint(particle_id);
    if (!prt_is_alive(param))
    {
        gl_Position = vec4(uintBitsToFloat(0x7fc00000u /* nan */));
        return;
    }
    uint param_1 = uint(particle_id);
    vec3 vInstPosition = prt_get_position(param_1);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_2 = uint(particle_id);
    vec4 vInstColor = prt_get_color(param_2);
    vec3 param_3 = vInstPosition;
    vec3 param_4 = vInstNormal;
    vec3 param_5 = vInstColor.xyz;
    uint param_6 = uint(particle_id);
    vInstColor.x = param_5.x;
    vInstColor.y = param_5.y;
    vInstColor.z = param_5.z;
    vInstPosition = apply_vtx_modifier(param_3, param_4, param_5, param_6);
    uint param_7 = uint(particle_id);
    ParticleState vState = prt_get_state(param_7);
    vec3 pos = vInstPosition;
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_8 = vPos1;
    mat4 param_9 = _279.transform_params.mModelView;
    vec3 _286 = vector_transform_by_mat43(param_8, param_9);
    vec3 vPos = _286;
    vtx_output.vColor = vec4(vInstColor);
    vtx_output.vIdx = 1u;
    vec3 param_10 = vPos;
    mat4 param_11 = _279.transform_params.mProjection;
    vec4 _301 = vector_transform_by_mat_projection(param_10, param_11);
    gl_Position = _301;
}

 