#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require

struct VisualizeVoxelizationGridParams
{
    int lod;
    int grid_res_for_lod;
    uint _pad1;
    uint _pad2;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform VisualizeVoxelizationGridParamsBuffer
{
    VisualizeVoxelizationGridParams visualize_voxelization_grid;
} _75;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _274;

layout(set = 0, binding = 4) uniform sampler3D s_voxel_occupancy;
layout(set = 0, binding = 5) uniform sampler3D s_voxel_colors_filtered;

layout(location = 0) out uint instanceID;
layout(location = 1) out Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_output;


uint rt_mask_vtx_idx(uint vtx_idx)
{
    return vtx_idx & 16777215u;
}

vec3 get_vertex(uint idx)
{
    uint voxel_idx = uint(gl_InstanceIndex);
    vec3 voxel_p;
    voxel_p.x = float(voxel_idx % uint(_75.visualize_voxelization_grid.grid_res_for_lod));
    voxel_p.y = float((voxel_idx / uint(_75.visualize_voxelization_grid.grid_res_for_lod)) % uint(_75.visualize_voxelization_grid.grid_res_for_lod));
    voxel_p.z = float((voxel_idx / uint(_75.visualize_voxelization_grid.grid_res_for_lod * _75.visualize_voxelization_grid.grid_res_for_lod)) % uint(_75.visualize_voxelization_grid.grid_res_for_lod));
    vec3 p = vec3((ivec3(10362, 687, 12771) >> ivec3(uvec3(idx))) & ivec3(1));
    float scale = texelFetch(s_voxel_occupancy, ivec3(voxel_p), _75.visualize_voxelization_grid.lod).x;
    vec3 size = in_bbox_data.grid_size_voxelize.xyz;
    p = ((vec3(voxel_p * float(1 << _75.visualize_voxelization_grid.lod)) * in_bbox_data.grid_size_voxelize.xyz) + in_bbox_data.bbox_voxelize_min.xyz) + (((p * size) * scale) * float(1 << _75.visualize_voxelization_grid.lod));
    return p;
}

vec3 get_vertex_normal(uint idx)
{
    return vec3(1.0, 1.0, 0.0);
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 get_vertex_color(uint idx)
{
    uint voxel_idx = uint(gl_InstanceIndex);
    vec3 voxel_p;
    voxel_p.x = float(voxel_idx % uint(_75.visualize_voxelization_grid.grid_res_for_lod));
    voxel_p.y = float((voxel_idx / uint(_75.visualize_voxelization_grid.grid_res_for_lod)) % uint(_75.visualize_voxelization_grid.grid_res_for_lod));
    voxel_p.z = float((voxel_idx / uint(_75.visualize_voxelization_grid.grid_res_for_lod * _75.visualize_voxelization_grid.grid_res_for_lod)) % uint(_75.visualize_voxelization_grid.grid_res_for_lod));
    vec3 _227 = texelFetch(s_voxel_colors_filtered, ivec3(voxel_p), _75.visualize_voxelization_grid.lod).xyz;
    vec4 color;
    color.x = _227.x;
    color.y = _227.y;
    color.z = _227.z;
    color.w = 1.0;
    return color + vec4(0.100000001490116119384765625);
}

void main()
{
    instanceID = 0u;
    uint param = uint(gl_VertexIndex);
    uint vtx_idx = rt_mask_vtx_idx(param);
    uint param_1 = vtx_idx;
    vec3 pos = get_vertex(param_1);
    uint param_2 = vtx_idx;
    vec3 norm = get_vertex_normal(param_2);
    vtx_output.vLocalPos = pos;
    vec4 vPos1 = vec4(pos, 1.0);
    vec3 param_3 = pos;
    mat4 param_4 = _274.transform_params.mModelView;
    vec3 _281 = vector_transform_by_mat43(param_3, param_4);
    vec3 vPos = _281;
    vec3 param_5 = pos;
    mat4 param_6 = _274.transform_params.mModel;
    vec3 _288 = vector_transform_by_mat43(param_5, param_6);
    vtx_output.vCameraRelativeWorldPos = _288 - _274.transform_params.vCameraPosition;
    vtx_output.vWorldNorm = (_274.transform_params.mModel * vec4(norm, 0.0)).xyz;
    vtx_output.vNorm.x = dot(_274.transform_params.mModelViewInvTrans[0].xyz, norm);
    vtx_output.vNorm.y = dot(_274.transform_params.mModelViewInvTrans[1].xyz, norm);
    vtx_output.vNorm.z = dot(_274.transform_params.mModelViewInvTrans[2].xyz, norm);
    vtx_output.vNorm = normalize(vtx_output.vNorm);
    gl_Position = _274.transform_params.mProjection * vec4(vPos, 1.0);
    uint param_7 = vtx_idx;
    vtx_output.vColor = vec4(get_vertex_color(param_7));
    vtx_output.vUV0 = vec2(0.0);
}

 