#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require
layout(lines) in;
layout(max_vertices = 2, line_strip) out;

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct PartitionGeometryDrawParams
{
    uint64_t buff_grid_markers_ptr;
    uint instance_idx;
};

layout(set = 2, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(location = 1) in Vertex
{
    vec3 vLocalPos;
    vec4 vColor;
    vec2 vUV0;
    uint vIdx;
} vtx_inputs[2];

layout(location = 5) noperspective out vec3 vLineCoords[2];
layout(location = 0) flat out int vOrientationIndex;
layout(location = 1) out vec3 vGridCoords;
layout(location = 2) out vec2 vUV0;
layout(location = 8) out vec4 vColor;

void main()
{
    vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;
    vec3 v0 = vtx_inputs[0].vLocalPos;
    vec3 v1 = vtx_inputs[1].vLocalPos;
    bool _48 = vtx_inputs[0].vIdx == 0u;
    bool _55;
    if (!_48)
    {
        _55 = vtx_inputs[1].vIdx == 0u;
    }
    else
    {
        _55 = _48;
    }
    if (_55)
    {
        return;
    }
    vec3 s = -bbox_origin;
    v0 += s;
    v1 += s;
    vec3 f = vec3(1.0) / bbox_grid_size;
    v0 *= f;
    v1 *= f;
    vec3 d = v0 - v1;
    d = abs(d);
    float _length = length(v1 - v0);
    vec3 grid_v0 = v0;
    vec3 grid_v1 = v1;
    bool _100 = d.x < d.y;
    bool _108;
    if (_100)
    {
        _108 = d.x < d.z;
    }
    else
    {
        _108 = _100;
    }
    int orientation_index;
    if (_108)
    {
        grid_v0 = grid_v0.yzx;
        grid_v1 = grid_v1.yzx;
        orientation_index = 0;
    }
    else
    {
        bool _122 = d.y < d.x;
        bool _130;
        if (_122)
        {
            _130 = d.y < d.z;
        }
        else
        {
            _130 = _122;
        }
        if (_130)
        {
            grid_v0 = grid_v0.zxy;
            grid_v1 = grid_v1.zxy;
            orientation_index = 1;
        }
        else
        {
            grid_v0 = grid_v0;
            grid_v1 = grid_v1;
            orientation_index = 2;
        }
    }
    vLineCoords[0] = v0;
    vLineCoords[1] = v1;
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v0 * 2.0) - vec3(256.0), 256.0);
    vGridCoords = grid_v0;
    vUV0 = vtx_inputs[0].vUV0;
    vColor = vtx_inputs[0].vColor;
    EmitVertex();
    vLineCoords[0] = v0;
    vLineCoords[1] = v1;
    vOrientationIndex = orientation_index;
    gl_Position = vec4((grid_v1 * 2.0) - vec3(256.0), 256.0);
    vGridCoords = grid_v1;
    vUV0 = vtx_inputs[1].vUV0;
    vColor = vtx_inputs[1].vColor;
    EmitVertex();
    EndPrimitive();
}

 