#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorQuantizePosition_Params
{
    vec3 quantization_step;
    float _pad0;
    vec3 offset;
    int quantize_x;
    int quantize_y;
    int quantize_z;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct _2358
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _658;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1914;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1925;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _2013;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2205;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _2246;

layout(set = 0, binding = 13, std140) uniform VM0
{
    ModifierFactorQuantizePosition_Params VM0_params;
} _2259;

layout(set = 0, binding = 14, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _2274;

layout(set = 0, binding = 15, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _2288;

layout(set = 0, binding = 16, std140) uniform VM3
{
    ModifierFactorCurveTransfer_Params VM3_params;
} _2302;

layout(set = 0, binding = 17, std140) uniform VM4
{
    ModifierFactorClamp_Params VM4_params;
} _2315;

layout(set = 0, binding = 18, std140) uniform VM5
{
    layout(row_major) ModifierFactorDistancePlane_Params VM5_params;
} _2328;

layout(set = 0, binding = 19, std140) uniform VM6
{
    VertexModifierDisplaceParams VM6_params;
} _2343;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2453;

layout(set = 0, binding = 20) uniform sampler2D s_Curves;

layout(location = 1) out _2358 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _658.geometry_information.attributes[0].stride;
    idx += _658.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _658.geometry_information.attributes[2].stride;
    idx += _658.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _658.geometry_information.attributes[1].stride;
    idx += _658.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _658.geometry_information.attributes[3].stride;
    idx += _658.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _658.geometry_information.attributes[6].stride;
    idx += _658.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

void modifier_factor_quantize_position(ModifierFactorQuantizePosition_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 p = modifier_factor.position;
    p = vec4(p, 1.0).xyz;
    p = (floor((p + modifier_params.offset) / modifier_params.quantization_step) * modifier_params.quantization_step) - modifier_params.offset;
    p = vec4(p, 1.0).xyz;
    if (modifier_params.quantize_x != 0)
    {
        modifier_factor.position.x = p.x;
    }
    if (modifier_params.quantize_y != 0)
    {
        modifier_factor.position.y = p.y;
    }
    if (modifier_params.quantize_z != 0)
    {
        modifier_factor.position.z = p.z;
    }
    if (modifier_factor.has_world_position)
    {
        vec3 p_1 = modifier_factor.world_position;
        p_1 = floor(p_1 / modifier_params.quantization_step) * modifier_params.quantization_step;
        if (modifier_params.quantize_x != 0)
        {
            modifier_factor.world_position.x = p_1.x;
        }
        if (modifier_params.quantize_y != 0)
        {
            modifier_factor.world_position.y = p_1.y;
        }
        if (modifier_params.quantize_z != 0)
        {
            modifier_factor.world_position.z = p_1.z;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1398 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1398;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1465 = vector_transform_by_mat43(param, param_1);
        coords = _1465;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1472 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1472;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1416 = vector_transform_by_mat43(param, param_1);
        coords = _1416;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1423 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1423;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1587 = vector_transform_by_mat43(param, param_1);
        coords = _1587;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1594 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1594;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_1914.instance_params.stride > 0)
    {
        uint flipbook_card = _1925.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_658.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_658.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _1947 = vtx_coords_load(param);
    vtx_input.pos = _1947;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_658.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _1965 = vtx_albedo_load(param_1);
        vtx_input.color.x = _1965.x;
        vtx_input.color.y = _1965.y;
        vtx_input.color.z = _1965.z;
    }
    if ((_658.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1980 = vtx_normals_load(param_2);
        vtx_input.norm = _1980;
    }
    if ((_658.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1991 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1991;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_1914.instance_params.stride > 0)
    {
        vec4 inst_m0 = _2013.instance_transform[(gl_InstanceIndex * _1914.instance_params.stride) + 0];
        vec4 inst_m1 = _2013.instance_transform[(gl_InstanceIndex * _1914.instance_params.stride) + 1];
        vec4 inst_m2 = _2013.instance_transform[(gl_InstanceIndex * _1914.instance_params.stride) + 2];
        vec3 _2044 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _2044.x;
        mat_instance_model[0].y = _2044.y;
        mat_instance_model[0].z = _2044.z;
        vec3 _2057 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _2057.x;
        mat_instance_model[1].y = _2057.y;
        mat_instance_model[1].z = _2057.z;
        vec3 _2070 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _2070.x;
        mat_instance_model[2].y = _2070.y;
        mat_instance_model[2].z = _2070.z;
        vec3 _2083 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _2083.x;
        mat_instance_model[3].y = _2083.y;
        mat_instance_model[3].z = _2083.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_1914.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _2205.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_658.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _2228 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _2228;
    }
    if ((_658.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _2239 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _2239;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _2246.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _2246.transform_params.mModelInv;
    ModifierFactorQuantizePosition_Params _2264;
    _2264.quantization_step = _2259.VM0_params.quantization_step;
    _2264._pad0 = _2259.VM0_params._pad0;
    _2264.offset = _2259.VM0_params.offset;
    _2264.quantize_x = _2259.VM0_params.quantize_x;
    _2264.quantize_y = _2259.VM0_params.quantize_y;
    _2264.quantize_z = _2259.VM0_params.quantize_z;
    ModifierFactorQuantizePosition_Params param_7 = _2264;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_quantize_position(param_7, param_8, param_9);
    modifier_factor = param_8;
    ModifierFactorNoise_Params _2279;
    _2279.transform_local_to_gizmo = _2274.VM1_params.transform_local_to_gizmo;
    _2279.noise_domain_scale = _2274.VM1_params.noise_domain_scale;
    _2279.modifier_function = _2274.VM1_params.modifier_function;
    _2279.noise_domain_offset = _2274.VM1_params.noise_domain_offset;
    _2279.noise_value_scale = _2274.VM1_params.noise_value_scale;
    _2279.noise_value_offset = _2274.VM1_params.noise_value_offset;
    _2279.influence_scope = _2274.VM1_params.influence_scope;
    _2279._pad0 = _2274.VM1_params._pad0;
    _2279._pad1 = _2274.VM1_params._pad1;
    ModifierFactorNoise_Params param_10 = _2279;
    ModifierFactor param_11 = modifier_factor;
    CoordinateSystemTrasforms param_12 = cs_transforms;
    modifier_factor_noise_simplex2(param_10, param_11, param_12);
    modifier_factor = param_11;
    ModifierFactorNoise_Params _2292;
    _2292.transform_local_to_gizmo = _2288.VM2_params.transform_local_to_gizmo;
    _2292.noise_domain_scale = _2288.VM2_params.noise_domain_scale;
    _2292.modifier_function = _2288.VM2_params.modifier_function;
    _2292.noise_domain_offset = _2288.VM2_params.noise_domain_offset;
    _2292.noise_value_scale = _2288.VM2_params.noise_value_scale;
    _2292.noise_value_offset = _2288.VM2_params.noise_value_offset;
    _2292.influence_scope = _2288.VM2_params.influence_scope;
    _2292._pad0 = _2288.VM2_params._pad0;
    _2292._pad1 = _2288.VM2_params._pad1;
    ModifierFactorNoise_Params param_13 = _2292;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_noise_default(param_13, param_14, param_15);
    modifier_factor = param_14;
    ModifierFactorCurveTransfer_Params _2307;
    _2307.curve_idx = _2302.VM3_params.curve_idx;
    _2307.input_range_min = _2302.VM3_params.input_range_min;
    _2307.input_range_max = _2302.VM3_params.input_range_max;
    _2307.amplitude = _2302.VM3_params.amplitude;
    _2307.base = _2302.VM3_params.base;
    ModifierFactorCurveTransfer_Params param_16 = _2307;
    ModifierFactor param_17 = modifier_factor;
    modifier_factor_curve_transfer(param_16, param_17);
    modifier_factor = param_17;
    ModifierFactorClamp_Params _2320;
    _2320.clamp_min = _2315.VM4_params.clamp_min;
    _2320.clamp_max = _2315.VM4_params.clamp_max;
    _2320.clamp_min_enable = _2315.VM4_params.clamp_min_enable;
    _2320.clamp_max_enable = _2315.VM4_params.clamp_max_enable;
    ModifierFactorClamp_Params param_18 = _2320;
    ModifierFactor param_19 = modifier_factor;
    modifier_factor_clamp(param_18, param_19);
    modifier_factor = param_19;
    ModifierFactorDistancePlane_Params _2333;
    _2333.transform_local_to_gizmo = _2328.VM5_params.transform_local_to_gizmo;
    _2333.falloff_curve_idx = _2328.VM5_params.falloff_curve_idx;
    _2333.falloff_inverse = _2328.VM5_params.falloff_inverse;
    _2333.domain_mirror = _2328.VM5_params.domain_mirror;
    _2333.domain_repeat = _2328.VM5_params.domain_repeat;
    _2333.influence_scope = _2328.VM5_params.influence_scope;
    _2333.modifier_function = _2328.VM5_params.modifier_function;
    ModifierFactorDistancePlane_Params param_20 = _2333;
    ModifierFactor param_21 = modifier_factor;
    CoordinateSystemTrasforms param_22 = cs_transforms;
    modifier_factor_distance_plane(param_20, param_21, param_22);
    modifier_factor = param_21;
    VertexModifierDisplaceParams _2348;
    _2348.displace_normal = _2343.VM6_params.displace_normal;
    _2348.displace_normal_modifier_factor = _2343.VM6_params.displace_normal_modifier_factor;
    _2348.displace_base = _2343.VM6_params.displace_base;
    _2348.displace_base_modifier_factor = _2343.VM6_params.displace_base_modifier_factor;
    _2348.influence_scope = _2343.VM6_params.influence_scope;
    VertexModifierDisplaceParams param_23 = _2348;
    ModifierFactor param_24 = modifier_factor;
    VertexInput param_25 = vtx_input;
    CoordinateSystemTrasforms param_26 = cs_transforms;
    vertex_modifier_displace_apply(param_23, param_24, param_25, param_26);
    modifier_factor = param_24;
    vtx_input = param_25;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_1914.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _2013.instance_transform[(gl_InstanceIndex * _1914.instance_params.stride) + 0];
        vec4 inst_m1_1 = _2013.instance_transform[(gl_InstanceIndex * _1914.instance_params.stride) + 1];
        vec4 inst_m2_1 = _2013.instance_transform[(gl_InstanceIndex * _1914.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_27 = vtx_input.norm;
        mat4 param_28 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_27, param_28));
        vec2 _2459 = unpackHalf2x16(_2453.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _2459.x;
        inst_c.y = _2459.y;
        vec2 _2469 = unpackHalf2x16(_2453.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _2469.x;
        inst_c.w = _2469.y;
        vec4 _2475 = vtx_input.color;
        vec3 _2479 = _2475.xyz * inst_c.xyz;
        vtx_input.color.x = _2479.x;
        vtx_input.color.y = _2479.y;
        vtx_input.color.z = _2479.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_29 = vtx_input.pos;
    mat4 param_30 = _2246.transform_params.mModel;
    vec3 _2499 = vector_transform_by_mat43(param_29, param_30);
    vec3 vPosModel = _2499;
    vec3 param_31 = vtx_input.norm;
    mat4 param_32 = _2246.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_31, param_32);
    vec3 param_33 = vPosModel;
    mat4 param_34 = _2246.transform_params.mView;
    vec3 _2514 = vector_transform_by_mat43(param_33, param_34);
    vec3 vPosModelView = _2514;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _2246.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_2246.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_2246.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_2246.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_35 = vtx_output.vCoords;
    mat4 param_36 = _2246.transform_params.mProjection;
    vec4 _2567 = vector_transform_by_mat_projection(param_35, param_36);
    gl_Position = _2567;
}

 