#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(depth_greater) out float gl_FragDepth;

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    float param1;
    float param2;
    float param3;
    float param4;
    int use_instance_origin;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct _1261
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 3, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1015;

layout(set = 1, binding = 4, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1041;

layout(set = 1, binding = 2, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1051;

layout(set = 1, binding = 5, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _1137;

layout(set = 1, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1160;

layout(set = 1, binding = 7) uniform sampler2D s_NoiseRGBA;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _1261 vtx_input;
vec3 lig;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    for (int i = 0; i < 32; i++)
    {
        if ((h < 0.001000000047497451305389404296875) || (t > 2000.0))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = vec3(1000.0);
        vec3 param_2 = ro + (rd * t);
        vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
        h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
        t += h;
    }
    if (t < 2000.0)
    {
        res = t;
    }
    return res;
}

float _noise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return mix(rg.x, rg.y, f.z);
}

float displacement(inout vec3 p)
{
    p += vec3(1.0, 0.0, 0.800000011920928955078125);
    vec3 param = p;
    float f = 0.5 * _noise(param);
    p = (mat3(vec3(0.0, 0.800000011920928955078125, 0.60000002384185791015625), vec3(-0.800000011920928955078125, 0.36000001430511474609375, -0.4799999892711639404296875), vec3(-0.60000002384185791015625, -0.4799999892711639404296875, 0.63999998569488525390625)) * p) * 2.019999980926513671875;
    vec3 param_1 = p;
    f += (0.25 * _noise(param_1));
    p = (mat3(vec3(0.0, 0.800000011920928955078125, 0.60000002384185791015625), vec3(-0.800000011920928955078125, 0.36000001430511474609375, -0.4799999892711639404296875), vec3(-0.60000002384185791015625, -0.4799999892711639404296875, 0.63999998569488525390625)) * p) * 2.0299999713897705078125;
    vec3 param_2 = p;
    f += (0.125 * _noise(param_2));
    p = (mat3(vec3(0.0, 0.800000011920928955078125, 0.60000002384185791015625), vec3(-0.800000011920928955078125, 0.36000001430511474609375, -0.4799999892711639404296875), vec3(-0.60000002384185791015625, -0.4799999892711639404296875, 0.63999998569488525390625)) * p) * 2.0099999904632568359375;
    vec3 param_3 = p;
    f += (0.0625 * _noise(param_3));
    vec3 param_4 = p * 3.5;
    float n = _noise(param_4);
    f += ((0.02999999932944774627685546875 * n) * n);
    return f;
}

float mapTerrain(vec3 pos)
{
    vec3 param = pos * vec3(0.800000011920928955078125, 1.0, 0.800000011920928955078125);
    float _416 = displacement(param);
    return (pos.y * 0.100000001490116119384765625) + ((_416 - 0.4000000059604644775390625) * (1.0 - smoothstep(1.0, 3.0, pos.y)));
}

float raymarchTerrain(vec3 ro, vec3 rd, float max_t)
{
    float maxd = max_t;
    float t = 0.100000001490116119384765625;
    for (int i = 0; i < 256; i++)
    {
        vec3 param = ro + (rd * t);
        float h = mapTerrain(param);
        if ((h < (0.001000000047497451305389404296875 * t)) || (t > maxd))
        {
            break;
        }
        t += (h * 0.800000011920928955078125);
    }
    if (t > maxd)
    {
        t = -1.0;
    }
    return t;
}

vec3 calcNormal(vec3 pos, float t)
{
    vec3 eps = vec3(max(0.0199999995529651641845703125, 0.001000000047497451305389404296875 * t), 0.0, 0.0);
    vec3 param = pos + eps.xyy;
    vec3 param_1 = pos - eps.xyy;
    vec3 param_2 = pos + eps.yxy;
    vec3 param_3 = pos - eps.yxy;
    vec3 param_4 = pos + eps.yyx;
    vec3 param_5 = pos - eps.yyx;
    return normalize(vec3(mapTerrain(param) - mapTerrain(param_1), mapTerrain(param_2) - mapTerrain(param_3), mapTerrain(param_4) - mapTerrain(param_5)));
}

vec4 texcube(sampler2D sam, vec3 p, vec3 n)
{
    vec4 x = texture(sam, p.yz);
    vec4 y = texture(sam, p.zx);
    vec4 z = texture(sam, p.xy);
    return ((x * abs(n.x)) + (y * abs(n.y))) + (z * abs(n.z));
}

float softshadow(vec3 ro, vec3 rd, float mint, float k)
{
    float res = 1.0;
    float t = mint;
    for (int i = 0; i < 64; i++)
    {
        vec3 param = ro + (rd * t);
        float h = mapTerrain(param);
        h = max(h, 0.0);
        res = min(res, (k * h) / t);
        t += clamp(h, 0.0199999995529651641845703125, 0.5);
        if (res < 0.001000000047497451305389404296875)
        {
            break;
        }
    }
    return clamp(res, 0.0, 1.0);
}

float _noise(vec2 x)
{
    vec2 p = floor(x);
    vec2 f = fract(x);
    vec2 uv = p + ((f * f) * (vec2(3.0) - (f * 2.0)));
    return textureLod(s_NoiseRGBA, (uv + vec2(118.40000152587890625)) / vec2(256.0), 0.0).x;
}

float lava(inout vec2 p)
{
    p += vec2(2.0, 4.0);
    vec2 param = p;
    float f = 0.5 * _noise(param);
    p *= 2.019999980926513671875;
    vec2 param_1 = p;
    f += (0.25 * _noise(param_1));
    p *= 2.0299999713897705078125;
    vec2 param_2 = p;
    f += (0.125 * _noise(param_2));
    p *= 2.0099999904632568359375;
    vec2 param_3 = p;
    f += (0.0625 * _noise(param_3));
    return f;
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, inout vec4 color)
{
    vec3 col = vec3(1.0);
    vec3 param = ro;
    vec3 param_1 = rd;
    float param_2 = max_t;
    float t = raymarchTerrain(param, param_1, param_2);
    if (t > max_t)
    {
        return -1.0;
    }
    float st = t;
    if (t > 0.0)
    {
        vec3 pos = ro + (rd * t);
        vec3 param_3 = pos;
        float param_4 = t;
        vec3 nor = calcNormal(param_3, param_4);
        vec3 ref = reflect(rd, nor);
        vec3 param_5 = (pos * 3.0) / vec3(4.0);
        vec3 param_6 = nor;
        vec3 bn = vec3(-1.0) + (texcube(s_NoiseRGBA, param_5, param_6).xyz * 2.0);
        nor = normalize(nor + (bn * 0.60000002384185791015625));
        float hh = 1.0 - smoothstep(-2.0, 1.0, pos.y);
        float sun = 1.0;
        float sha = 0.0;
        if (sun > 0.00999999977648258209228515625)
        {
            vec3 param_7 = pos;
            vec3 param_8 = lig;
            float param_9 = 0.00999999977648258209228515625;
            float param_10 = 32.0;
            sha = softshadow(param_7, param_8, param_9, param_10);
        }
        float bac = clamp(dot(nor, normalize(lig * vec3(-1.0, 0.0, -1.0))), 0.0, 1.0);
        float sky = 0.5 + (0.5 * nor.y);
        vec2 param_11 = pos.xz * 0.100000001490116119384765625;
        float _660 = lava(param_11);
        float lav = (smoothstep(0.5, 0.550000011920928955078125, _660) * hh) * clamp(0.5 - (0.5 * nor.y), 0.0, 1.0);
        vec3 param_12 = pos * vec3(0.800000011920928955078125, 1.0, 0.800000011920928955078125);
        float _674 = displacement(param_12);
        float occ = pow(((1.0 - _674) * 1.60000002384185791015625) - 0.5, 2.0);
        float amb = 1.0;
        col = vec3(0.800000011920928955078125);
        vec3 lin = vec3(0.0);
        lin += ((vec3(1.7999999523162841796875, 1.269999980926513671875, 0.9900000095367431640625) * (1.39999997615814208984375 * sun)) * pow(vec3(sha), vec3(1.0, 1.2000000476837158203125, 1.5)));
        lin += ((vec3(0.1599999964237213134765625, 0.20000000298023223876953125, 0.4000000059604644775390625) * (0.89999997615814208984375 * sky)) * occ);
        lin += ((vec3(0.4000000059604644775390625, 0.2800000011920928955078125, 0.20000000298023223876953125) * (0.89999997615814208984375 * bac)) * occ);
        lin += ((vec3(0.1500000059604644775390625, 0.17000000178813934326171875, 0.20000000298023223876953125) * (0.89999997615814208984375 * amb)) * occ);
        lin += (vec3(3.0, 0.61000001430511474609375, 0.0) * lav);
        col = vec3(0.5);
        vec3 verde = vec3(1.0, 0.89999997615814208984375, 0.20000000298023223876953125);
        col = mix(col, verde * 0.800000011920928955078125, vec3(hh));
        float vv = smoothstep(0.0, 0.800000011920928955078125, nor.y) * smoothstep(0.0, 0.100000001490116119384765625, pos.y - 0.800000011920928955078125);
        verde = vec3(0.20000000298023223876953125, 0.449999988079071044921875, 0.100000001490116119384765625);
        verde += vec3(0.20000000298023223876953125);
        vv *= 0.5;
        col = mix(col, verde * 1.10000002384185791015625, vec3(vv));
        col = lin * col;
    }
    color.w = 1.0;
    color.x = col.x;
    color.y = col.y;
    color.z = col.z;
    return t;
}

void main()
{
    lig = vec3(-0.348742902278900146484375, 0.464990556240081787109375, 0.81373345851898193359375);
    MaterialPropertiesGPU _1023;
    _1023.diffuse = materials.material_properties[_1015.materialIndex].diffuse;
    _1023.transparency = materials.material_properties[_1015.materialIndex].transparency;
    _1023.emissive = materials.material_properties[_1015.materialIndex].emissive;
    _1023.roughness = materials.material_properties[_1015.materialIndex].roughness;
    _1023.triplanar_factor = materials.material_properties[_1015.materialIndex].triplanar_factor;
    _1023.refraction = materials.material_properties[_1015.materialIndex].refraction;
    _1023.normal_factor = materials.material_properties[_1015.materialIndex].normal_factor;
    _1023.emissive_factor = materials.material_properties[_1015.materialIndex].emissive_factor;
    _1023.temporal_accumulation_factor = materials.material_properties[_1015.materialIndex].temporal_accumulation_factor;
    _1023.shadowmap_bias = materials.material_properties[_1015.materialIndex].shadowmap_bias;
    _1023.metalness = materials.material_properties[_1015.materialIndex].metalness;
    _1023.albedo_sampler = materials.material_properties[_1015.materialIndex].albedo_sampler;
    _1023.emissive_sampler = materials.material_properties[_1015.materialIndex].emissive_sampler;
    _1023.normal_sampler = materials.material_properties[_1015.materialIndex].normal_sampler;
    _1023.metalic_roughness_sampler = materials.material_properties[_1015.materialIndex].metalic_roughness_sampler;
    _1023.flags = materials.material_properties[_1015.materialIndex].flags;
    _1023._pad0 = materials.material_properties[_1015.materialIndex]._pad0;
    _1023._pad1 = materials.material_properties[_1015.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1023;
    vec4 outAlbedo = vec4(1.0);
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_1041.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1051.instance_transform[(instanceID * uint(_1041.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1051.instance_transform[(instanceID * uint(_1041.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1051.instance_transform[(instanceID * uint(_1041.instance_params.stride)) + 2u];
        vec3 _1087 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1087.x;
        mat_instance_model[0].y = _1087.y;
        mat_instance_model[0].z = _1087.z;
        vec3 _1100 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1100.x;
        mat_instance_model[1].y = _1100.y;
        mat_instance_model[1].z = _1100.z;
        vec3 _1113 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1113.x;
        mat_instance_model[2].y = _1113.y;
        mat_instance_model[2].z = _1113.z;
        vec3 _1126 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1126.x;
        mat_instance_model[3].y = _1126.y;
        mat_instance_model[3].z = _1126.z;
    }
    vec3 instance_function_origin = _1137.raymarch_params.function_origin;
    if (_1137.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_1137.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _1160.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vWorldPos, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_1160.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    ro *= _1137.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_1137.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_1 = ro_bounding_volume;
        vec3 param_2 = rd;
        vec3 param_3 = _1137.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_1, param_2, param_3);
    }
    vec3 param_4 = ro;
    vec3 param_5 = rd;
    float param_6 = bounding_volume_intersection;
    vec4 param_7;
    float _1328 = calcIntersection(param_4, param_5, param_6, param_7);
    color = param_7;
    float intersection = _1328;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        ri -= instance_function_origin;
        ri /= _1137.raymarch_params.function_scale;
        ri = ((_1160.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        outAlbedo.x = 0.100000001490116119384765625;
        outAlbedo.y = 0.100000001490116119384765625;
        outAlbedo.z = 0.100000001490116119384765625;
        if (true)
        {
            float near = -1.0;
            float far = 1.0;
            float depth = (_1160.transform_params.mProjection * vec4(ri, 1.0)).z / (_1160.transform_params.mProjection * vec4(ri, 1.0)).w;
            depth = ((((far - near) * depth) + near) + far) / 2.0;
            gl_FragDepth = depth;
        }
    }
    else
    {
        if (_1137.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _1421 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _1421.x;
            outAlbedo.y = _1421.y;
            outAlbedo.z = _1421.z;
        }
        else
        {
            discard;
        }
    }
}

 