#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct LTCRect
{
    vec3 center;
    vec3 dirx;
    vec3 diry;
    float halfx;
    float halfy;
    vec4 plane;
};

struct IBLOutput
{
    vec3 color_weighted;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct VoxelizationDispatchParams
{
    int lights_num;
    uint component_tags;
    float env_map_intensity;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

layout(set = 1, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _206;

layout(set = 1, binding = 2, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _232;

layout(set = 1, binding = 3, std430) buffer VoxelLightBuffer
{
    uint in_voxel_light_data[];
} _300;

layout(set = 1, binding = 4, std430) buffer VoxelOcclusionBuffer
{
    uint in_voxel_occlusion_data[];
} _316;

layout(set = 1, binding = 5, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 6, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 7, std140) uniform VoxelizationDispatchParamsBuffer
{
    VoxelizationDispatchParams dispatch_params;
} _2777;

layout(set = 1, binding = 8, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 9) uniform sampler2D s_LTC2;
layout(set = 1, binding = 10) uniform samplerCube sEnviromentMap;
layout(set = 1, binding = 11) uniform sampler2D material_textures[128];
layout(set = 1, binding = 139) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 1, binding = 155) uniform sampler2D LightProjectorSamplers[16];

layout(location = 0) flat in int vOrientationIndex;
layout(location = 5) flat in uint vTriIndex[3];
layout(location = 1) in vec3 vGridCoords;
layout(location = 3) flat in vec3 vTriNormal;
layout(location = 8) in vec4 vColor;
layout(location = 2) in vec2 vUV0;
layout(location = 4) flat in vec3 vTriNormalForLighting;
bool twoSided;
bool clipless;

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_206.in_vtx_data[coord_offset + 0u], _206.in_vtx_data[coord_offset + 1u], _206.in_vtx_data[coord_offset + 2u]);
    return p;
}

uint build_step_dir()
{
    if (vOrientationIndex == 0)
    {
        return 1u;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            return 2u;
        }
        else
        {
            return 4u;
        }
    }
}

ivec3 unpack_step_dir(uint step_dir)
{
    return ivec3(int((step_dir & 1u) != 0u), int((step_dir & 2u) != 0u), int((step_dir & 4u) != 0u));
}

int planeBoxOverlap(vec3 normal, vec3 vert, vec3 maxbox)
{
    vec3 s = step(vec3(0.0), normal);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 vmin = ((-sgn) * maxbox) - vert;
    vec3 vmax = (sgn * maxbox) - vert;
    if (dot(normal, vmin) > 0.0)
    {
        return 0;
    }
    if (dot(normal, vmax) >= 0.0)
    {
        return 1;
    }
    return 0;
}

int triBoxOverlap(vec3 boxcenter, vec3 boxhalfsize, vec3 tv0, vec3 tv1, vec3 tv2, vec3 normal)
{
    vec3 v0 = tv0 - boxcenter;
    vec3 v1 = tv1 - boxcenter;
    vec3 v2 = tv2 - boxcenter;
    vec3 e0 = v1 - v0;
    vec3 e1 = v2 - v1;
    vec3 e2 = v0 - v2;
    float fex = abs(e0.x);
    float fey = abs(e0.y);
    float fez = abs(e0.z);
    float p0 = (e0.z * v0.y) - (e0.y * v0.z);
    float p2 = (e0.z * v2.y) - (e0.y * v2.z);
    float mi;
    float ma;
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    float rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _703 = mi > rad;
    bool _711;
    if (!_703)
    {
        _711 = ma < (-rad);
    }
    else
    {
        _711 = _703;
    }
    if (_711)
    {
        return 0;
    }
    p0 = ((-e0.z) * v0.x) + (e0.x * v0.z);
    p2 = ((-e0.z) * v2.x) + (e0.x * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _760 = mi > rad;
    bool _768;
    if (!_760)
    {
        _768 = ma < (-rad);
    }
    else
    {
        _768 = _760;
    }
    if (_768)
    {
        return 0;
    }
    float p1 = (e0.y * v1.x) - (e0.x * v1.y);
    p2 = (e0.y * v2.x) - (e0.x * v2.y);
    if (p2 < p1)
    {
        mi = p2;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p2;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _816 = mi > rad;
    bool _824;
    if (!_816)
    {
        _824 = ma < (-rad);
    }
    else
    {
        _824 = _816;
    }
    if (_824)
    {
        return 0;
    }
    fex = abs(e1.x);
    fey = abs(e1.y);
    fez = abs(e1.z);
    p0 = (e1.z * v0.y) - (e1.y * v0.z);
    p2 = (e1.z * v2.y) - (e1.y * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _880 = mi > rad;
    bool _888;
    if (!_880)
    {
        _888 = ma < (-rad);
    }
    else
    {
        _888 = _880;
    }
    if (_888)
    {
        return 0;
    }
    p0 = ((-e1.z) * v0.x) + (e1.x * v0.z);
    p2 = ((-e1.z) * v2.x) + (e1.x * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _937 = mi > rad;
    bool _945;
    if (!_937)
    {
        _945 = ma < (-rad);
    }
    else
    {
        _945 = _937;
    }
    if (_945)
    {
        return 0;
    }
    p0 = (e1.y * v0.x) - (e1.x * v0.y);
    p1 = (e1.y * v1.x) - (e1.x * v1.y);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _992 = mi > rad;
    bool _1000;
    if (!_992)
    {
        _1000 = ma < (-rad);
    }
    else
    {
        _1000 = _992;
    }
    if (_1000)
    {
        return 0;
    }
    fex = abs(e2.x);
    fey = abs(e2.y);
    fez = abs(e2.z);
    p0 = (e2.z * v0.y) - (e2.y * v0.z);
    p1 = (e2.z * v1.y) - (e2.y * v1.z);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _1056 = mi > rad;
    bool _1064;
    if (!_1056)
    {
        _1064 = ma < (-rad);
    }
    else
    {
        _1064 = _1056;
    }
    if (_1064)
    {
        return 0;
    }
    p0 = ((-e2.z) * v0.x) + (e2.x * v0.z);
    p1 = ((-e2.z) * v1.x) + (e2.x * v1.z);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _1113 = mi > rad;
    bool _1121;
    if (!_1113)
    {
        _1121 = ma < (-rad);
    }
    else
    {
        _1121 = _1113;
    }
    if (_1121)
    {
        return 0;
    }
    p1 = (e2.y * v1.x) - (e2.x * v1.y);
    p2 = (e2.y * v2.x) - (e2.x * v2.y);
    if (p2 < p1)
    {
        mi = p2;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p2;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _1168 = mi > rad;
    bool _1176;
    if (!_1168)
    {
        _1176 = ma < (-rad);
    }
    else
    {
        _1176 = _1168;
    }
    if (_1176)
    {
        return 0;
    }
    vec3 mi3 = min(v0, min(v1, v2));
    vec3 ma3 = max(v0, max(v1, v2));
    bool _1197 = any(greaterThan(mi3, boxhalfsize));
    bool _1206;
    if (!_1197)
    {
        _1206 = any(lessThan(ma3, -boxhalfsize));
    }
    else
    {
        _1206 = _1197;
    }
    bool no_overlap = _1206;
    if (no_overlap)
    {
        return 0;
    }
    vec3 param = normal;
    vec3 param_1 = v0;
    vec3 param_2 = boxhalfsize;
    return planeBoxOverlap(param, param_1, param_2);
}

bool checkTriCellOverlap(vec3 p0, vec3 p1, vec3 p2, vec3 normal, vec3 ccenter, vec3 csize)
{
    vec3 param = ccenter;
    vec3 param_1 = csize;
    vec3 param_2 = p0;
    vec3 param_3 = p1;
    vec3 param_4 = p2;
    vec3 param_5 = normal;
    return triBoxOverlap(param, param_1, param_2, param_3, param_4, param_5) != 0;
}

uint rt_calculate_grid_cell_idx(uint cx, uint cy, uint cz)
{
    return (cx + (cy * 256u)) + ((cz * 256u) * 256u);
}

void rt_store_voxel_occlusion(uint cx, uint cy, uint cz, float v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    uint _323 = atomicMax(_316.in_voxel_occlusion_data[idx], uint(v * 1024.0));
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_232.transformed_data_faces[idx].material_idx);
    return p;
}

vec3 calculate_lighting_world(LightProperties light, vec3 pos, vec3 normal, vec3 light_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    return vec3(d);
}

float sampleShadowPCF(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, int samples, float sampling_range)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _339 = coords.x < (-coords.w);
    bool _348;
    if (!_339)
    {
        _348 = coords.x > coords.w;
    }
    else
    {
        _348 = _339;
    }
    bool _358;
    if (!_348)
    {
        _358 = coords.y < (-coords.w);
    }
    else
    {
        _358 = _348;
    }
    bool _367;
    if (!_358)
    {
        _367 = coords.y > coords.w;
    }
    else
    {
        _367 = _358;
    }
    bool _374;
    if (!_367)
    {
        _374 = coords.z < 0.0;
    }
    else
    {
        _374 = _367;
    }
    if (_374)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _378 = coords;
    float _384 = coords.w;
    vec2 _386 = (_378.xy * vec2(0.5)) + (vec2(0.5) * _384);
    coords.x = _386.x;
    coords.y = _386.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    float sampling_r = 1.0;
    float _417 = -sampling_r;
    float y = _417;
    int iy = 0;
    for (; iy < samples; iy++, y += ((2.0 * sampling_r) / float(samples - 1)))
    {
        float _429 = -sampling_r;
        float x = _429;
        int ix = 0;
        for (; ix < samples; ix++, x += ((2.0 * sampling_r) / float(samples - 1)))
        {
            vec4 _455 = coords + vec4((x * sampling_range) * coords.w, (y * sampling_range) * coords.w, 0.0, 0.0);
            vec4 _458 = _455;
            _458.z = _455.w;
            float shadow = textureProjLod(smpl, vec4(_458.xy, _455.z, _458.z), 0.0);
            fact += shadow;
        }
    }
    float f = fact * (1.0 / float(samples * samples));
    return f;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float angle_falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    float attenuation = 0.0;
    bool _521 = angle_falloff > cutoff;
    bool _528;
    if (_521)
    {
        _528 = light_distance < light.range;
    }
    else
    {
        _528 = _521;
    }
    if (_528)
    {
        attenuation = 1.0 - ((1.0 - angle_falloff) / (1.0 - cutoff));
        attenuation = pow(attenuation, light.angular_falloff_power);
        float distance_attenuation = 1.0 - (light_distance / light.range);
        attenuation *= (distance_attenuation * distance_attenuation);
    }
    return attenuation;
}

vec4 sampleProjectorTexture(sampler2D smpl, inout vec4 coords)
{
    vec4 color = vec4(0.0);
    if (coords.w <= 0.0)
    {
        return color;
    }
    bool _2212 = coords.x < (-coords.w);
    bool _2221;
    if (!_2212)
    {
        _2221 = coords.x > coords.w;
    }
    else
    {
        _2221 = _2212;
    }
    bool _2231;
    if (!_2221)
    {
        _2231 = coords.y < (-coords.w);
    }
    else
    {
        _2231 = _2221;
    }
    bool _2240;
    if (!_2231)
    {
        _2240 = coords.y > coords.w;
    }
    else
    {
        _2240 = _2231;
    }
    if (_2240)
    {
        return color;
    }
    vec4 _2245 = coords;
    float _2249 = coords.w;
    vec2 _2251 = (_2245.xy * vec2(0.5)) + (vec2(0.5) * _2249);
    coords.x = _2251.x;
    coords.y = _2251.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    color = texture(smpl, coords.xy / vec2(coords.w));
    return color;
}

void InitRect(LightProperties light, inout LTCRect rect)
{
    rect.dirx = -light.right;
    rect.diry = light.up;
    rect.center = light.position;
    rect.halfx = 0.5 * light.dimensions.x;
    rect.halfy = 0.5 * light.dimensions.y;
    vec3 rectNormal = cross(rect.dirx, rect.diry);
    rect.plane = vec4(rectNormal, -dot(rectNormal, rect.center));
}

void InitRectPoints(LTCRect rect, inout vec3 points[4])
{
    vec3 ex = rect.dirx * rect.halfx;
    vec3 ey = rect.diry * rect.halfy;
    points[0] = (rect.center - ex) - ey;
    points[1] = (rect.center + ex) - ey;
    points[2] = (rect.center + ex) + ey;
    points[3] = (rect.center - ex) + ey;
}

mat3 mul(mat3 m1, mat3 m2)
{
    return m1 * m2;
}

vec3 mul(mat3 m, vec3 v)
{
    return m * v;
}

vec3 IntegrateEdgeVec(vec3 v1, vec3 v2)
{
    float x = dot(v1, v2);
    float y = abs(x);
    float a = 0.8543984889984130859375 + ((0.4965155124664306640625 + (0.01452060043811798095703125 * y)) * y);
    float b = 3.41759395599365234375 + ((4.1616725921630859375 + y) * y);
    float v = a / b;
    float _1278;
    if (x > 0.0)
    {
        _1278 = v;
    }
    else
    {
        _1278 = (0.5 * inversesqrt(max(1.0 - (x * x), 1.0000000116860974230803549289703e-07))) - v;
    }
    float theta_sintheta = _1278;
    return cross(v1, v2) * theta_sintheta;
}

void ClipQuadToHorizon(inout vec3 L[5], inout int n)
{
    int config = 0;
    if (L[0].z > 0.0)
    {
        config++;
    }
    if (L[1].z > 0.0)
    {
        config += 2;
    }
    if (L[2].z > 0.0)
    {
        config += 4;
    }
    if (L[3].z > 0.0)
    {
        config += 8;
    }
    n = 0;
    if (config == 0)
    {
    }
    else
    {
        if (config == 1)
        {
            n = 3;
            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
            L[2] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
        }
        else
        {
            if (config == 2)
            {
                n = 3;
                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
            }
            else
            {
                if (config == 3)
                {
                    n = 4;
                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                    L[3] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                }
                else
                {
                    if (config == 4)
                    {
                        n = 3;
                        L[0] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                    }
                    else
                    {
                        if (config == 5)
                        {
                            n = 0;
                        }
                        else
                        {
                            if (config == 6)
                            {
                                n = 4;
                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                            }
                            else
                            {
                                if (config == 7)
                                {
                                    n = 5;
                                    L[4] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                                    L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                                }
                                else
                                {
                                    if (config == 8)
                                    {
                                        n = 3;
                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                        L[1] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        L[2] = L[3];
                                    }
                                    else
                                    {
                                        if (config == 9)
                                        {
                                            n = 4;
                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                            L[2] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        }
                                        else
                                        {
                                            if (config == 10)
                                            {
                                                n = 0;
                                            }
                                            else
                                            {
                                                if (config == 11)
                                                {
                                                    n = 5;
                                                    L[4] = L[3];
                                                    L[3] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                                                }
                                                else
                                                {
                                                    if (config == 12)
                                                    {
                                                        n = 4;
                                                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                    }
                                                    else
                                                    {
                                                        if (config == 13)
                                                        {
                                                            n = 5;
                                                            L[4] = L[3];
                                                            L[3] = L[2];
                                                            L[2] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                                        }
                                                        else
                                                        {
                                                            if (config == 14)
                                                            {
                                                                n = 5;
                                                                L[4] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                                            }
                                                            else
                                                            {
                                                                if (config == 15)
                                                                {
                                                                    n = 4;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (n == 3)
    {
        L[3] = L[0];
    }
    if (n == 4)
    {
        L[4] = L[0];
    }
}

float IntegrateEdge(vec3 v1, vec3 v2)
{
    vec3 param = v1;
    vec3 param_1 = v2;
    return IntegrateEdgeVec(param, param_1).z;
}

vec3 LTC_Evaluate_DiffuseOnly(vec3 N, vec3 P, inout mat3 Minv, vec3 points[4], bool twoSided_1)
{
    vec3 V = vec3(0.0, 0.0, 1.0);
    vec3 T1 = normalize(V - (N * dot(V, N)));
    vec3 T2 = cross(N, T1);
    mat3 param = Minv;
    mat3 param_1 = transpose(mat3(vec3(T1), vec3(T2), vec3(N)));
    Minv = mul(param, param_1);
    mat3 param_2 = Minv;
    vec3 param_3 = points[0] - P;
    vec3 L[5];
    L[0] = mul(param_2, param_3);
    mat3 param_4 = Minv;
    vec3 param_5 = points[1] - P;
    L[1] = mul(param_4, param_5);
    mat3 param_6 = Minv;
    vec3 param_7 = points[2] - P;
    L[2] = mul(param_6, param_7);
    mat3 param_8 = Minv;
    vec3 param_9 = points[3] - P;
    L[3] = mul(param_8, param_9);
    float sum = 0.0;
    if (clipless)
    {
        vec3 dir = points[0] - P;
        vec3 lightNormal = cross(points[1] - points[0], points[3] - points[0]);
        bool behind = dot(dir, lightNormal) < 0.0;
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        vec3 vsum = vec3(0.0);
        vec3 param_10 = L[0];
        vec3 param_11 = L[1];
        vsum += IntegrateEdgeVec(param_10, param_11);
        vec3 param_12 = L[1];
        vec3 param_13 = L[2];
        vsum += IntegrateEdgeVec(param_12, param_13);
        vec3 param_14 = L[2];
        vec3 param_15 = L[3];
        vsum += IntegrateEdgeVec(param_14, param_15);
        vec3 param_16 = L[3];
        vec3 param_17 = L[0];
        vsum += IntegrateEdgeVec(param_16, param_17);
        float len = length(vsum);
        float z = vsum.z / len;
        if (behind)
        {
            z = -z;
        }
        vec2 uv = vec2((z * 0.5) + 0.5, len);
        uv = (uv * 0.984375) + vec2(0.0078125);
        float scale = texture(s_LTC2, uv).w;
        sum = len * scale;
        if (behind && (!twoSided_1))
        {
            sum = 0.0;
        }
    }
    else
    {
        vec3 param_18[5] = L;
        int param_19;
        ClipQuadToHorizon(param_18, param_19);
        L = param_18;
        int n = param_19;
        if (n == 0)
        {
            return vec3(0.0);
        }
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        L[4] = normalize(L[4]);
        vec3 param_20 = L[0];
        vec3 param_21 = L[1];
        sum += IntegrateEdge(param_20, param_21);
        vec3 param_22 = L[1];
        vec3 param_23 = L[2];
        sum += IntegrateEdge(param_22, param_23);
        vec3 param_24 = L[2];
        vec3 param_25 = L[3];
        sum += IntegrateEdge(param_24, param_25);
        if (n >= 4)
        {
            vec3 param_26 = L[3];
            vec3 param_27 = L[4];
            sum += IntegrateEdge(param_26, param_27);
        }
        if (n == 5)
        {
            vec3 param_28 = L[4];
            vec3 param_29 = L[0];
            sum += IntegrateEdge(param_28, param_29);
        }
        float _2046;
        if (twoSided_1)
        {
            _2046 = abs(sum);
        }
        else
        {
            _2046 = max(0.0, sum);
        }
        sum = _2046;
    }
    vec3 Lo_i = vec3(sum, sum, sum);
    return Lo_i;
}

float light_calculate_area_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0 - clamp(light_distance / light.range, 0.0, 1.0);
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

IBLOutput ibl(vec3 n, vec3 diffuseColor)
{
    vec3 diffuseLight = textureLod(sEnviromentMap, n, 5.0).xyz;
    IBLOutput ibl_1;
    ibl_1.color_weighted = diffuseColor * diffuseLight;
    return ibl_1;
}

void rt_store_voxel_color_emissive(uint cx, uint cy, uint cz, inout vec4 v)
{
    uint param = cx;
    uint param_1 = cy;
    uint param_2 = cz;
    uint idx = rt_calculate_grid_cell_idx(param, param_1, param_2);
    float v_mag = ceil(length(v.xyz));
    vec4 _254 = v;
    vec3 _258 = _254.xyz / vec3(v_mag);
    v.x = _258.x;
    v.y = _258.y;
    v.z = _258.z;
    v_mag = min(127.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    vi |= 2147483648u;
    uint _304 = atomicMax(_300.in_voxel_light_data[idx], vi);
}

void main()
{
    twoSided = false;
    clipless = false;
    vec3 bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_voxelize.xyz;
    uint param = vTriIndex[0];
    vec3 vTriCoords[3];
    vTriCoords[0] = rt_get_vertex(param);
    uint param_1 = vTriIndex[1];
    vTriCoords[1] = rt_get_vertex(param_1);
    uint param_2 = vTriIndex[2];
    vTriCoords[2] = rt_get_vertex(param_2);
    vec3 s = -bbox_origin;
    vTriCoords[0] += s;
    vTriCoords[1] += s;
    vTriCoords[2] += s;
    vec3 f = vec3(1.0) / bbox_grid_size;
    vTriCoords[0] *= f;
    vTriCoords[1] *= f;
    vTriCoords[2] *= f;
    vec3 pos = vGridCoords;
    vec3 gc = (gl_FragCoord.xyz / vec3(1.0, 1.0, 0.00390625)) + vec3(0.0);
    gc.y = 255.5 - gc.y;
    gc.z = (gc.z * 0.5) + 128.0;
    ivec3 mi = ivec3(floor(min(vTriCoords[0], min(vTriCoords[1], vTriCoords[2]))));
    ivec3 ma = ivec3(ceil(max(vTriCoords[0], max(vTriCoords[1], vTriCoords[2]))));
    mi = clamp(mi, ivec3(0), ivec3(255));
    ma = clamp(ma, ivec3(0), ivec3(255));
    uint stepDir = 0u;
    uvec3 stepStart = uvec3(0u);
    uint cy;
    uint cz;
    uint cx;
    int steps;
    if (vOrientationIndex == 0)
    {
        cy = uint(gc.x);
        cz = uint(gc.y);
        cx = uint(gc.z);
        stepStart = uvec3(uint(mi.x), cy, cz);
        steps = ma.x - mi.x;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            cz = uint(gc.x);
            cx = uint(gc.y);
            cy = uint(gc.z);
            stepStart = uvec3(cx, uint(mi.y), cz);
            steps = ma.y - mi.y;
        }
        else
        {
            cx = uint(gc.x);
            cy = uint(gc.y);
            cz = uint(gc.z);
            stepStart = uvec3(cx, cy, uint(mi.z));
            steps = ma.z - mi.z;
        }
    }
    stepDir = build_step_dir();
    int stepMin = -1;
    int stepCount = 0;
    for (int s_1 = 0; s_1 < steps; s_1++)
    {
        uint param_3 = stepDir;
        uvec3 cc = stepStart + uvec3(unpack_step_dir(param_3) * ivec3(s_1));
        vec3 cellPos = vec3(cc);
        vec3 cellSize = vec3(1.0);
        vec3 param_4 = vTriCoords[0];
        vec3 param_5 = vTriCoords[1];
        vec3 param_6 = vTriCoords[2];
        vec3 param_7 = vTriNormal;
        vec3 param_8 = cellPos + (cellSize * 0.5);
        vec3 param_9 = cellSize * 0.5;
        if (checkTriCellOverlap(param_4, param_5, param_6, param_7, param_8, param_9))
        {
            if (stepMin == (-1))
            {
                stepMin = s_1;
            }
            if (true)
            {
                float d = -dot(vTriNormal, vTriCoords[0]);
                float _distance = dot(vTriNormal, cellPos + (cellSize * 0.5)) + d;
                uint param_10 = cc.x;
                uint param_11 = cc.y;
                uint param_12 = cc.z;
                float param_13 = 1.0 - clamp(0.5 + _distance, 0.0, 1.0);
                rt_store_voxel_occlusion(param_10, param_11, param_12, param_13);
                if (vOrientationIndex == 0)
                {
                    cc.x = uint(clamp(float(int(cc.x)) - sign(vTriNormal.x), 0.0, 255.0));
                }
                else
                {
                    if (vOrientationIndex == 1)
                    {
                        cc.y = uint(clamp(float(int(cc.y)) - sign(vTriNormal.y), 0.0, 255.0));
                    }
                    else
                    {
                        if (vOrientationIndex == 2)
                        {
                            cc.z = uint(clamp(float(int(cc.z)) - sign(vTriNormal.z), 0.0, 255.0));
                        }
                    }
                }
                uint param_14 = cc.x;
                uint param_15 = cc.y;
                uint param_16 = cc.z;
                float param_17 = 1.0;
                rt_store_voxel_occlusion(param_14, param_15, param_16, param_17);
            }
            stepCount++;
        }
    }
    if (stepCount == 0)
    {
        return;
    }
    uint param_18 = stepDir;
    stepStart += uvec3(unpack_step_dir(param_18) * ivec3(stepMin));
    vec3 voxel_color = vec3(0.0);
    uint param_19 = uint(gl_PrimitiveID);
    int materialIndex = rt_get_triangle_material(param_19);
    MaterialPropertiesGPU _2679;
    _2679.diffuse = materials.material_properties[materialIndex].diffuse;
    _2679.transparency = materials.material_properties[materialIndex].transparency;
    _2679.emissive = materials.material_properties[materialIndex].emissive;
    _2679.roughness = materials.material_properties[materialIndex].roughness;
    _2679.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
    _2679.refraction = materials.material_properties[materialIndex].refraction;
    _2679.normal_factor = materials.material_properties[materialIndex].normal_factor;
    _2679.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
    _2679.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
    _2679.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
    _2679.metalness = materials.material_properties[materialIndex].metalness;
    _2679.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
    _2679.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
    _2679.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
    _2679.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
    _2679.flags = materials.material_properties[materialIndex].flags;
    _2679._pad0 = materials.material_properties[materialIndex]._pad0;
    _2679._pad1 = materials.material_properties[materialIndex]._pad1;
    MaterialPropertiesGPU material = _2679;
    float roughness = material.roughness;
    vec3 world = (vec3(stepStart) * in_bbox_data.grid_size_voxelize.xyz) + in_bbox_data.bbox_voxelize_min.xyz;
    vec3 pplane = (vTriCoords[0] * in_bbox_data.grid_size_voxelize.xyz) + in_bbox_data.bbox_voxelize_min.xyz;
    world = (world - (vTriNormal * dot(world - pplane, vTriNormal))) + (vTriNormal * 0.20000000298023223876953125);
    vec3 base_albedo = vColor.xyz;
    vec3 base_emissive = vec3(1.0);
    bool _2725 = material.albedo_sampler >= 0;
    bool _2731;
    if (_2725)
    {
        _2731 = material.albedo_sampler < 16;
    }
    else
    {
        _2731 = _2725;
    }
    if (_2731)
    {
        base_albedo *= textureLod(material_textures[material.albedo_sampler], vUV0, 2.0).xyz;
    }
    bool _2751 = material.emissive_sampler >= 0;
    bool _2757;
    if (_2751)
    {
        _2757 = material.emissive_sampler < 16;
    }
    else
    {
        _2757 = _2751;
    }
    if (_2757)
    {
        base_emissive = textureLod(material_textures[material.emissive_sampler], vUV0, 2.0).xyz;
    }
    float param_26;
    LTCRect param_33;
    vec3 param_35[4];
    for (int light_idx = 0; light_idx < _2777.dispatch_params.lights_num; light_idx++)
    {
        LightProperties _2795;
        _2795.diffuse = lights.light_properties[light_idx].diffuse;
        _2795.direction = lights.light_properties[light_idx].direction;
        _2795.position = lights.light_properties[light_idx].position;
        _2795.up = lights.light_properties[light_idx].up;
        _2795.right = lights.light_properties[light_idx].right;
        _2795.dimensions = lights.light_properties[light_idx].dimensions;
        _2795.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
        _2795.intensity = lights.light_properties[light_idx].intensity;
        _2795.range = lights.light_properties[light_idx].range;
        _2795.cutoff = lights.light_properties[light_idx].cutoff;
        _2795.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _2795.is_area = lights.light_properties[light_idx].is_area;
        _2795.type = lights.light_properties[light_idx].type;
        _2795.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _2795.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _2795.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
        _2795.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _2795.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _2795.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _2795.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _2795.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _2795.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _2795.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _2795.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _2795.angular_falloff_power = lights.light_properties[light_idx].angular_falloff_power;
        _2795.angular_falloff_color_gradient_idx = lights.light_properties[light_idx].angular_falloff_color_gradient_idx;
        _2795.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _2795.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _2795.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _2795.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _2795.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _2795.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _2795.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _2795.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _2795.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _2795;
        if ((light.lighting_exclusion_tags & _2777.dispatch_params.component_tags) != 0u)
        {
            continue;
        }
        if ((light.type & 256) != 0)
        {
            continue;
        }
        vec4 projector_color = vec4(0.0);
        vec3 pointToLight = light.position - world;
        if ((light.type & 1) != 0)
        {
            pointToLight = -light.direction;
        }
        float NdotL = dot(vTriNormalForLighting, normalize(pointToLight));
        LightProperties param_20 = light;
        vec3 param_21 = world;
        vec3 param_22 = vTriNormalForLighting;
        vec3 param_23 = light.position;
        float param_24 = NdotL;
        vec3 lighting = material.diffuse * calculate_lighting_world(param_20, param_21, param_22, param_23, param_24);
        float shadow = 0.0;
        if (NdotL <= 0.0)
        {
            shadow = 1.0;
        }
        else
        {
            bool _2862 = (material.flags & 512u) != 0u;
            bool _2869;
            if (_2862)
            {
                _2869 = (light.type & 8) != 0;
            }
            else
            {
                _2869 = _2862;
            }
            bool calculate_shadows = _2869;
            if (((light.type & 3) != 0) && calculate_shadows)
            {
                float penumbra_scaling_factor = 0.5;
                vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                float penumbraSampleNoise = 0.0;
                float penumbra = 0.5;
                float in_frustum = 0.0;
                vec4 param_25 = vShadowCoords;
                int param_27 = 3;
                float param_28 = (((penumbra_scaling_factor * roughness) * penumbra) * light.roughness_modifier) / 1024.0;
                float _2913 = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_25, param_26, param_27, param_28);
                in_frustum = param_26;
                shadow = _2913;
            }
        }
        lighting = (lighting * light.diffuse.xyz) * light.intensity;
        lighting *= (1.0 - shadow);
        if ((light.type & 130) == 130)
        {
            LightProperties param_29 = light;
            vec3 param_30 = world;
            float attenuation = light_calculate_spot_attenuation(param_29, param_30);
            lighting *= attenuation;
            if ((light.type & 16) != 0)
            {
                vec4 vShadowCoords_1 = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                vec4 param_31 = vShadowCoords_1;
                vec4 _2967 = sampleProjectorTexture(LightProjectorSamplers[light.projector_sampler], param_31);
                vec3 projector_color_1 = _2967.xyz * light.projector_intensity;
                lighting *= projector_color_1;
            }
        }
        if (light.is_area != 0)
        {
            LightProperties param_32 = light;
            InitRect(param_32, param_33);
            LTCRect rect = param_33;
            LTCRect param_34 = rect;
            InitRectPoints(param_34, param_35);
            vec3 points[4] = param_35;
            float ltc_roughness = roughness;
            float ltc_intensity = light.intensity;
            vec3 lcol = vec3(ltc_intensity);
            vec3 dcol = light.diffuse.xyz;
            vec3 col = vec3(0.0);
            vec3 pos_1 = world;
            vec3 N = vTriNormal;
            vec3 param_36 = N;
            vec3 param_37 = pos_1;
            mat3 param_38 = mat3(vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0));
            vec3 param_39[4] = points;
            bool param_40 = twoSided;
            vec3 _3022 = LTC_Evaluate_DiffuseOnly(param_36, param_37, param_38, param_39, param_40);
            vec3 diff = _3022;
            col = lcol * (dcol * diff);
            if ((light.type & 128) == 128)
            {
                LightProperties param_41 = light;
                vec3 param_42 = world;
                float attenuation_1 = light_calculate_area_attenuation(param_41, param_42);
                col *= attenuation_1;
            }
            lighting = col;
        }
        voxel_color += vec3(lighting);
    }
    voxel_color *= base_albedo;
    voxel_color += ((material.emissive * base_emissive) * material.emissive_factor);
    vec3 f0 = vec3(0.039999999105930328369140625);
    float metalness = 0.5;
    vec3 diffuseColor = (base_albedo * (vec3(1.0) - f0)) * (1.0 - metalness);
    vec3 param_43 = vTriNormalForLighting;
    vec3 param_44 = diffuseColor;
    IBLOutput ibl_1 = ibl(param_43, param_44);
    voxel_color += (ibl_1.color_weighted * _2777.dispatch_params.env_map_intensity);
    for (;;)
    {
        int _3097 = stepCount;
        int _3098 = _3097 - 1;
        stepCount = _3098;
        if (_3097 > 0)
        {
            uint ccx = stepStart.x;
            uint ccy = stepStart.y;
            uint ccz = stepStart.z;
            if (false)
            {
                uvec3 cc_1 = uvec3(ccx, ccy, ccz);
                vec3 cellPos_1 = vec3(float(cc_1.x), float(cc_1.y), float(cc_1.z));
                vec3 cellSize_1 = vec3(1.0);
                float d_1 = -dot(vTriNormal, vTriCoords[0]);
                float _distance_1 = dot(vTriNormal, cellPos_1 + (cellSize_1 * 0.5)) + d_1;
                float fractional_occlusion = 1.0 - clamp(0.5 + _distance_1, 0.0, 1.0);
                uint param_45 = cc_1.x;
                uint param_46 = cc_1.y;
                uint param_47 = cc_1.z;
                float param_48 = fractional_occlusion;
                rt_store_voxel_occlusion(param_45, param_46, param_47, param_48);
                if (vOrientationIndex == 0)
                {
                    cc_1.x = uint(clamp(float(int(cc_1.x)) - sign(vTriNormal.x), 0.0, 255.0));
                }
                else
                {
                    if (vOrientationIndex == 1)
                    {
                        cc_1.y = uint(clamp(float(int(cc_1.y)) - sign(vTriNormal.y), 0.0, 255.0));
                    }
                    else
                    {
                        if (vOrientationIndex == 2)
                        {
                            cc_1.z = uint(clamp(float(int(cc_1.z)) - sign(vTriNormal.z), 0.0, 255.0));
                        }
                    }
                }
                uint param_49 = cc_1.x;
                uint param_50 = cc_1.y;
                uint param_51 = cc_1.z;
                float param_52 = 1.0;
                rt_store_voxel_occlusion(param_49, param_50, param_51, param_52);
            }
            uint param_53 = ccx;
            uint param_54 = ccy;
            uint param_55 = ccz;
            vec4 param_56 = vec4(voxel_color, 1.0);
            rt_store_voxel_color_emissive(param_53, param_54, param_55, param_56);
            if (vOrientationIndex == 0)
            {
                ccx = uint(clamp(float(int(ccx)) - sign(vTriNormal.x), 0.0, 255.0));
            }
            else
            {
                if (vOrientationIndex == 1)
                {
                    ccy = uint(clamp(float(int(ccy)) - sign(vTriNormal.y), 0.0, 255.0));
                }
                else
                {
                    if (vOrientationIndex == 2)
                    {
                        ccz = uint(clamp(float(int(ccz)) - sign(vTriNormal.z), 0.0, 255.0));
                    }
                }
            }
            uint param_57 = stepDir;
            stepStart += uvec3(unpack_step_dir(param_57));
            continue;
        }
        else
        {
            break;
        }
    }
}

 