#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct VXFogParams
{
    float average_position_factor;
    float average_normals_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    float scattering_factor;
    float sampling_mip;
    float trace_step;
    int filter_step;
    vec3 noise_offset;
    float absorbtion_factor;
    vec3 tint_color;
    float noise_base;
    float noise_strength;
    float accumulation_factor;
};

const uvec2 _972[4] = uvec2[](uvec2(0u), uvec2(0u, 1u), uvec2(1u, 0u), uvec2(1u));

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 2, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _364;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 3, std140) uniform VoxelFogParams
{
    VXFogParams voxel_lighting_setup;
} _571;

layout(set = 0, binding = 4, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1080;

layout(set = 0, binding = 8) uniform sampler2D s_NoiseRGBA;
layout(set = 0, binding = 9) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 0, binding = 10) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 5, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 11) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 6, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 12) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 7, rgba16f) uniform writeonly image2D imTarget;

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _201;
    if (nor.x > 0.0)
    {
        _201 = -t;
    }
    else
    {
        _201 = t;
    }
    nor.x += _201;
    float _216;
    if (nor.y > 0.0)
    {
        _216 = -t;
    }
    else
    {
        _216 = t;
    }
    nor.y += _216;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

float linearizeDepth(float d)
{
    return _364.dispatch_setup.near_far_plane.z / ((_364.dispatch_setup.near_far_plane.y + _364.dispatch_setup.near_far_plane.x) - (d * _364.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_364.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

float noise_fast(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = (f * f) * (vec3(3.0) - (f * 2.0));
    vec2 uv = (p.xy + (vec2(37.0, 17.0) * p.z)) + f.xy;
    vec2 rg = textureLod(s_NoiseRGBA, (uv + vec2(0.5)) / vec2(256.0), 0.0).yx;
    return (mix(rg.x, rg.y, f.z) * 2.0) - 1.0;
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

vec4 evaluate_fog_new(ivec2 screen_pos, vec3 ro, vec3 rd, inout float t, float max_t, vec2 hash, int frame, vec3 noise_offset)
{
    vec3 grid_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 grid_size = in_bbox_data.grid_size_voxelize.xyz;
    int grid_res = 256;
    vec4 occlusion = vec4(0.0);
    float scatter_step = 0.5;
    vec3 param = rd;
    mat3 _472 = matrixFromVector(param);
    mat3 vec_space = _472;
    for (int i = 0; i < 16; i++)
    {
        vec3 p = ro + (rd * t);
        float noise_scale = 2.0;
        vec3 noise_p = (p + noise_offset) * noise_scale;
        vec3 param_1 = noise_p * 0.0024999999441206455230712890625;
        float n1 = 0.5 + noise_fast(param_1);
        vec3 param_2 = ((noise_p * 0.0024999999441206455230712890625) * 0.5) + vec3(0.1240999996662139892578125);
        float n2 = 0.5 + noise_fast(param_2);
        vec3 param_3 = ((noise_p * 0.0024999999441206455230712890625) * 0.25) + vec3(0.1240999996662139892578125);
        float n3 = 0.5 + noise_fast(param_3);
        vec4 r_occlusion = vec4(0.0);
        for (int j = 0; j < 2; j++)
        {
            float param_4 = fract(hash.y + (1.61803400516510009765625 * float(0 + (j * 53))));
            float param_5 = fract(hash.y + (1.61803400516510009765625 * float(0 + (j * 53))));
            vec3 ird = CosineSampleHemisphere(param_4, param_5);
            ird = vec_space * ird;
            vec3 scatter_pos = ((ird * ((float(j) * scatter_step) + hash.x)) * _571.voxel_lighting_setup.scattering_factor) * 10.5;
            vec3 ip = p + scatter_pos;
            vec3 grid_p = (ip - grid_origin) / grid_size;
            vec3 sample_p = (grid_p + vec3(0.5)) / vec3(float(grid_res));
            float mip = max(0.0, (_571.voxel_lighting_setup.sampling_mip + hash.x) - 0.5);
            bool _607 = all(greaterThanEqual(sample_p, vec3(0.0)));
            bool _614;
            if (_607)
            {
                _614 = all(lessThan(sample_p, vec3(1.0)));
            }
            else
            {
                _614 = _607;
            }
            if (_614)
            {
                float go = textureLod(s_voxel_occupancy_filtered, sample_p, mip).x;
                vec3 gc = textureLod(s_voxel_colors_filtered, sample_p, mip).xyz;
                r_occlusion.w = min(1.0, r_occlusion.w + (go * _571.voxel_lighting_setup.absorbtion_factor));
                float _646 = r_occlusion.w;
                vec4 _649 = r_occlusion;
                vec3 _651 = _649.xyz + (gc * (1.0 - _646));
                r_occlusion.x = _651.x;
                r_occlusion.y = _651.y;
                r_occlusion.z = _651.z;
            }
        }
        r_occlusion /= vec4(2.0);
        float f = _571.voxel_lighting_setup.noise_base + (_571.voxel_lighting_setup.noise_strength * (((n1 * 0.100000001490116119384765625) + ((n2 * 0.100000001490116119384765625) * 0.25)) + (n3 * 0.120999999344348907470703125)));
        occlusion += ((r_occlusion * f) * 10.0);
        t += _571.voxel_lighting_setup.trace_step;
        if (t >= max_t)
        {
            break;
        }
    }
    return occlusion;
}

vec4 evaluate_fog(ivec2 screen_pos, vec3 ro, vec3 rd, float t, float max_t, vec2 hash, int frame, vec3 noise_offset)
{
    ivec2 param = screen_pos;
    vec3 param_1 = ro;
    vec3 param_2 = rd;
    float param_3 = t;
    float param_4 = max_t;
    vec2 param_5 = hash;
    int param_6 = frame;
    vec3 param_7 = noise_offset;
    vec4 _721 = evaluate_fog_new(param, param_1, param_2, param_3, param_4, param_5, param_6, param_7);
    return _721;
}

void main()
{
    float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    float param_9;
    float param_10;
    uint param_11;
    vec4 occlusion_all[4];
    for (int i = 0; i < 4; i++)
    {
        ivec2 pos = ivec2((pixel_pos * uvec2(2u)) + _972[i]);
        ivec2 noise_pos = pos & ivec2(127);
        uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
        uint param = encoded_normal_material;
        int materialId = decode_material(param);
        bool is_background = (materialId & 1) == 1;
        if (is_background)
        {
        }
        DispatchDeferredParams _1013;
        _1013.mat_projection = _364.dispatch_setup.mat_projection;
        _1013.mat_projection_previous = _364.dispatch_setup.mat_projection_previous;
        _1013.mat_model = _364.dispatch_setup.mat_model;
        _1013.mat_model_previous = _364.dispatch_setup.mat_model_previous;
        _1013.mat_view_inverse = _364.dispatch_setup.mat_view_inverse;
        _1013.mat_view_previous = _364.dispatch_setup.mat_view_previous;
        _1013.camera_position = _364.dispatch_setup.camera_position;
        _1013.camera_projection_params = _364.dispatch_setup.camera_projection_params;
        _1013.camera_projection_params_previous = _364.dispatch_setup.camera_projection_params_previous;
        _1013.near_far_plane = _364.dispatch_setup.near_far_plane;
        _1013.resolution = _364.dispatch_setup.resolution;
        _1013.inv_resolution = _364.dispatch_setup.inv_resolution;
        _1013.frustum_shift = _364.dispatch_setup.frustum_shift;
        DispatchDeferredParams param_1 = _1013;
        vec2 param_2 = vec2(pos);
        vec3 view_direction = deferred_get_view_direction_from_screen_pos(param_1, param_2);
        uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
        uint param_3 = encoded_normal_material_1;
        vec3 _1024 = decode_normal(param_3);
        vec3 vNorm = _1024;
        uint param_4 = encoded_normal_material_1;
        int materialId_1 = decode_material(param_4);
        float param_5 = texelFetch(sTextureDepth, pos, 0).x;
        float depth = linearizeDepth(param_5);
        vec3 param_6 = view_direction;
        float param_7 = depth;
        vec3 world = positionFromDepth(param_6, param_7);
        uvec2 param_8 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
        decode_metalness_roughness_material(param_8, param_9, param_10, param_11);
        float metalness = param_9;
        float roughness = param_10;
        uint material = param_11;
        vec3 dir = world - _364.dispatch_setup.camera_position;
        float max_t = length(dir);
        dir /= vec3(max_t);
        int frame = _1080.globals.monotonic;
        vec2 hash = texelFetch(s_BlueNoise, ivec3(noise_pos, frame & 15), 0).xy;
        vec3 ro = _364.dispatch_setup.camera_position;
        vec3 rd = dir;
        float t1 = 0.0 + (fract(hash.x) * _571.voxel_lighting_setup.trace_step);
        float t2 = 0.0 + (fract(hash.y) * _571.voxel_lighting_setup.trace_step);
        ivec2 param_12 = noise_pos;
        vec3 param_13 = ro;
        vec3 param_14 = rd;
        float param_15 = t1;
        float param_16 = max_t;
        vec2 param_17 = hash;
        int param_18 = frame;
        vec3 param_19 = _571.voxel_lighting_setup.noise_offset;
        vec4 occlusion = evaluate_fog(param_12, param_13, param_14, param_15, param_16, param_17, param_18, param_19);
        if (false)
        {
            vec3 hash_1 = texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xyz;
            occlusion.x = hash_1.x;
            occlusion.y = hash_1.y;
            occlusion.z = hash_1.z;
            occlusion.w = hash_1.x;
        }
        occlusion_all[i] = occlusion;
    }
    for (int i_1 = 0; i_1 < 4; i_1++)
    {
        ivec2 pos_1 = ivec2((pixel_pos * uvec2(2u)) + _972[i_1]);
        ivec2 noise_pos_1 = pos_1 & ivec2(127);
        vec4 occlusion_1 = occlusion_all[i_1];
        occlusion_1.w = clamp(occlusion_1.w, 0.0, 1.0);
        imageStore(imTarget, pos_1, max(occlusion_1, vec4(0.0)));
    }
}

 