#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct GTAOParams
{
    float radius_multiplier;
    float _pad0;
    float _pad1;
    float _pad2;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _228;

layout(set = 0, binding = 2, std140) uniform GTAOParamsBuffer
{
    GTAOParams gtao_params;
} _389;

layout(set = 0, binding = 3, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _437;

layout(set = 0, binding = 5) uniform sampler2D sTextureDepthPyramid;
layout(set = 0, binding = 6) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 4, r16f) uniform writeonly image2D imTarget;
layout(set = 0, binding = 7) uniform sampler2DArray s_BlueNoise;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _108;
    if (nor.x > 0.0)
    {
        _108 = -t;
    }
    else
    {
        _108 = t;
    }
    nor.x += _108;
    float _123;
    if (nor.y > 0.0)
    {
        _123 = -t;
    }
    else
    {
        _123 = t;
    }
    nor.y += _123;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec4 GetViewPosition(vec2 pos, float currstep)
{
    int miplevel = clamp(int(floor(log2(currstep / 8.0))), 0, 4);
    vec2 mipcoord = (pos + vec2(0.5)) * _228.dispatch_setup.inv_resolution;
    float d = textureLod(sTextureDepthPyramid, mipcoord, float(miplevel)).x;
    DispatchDeferredParams _249;
    _249.mat_projection = _228.dispatch_setup.mat_projection;
    _249.mat_projection_previous = _228.dispatch_setup.mat_projection_previous;
    _249.mat_model = _228.dispatch_setup.mat_model;
    _249.mat_model_previous = _228.dispatch_setup.mat_model_previous;
    _249.mat_view_inverse = _228.dispatch_setup.mat_view_inverse;
    _249.mat_view_previous = _228.dispatch_setup.mat_view_previous;
    _249.camera_position = _228.dispatch_setup.camera_position;
    _249.camera_projection_params = _228.dispatch_setup.camera_projection_params;
    _249.camera_projection_params_previous = _228.dispatch_setup.camera_projection_params_previous;
    _249.near_far_plane = _228.dispatch_setup.near_far_plane;
    _249.resolution = _228.dispatch_setup.resolution;
    _249.inv_resolution = _228.dispatch_setup.inv_resolution;
    _249.frustum_shift = _228.dispatch_setup.frustum_shift;
    DispatchDeferredParams param = _249;
    vec2 param_1 = pos;
    vec3 view_direction = deferred_get_view_direction_from_screen_pos(param, param_1);
    return vec4(view_direction * d, 1.0);
}

bool validate_sample_pos(vec2 p)
{
    bool _273 = p.x >= 0.0;
    bool _279;
    if (_273)
    {
        _279 = p.y >= 0.0;
    }
    else
    {
        _279 = _273;
    }
    bool _288;
    if (_279)
    {
        _288 = p.x < _228.dispatch_setup.resolution.x;
    }
    else
    {
        _288 = _279;
    }
    bool _296;
    if (_288)
    {
        _296 = p.y < _228.dispatch_setup.resolution.y;
    }
    else
    {
        _296 = _288;
    }
    if (_296)
    {
        return true;
    }
    return false;
}

float Falloff(float dist2, float _cosh)
{
    return 2.0 * clamp((dist2 - 0.01600000075995922088623046875) / 9.98400020599365234375, 0.0, 1.0);
}

void main()
{
    uvec2 workgroup_id = gl_WorkGroupID.xy;
    uvec2 local_thread_id = gl_LocalInvocationID.xy;
    uvec2 thread_id = (workgroup_id * uvec2(8u)) + local_thread_id;
    ivec2 loc = ivec2(thread_id);
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(thread_id), 0).x;
    uint param = encoded_normal_material;
    vec3 _341 = decode_normal(param);
    vec3 normal = _341;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    bool is_background = (materialId & 1) == 1;
    vec3 local_normal;
    local_normal.x = dot(normal, _228.dispatch_setup.mat_model[0].xyz);
    local_normal.y = dot(normal, _228.dispatch_setup.mat_model[1].xyz);
    local_normal.z = dot(normal, _228.dispatch_setup.mat_model[2].xyz);
    normal = local_normal;
    if (is_background)
    {
        imageStore(imTarget, ivec2(thread_id), vec4(1.0));
        return;
    }
    float d_scale = 1.0 / (1.0 + _389.gtao_params.radius_multiplier);
    vec2 param_2 = vec2(loc);
    float param_3 = 1.0;
    vec4 vpos = GetViewPosition(param_2, param_3);
    if (is_background)
    {
        imageStore(imTarget, ivec2(thread_id), vec4(0.0));
        return;
    }
    vec3 vnorm = normal;
    vec3 vdir = normalize(-vpos.xyz);
    vec2 noises = fract(texelFetch(s_BlueNoise, ivec3(ivec2(thread_id & uvec2(127u)), 0), 0).xy + vec2(float(_437.globals.monotonic & 1023) * 1.61803400516510009765625));
    noises.x = (noises.x * 2.0) - 1.0;
    float radius = (2.0 * _228.dispatch_setup.near_far_plane.y) / (vpos.z * d_scale);
    radius = max(radius, 8.0);
    radius = min(radius, 512.0);
    float stepsize = radius / 8.0;
    float ao = 0.0;
    vec4 s;
    vec3 ws;
    float dist2;
    float invdist;
    float ch;
    float falloff;
    for (int split = 0; split < 3; split++)
    {
        vec2 horizons = vec2(-1.0);
        float phi = noises.x + (float(split) * 0.3333333432674407958984375);
        if (phi > 1.0)
        {
            phi -= 1.0;
        }
        if (phi < 0.0)
        {
            phi += 1.0;
        }
        phi *= 3.1415927410125732421875;
        float division = noises.y * stepsize;
        float currstep = 1.0 + division;
        vec3 dir = vec3(cos(phi), sin(phi), 0.0);
        for (int j = 0; j < 8; j++)
        {
            vec2 offset_dir = vec2(dir.x, -dir.y);
            vec2 offset = round(offset_dir * currstep);
            ivec2 ioffset = ivec2(round(offset_dir * currstep));
            vec2 param_4 = vec2(thread_id) + offset;
            if (validate_sample_pos(param_4))
            {
                vec2 param_5 = vec2(thread_id) + offset;
                float param_6 = currstep;
                s = GetViewPosition(param_5, param_6);
                ws = s.xyz - vpos.xyz;
                ws *= d_scale;
                dist2 = dot(ws, ws);
                invdist = inversesqrt(dist2);
                ch = invdist * dot(ws, vdir);
                float param_7 = dist2;
                float param_8 = ch;
                falloff = Falloff(param_7, param_8);
                horizons.x = max(horizons.x, ch - falloff);
            }
            vec2 param_9 = vec2(thread_id) - offset;
            if (validate_sample_pos(param_9))
            {
                vec2 param_10 = vec2(thread_id) - offset;
                float param_11 = currstep;
                s = GetViewPosition(param_10, param_11);
                ws = s.xyz - vpos.xyz;
                ws *= d_scale;
                dist2 = dot(ws, ws);
                invdist = inversesqrt(dist2);
                ch = invdist * dot(ws, vdir);
                float param_12 = dist2;
                float param_13 = ch;
                falloff = Falloff(param_12, param_13);
                horizons.y = max(horizons.y, ch - falloff);
            }
            currstep += stepsize;
        }
        horizons = acos(horizons);
        vec3 bitangent = normalize(cross(dir, vdir));
        vec3 tangent = cross(vdir, bitangent);
        vec3 nx = vnorm - (bitangent * dot(vnorm, bitangent));
        float nnx = length(nx);
        float invnnx = 1.0 / (nnx + 9.9999999747524270787835121154785e-07);
        float cosxi = dot(nx, tangent) * invnnx;
        float gamma = acos(cosxi) - 1.57079637050628662109375;
        float cosgamma = dot(nx, vdir) * invnnx;
        float singamma2 = (-2.0) * cosxi;
        horizons.x = gamma + max((-horizons.x) - gamma, -1.57079637050628662109375);
        horizons.y = gamma + min(horizons.y - gamma, 1.57079637050628662109375);
        ao += (nnx * ((((horizons.x * singamma2) + cosgamma) - cos((2.0 * horizons.x) - gamma)) + (((horizons.y * singamma2) + cosgamma) - cos((2.0 * horizons.y) - gamma))));
    }
    ao *= 0.25;
    ao /= 3.0;
    imageStore(imTarget, ivec2(thread_id), vec4(max(0.0, ao)));
}

 